/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.eclipse;

import java.awt.Image;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.maps.query.Query;
import org.simantics.maps.tile.ITileProvider;
import org.simantics.maps.tile.TileKey;

public class TileJob
extends Job {
    private ITileProvider provider;
    private Query<TileKey, Image> query;

    public TileJob(Query<TileKey, Image> query, ITileProvider provider) {
        super("Raster Map Request Job");
        assert (query != null);
        this.query = query;
        this.provider = provider;
    }

    public Query<TileKey, Image> getQuery() {
        return this.query;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.setThread(Thread.currentThread());
        monitor.beginTask("Querying map data", 1);
        try {
            if (monitor.isCanceled()) {
                this.cancel();
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            try {
                monitor.subTask(((TileKey)this.query.source).toString());
                Image result = this.provider.get((TileKey)this.query.source);
                this.query.listener.queryComplete(this.query, result);
            }
            catch (Exception e) {
                this.query.listener.queryFailed(this.query, e);
            }
            monitor.worked(1);
            monitor.subTask("");
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

