/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.eclipse;

import java.awt.geom.AffineTransform;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.maps.sg.MapNode;
import org.simantics.maps.sg.MapScaleNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class MapPainter
extends AbstractCanvasParticipant {
    public static final IHintContext.Key KEY_MAP_ENABLED = new IHintContext.KeyOf(Boolean.class);
    public static final double ZOOM_IN_LIMIT = 1.0E7;
    public static final double ZOOM_OUT_LIMIT = 10.0;
    IHintListener mapListener = new HintListenerAdapter(){

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            ICanvasContext cc = MapPainter.this.getContext();
            if (cc != null) {
                MapPainter.this.updateNode();
                cc.getContentContext().setDirty();
            }
        }
    };
    protected MapNode node = null;
    protected MapScaleNode scaleNode = null;
    private AffineTransform transform;

    public MapPainter(AffineTransform transform) {
        this.transform = transform;
    }

    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.getHintStack().addKeyHintListener(this.getThread(), KEY_MAP_ENABLED, this.mapListener);
    }

    public void removedFromContext(ICanvasContext ctx) {
        this.getHintStack().removeKeyHintListener(this.getThread(), KEY_MAP_ENABLED, this.mapListener);
        super.removedFromContext(ctx);
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleKeyEvent(CommandEvent e) {
        if (e.command.equals((Object)Commands.MAP_ENABLE)) {
            this.setEnabled(true);
            this.updateNode();
            this.setDirty();
            return true;
        }
        if (e.command.equals((Object)Commands.MAP_DISABLE)) {
            this.setEnabled(false);
            this.updateNode();
            this.setDirty();
            return true;
        }
        if (e.command.equals((Object)Commands.MAP_TOGGLE)) {
            this.setEnabled(!this.isMapEnabled());
            this.updateNode();
            this.setDirty();
            return true;
        }
        return false;
    }

    @SGNodeReflection.SGInit
    public void initSG(G2DParentNode parent) {
        this.node = (MapNode)parent.addNode("map", MapNode.class);
        this.node.setTransform(this.transform);
        this.node.setEnabled(true);
        this.node.setZIndex(-2147482649);
        this.scaleNode = (MapScaleNode)((Object)parent.addNode("mapScale", MapScaleNode.class));
        this.scaleNode.setTransform(this.transform);
        this.scaleNode.setEnabled(true);
        this.scaleNode.setZIndex(2147482648);
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
        this.node.remove();
    }

    protected void updateNode() {
        this.node.setEnabled(this.isPaintingEnabled());
    }

    boolean isPaintingEnabled() {
        boolean enabled = this.isMapEnabled();
        Boolean globalDisable = (Boolean)this.getHint(Hints.KEY_DISABLE_PAINTING);
        return enabled && !Boolean.TRUE.equals(globalDisable);
    }

    public boolean isMapEnabled() {
        Boolean enabled = (Boolean)this.getHint(KEY_MAP_ENABLED);
        return !Boolean.FALSE.equals(enabled);
    }

    public void setEnabled(boolean enabled) {
        this.setHint(KEY_MAP_ENABLED, enabled);
    }
}

