/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.maps.server;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.simantics.district.maps.server.prefs.MapsServerPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.StartedProcess;
import org.zeroturnaround.exec.stream.slf4j.Slf4jDebugOutputStream;
import org.zeroturnaround.process.PidProcess;
import org.zeroturnaround.process.PidUtil;
import org.zeroturnaround.process.Processes;
import org.zeroturnaround.process.SystemProcess;

public class TileserverMapnik {
    private static final Logger LOGGER = LoggerFactory.getLogger(TileserverMapnik.class);
    private SystemProcess process;
    private Path serverRoot;
    private AtomicBoolean running = new AtomicBoolean(false);

    TileserverMapnik(Path serverRoot) {
        this.serverRoot = serverRoot.normalize();
    }

    public boolean isRunning() throws IOException, InterruptedException {
        return this.process == null ? false : this.process.isAlive() && this.isReady();
    }

    public boolean isReady() {
        return this.running.get();
    }

    public void start(Optional<TileserverStartListener> listener) throws Exception {
        Path tiles;
        if (Files.exists(this.getPid(), new LinkOption[0])) {
            String pid = new String(Files.readAllBytes(this.getPid()));
            PidProcess pr = Processes.newPidProcess((int)Integer.parseInt(pid));
            try {
                pr.destroyForcefully();
            }
            catch (InvalidExitValueException invalidExitValueException) {
            }
            catch (Exception e) {
                LOGGER.error("Could not destroy process with pid {}", (Object)pid, (Object)e);
            }
        }
        if ((tiles = this.getCurrentTiles()) == null) {
            return;
        }
        this.checkConfigJson();
        this.checkTm2Styles();
        if (this.process != null && this.process.isAlive()) {
            return;
        }
        Path tileliveTesseraWin = this.serverRoot.resolve("dist").resolve("node.exe").normalize().toAbsolutePath();
        StartedProcess startedProcess = new ProcessExecutor().directory(this.serverRoot.resolve("dist").toFile()).destroyOnExit().environment(this.getEnv()).command(new String[]{tileliveTesseraWin.toString(), "-c", this.getConfigJson().toString(), "-p", Integer.toString(MapsServerPreferences.defaultPort())}).redirectOutput((OutputStream)new Slf4jDebugOutputStream(LOGGER){

            protected void processLine(String line) {
                String utf8Line = new String(line.getBytes(), StandardCharsets.UTF_8);
                this.log.debug(utf8Line);
            }
        }).start();
        Process nativeProcess = startedProcess.getProcess();
        this.process = Processes.newStandardProcess((Process)nativeProcess);
        int pid = PidUtil.getPid((Process)nativeProcess);
        LOGGER.info("Writing pid-file to {} with pid={}", (Object)this.getPid(), (Object)pid);
        Files.write(this.getPid(), ("" + pid).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        this.running.set(true);
        listener.ifPresent(TileserverStartListener::started);
    }

    private Map<String, String> getEnv() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("MAPNIK_FONT_PATH", this.getFonts().toString());
        env.put("ICU_DATA", this.getICU().toString());
        return env;
    }

    public void stop() throws IOException, InterruptedException {
        if (this.process != null && this.process.isAlive()) {
            this.process.destroyForcefully();
            if (!this.process.waitFor(2000L, TimeUnit.MILLISECONDS)) {
                this.process.destroyForcefully();
                if (this.process.isAlive()) {
                    LOGGER.error("Could not shutdown TileserverMapnik!");
                }
            }
            this.process = null;
            Files.delete(this.getPid());
            this.running.set(false);
        }
    }

    private Path getPid() {
        return this.serverRoot.resolve("pid");
    }

    public void restart(Optional<TileserverStartListener> listener) throws Exception {
        this.stop();
        this.start(listener);
    }

    private Path tileserverMapnikRoot() {
        return this.serverRoot.resolve("tileserver-mapnik").toAbsolutePath();
    }

    private Path getFonts() {
        return this.serverRoot.resolve("fonts").toAbsolutePath();
    }

    private Path getICU() {
        return this.serverRoot.resolve("dist/share/icu").toAbsolutePath();
    }

    private Path getTessera() {
        return this.serverRoot.resolve("tileserver-mapnik/bin/tessera.js").toAbsolutePath();
    }

    private Path getConfigJson() {
        return this.serverRoot.resolve("config.json").toAbsolutePath();
    }

    public List<String> availableMBTiles() throws IOException {
        Path data = this.getDataDirectory();
        ArrayList<String> result = new ArrayList<String>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream<Path> paths = Files.walk(data, new FileVisitOption[0]);){
            paths.forEach(p -> {
                String tiles;
                if (!p.equals(data) && (tiles = p.getFileName().toString()).toLowerCase().endsWith(".mbtiles")) {
                    result.add(tiles);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    private void checkConfigJson() throws JsonParseException, JsonMappingException, IOException {
        Path configJson = this.getConfigJson();
        HashMap config = new HashMap();
        Path tm2 = this.getStyleDirectory();
        Throwable throwable = null;
        Object var5_6 = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(tm2);){
            stream.forEach(p -> {
                Path projectYaml = p.resolve("project.yml");
                if (Files.exists(projectYaml, new LinkOption[0])) {
                    HashMap<String, CallSite> source = new HashMap<String, CallSite>();
                    Path tm2style = this.serverRoot.relativize(projectYaml.getParent());
                    String prefix = "tmstyle://../";
                    String tmStyle = prefix + tm2style.toString();
                    source.put("source", (CallSite)((Object)tmStyle));
                    config.put("/" + projectYaml.getParent().getFileName().toString(), source);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.writerWithDefaultPrettyPrinter().writeValue(Files.newOutputStream(configJson, StandardOpenOption.TRUNCATE_EXISTING), config);
    }

    public Path getStyleDirectory() {
        return this.serverRoot.resolve("tm2");
    }

    public Path getDataDirectory() {
        return this.serverRoot.resolve("data");
    }

    public Path getCurrentTiles() {
        Path p = this.getDataDirectory().resolve(MapsServerPreferences.currentMBTiles());
        return Files.exists(p, new LinkOption[0]) ? p : null;
    }

    public void checkTm2Styles() {
        Path tm2 = this.getStyleDirectory();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(tm2);){
                stream.forEach(p -> {
                    Path projectYaml = p.resolve("project.yml");
                    Yaml yaml = new Yaml();
                    Map data = null;
                    try {
                        Throwable throwable = null;
                        Object var6_9 = null;
                        try (InputStream input = Files.newInputStream(projectYaml, StandardOpenOption.READ);){
                            data = (Map)yaml.loadAs(input, Map.class);
                            Path tiles = this.serverRoot.relativize(this.getCurrentTiles());
                            String tmStyle = "mbtiles://../" + tiles.toString();
                            data.put("source", tmStyle);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Could not read yaml", (Throwable)e);
                    }
                    try {
                        Files.write(projectYaml, yaml.dump(data).getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
                    }
                    catch (IOException e) {
                        LOGGER.error("Could not write yaml", (Throwable)e);
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not browse tm2 styles", (Throwable)e);
        }
    }

    public List<String> listStyles() throws IOException {
        ArrayList<String> results = new ArrayList<String>();
        Path tm2 = this.getStyleDirectory();
        Throwable throwable = null;
        Object var4_5 = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(tm2);){
            stream.forEach(p -> results.add(p.getFileName().toString()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return results;
    }

    public static interface TileserverStartListener {
        public void installing(String var1);

        public void installationFailed(String var1, int var2);

        public void started();
    }
}

