/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.route.internal;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.ListenerList;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.procedure.adapter.DisposableListener;
import org.simantics.db.common.procedure.adapter.DisposableSyncListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleActiveModel;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextChangedListener;
import org.simantics.db.management.SessionContextChangedEvent;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.request.Read;
import org.simantics.district.route.Route;
import org.simantics.district.route.RouteEvent;
import org.simantics.district.route.RouteService;
import org.simantics.district.route.RouteServiceListener;
import org.simantics.district.route.Router;
import org.simantics.district.route.internal.RouteImpl;
import org.simantics.district.route.internal.RoutePersistence;
import org.simantics.district.route.internal.RoutePersistenceJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteServiceImpl
implements RouteService,
ISessionContextChangedListener,
Closeable {
    private final Logger LOGGER = LoggerFactory.getLogger(RouteServiceImpl.class);
    private ListenerList<RouteServiceListener> listeners = new ListenerList();
    private List<Route> routes = new ArrayList<Route>();
    private List<Route> unmodifiableRoutes = Collections.unmodifiableList(this.routes);
    private List<Router> routers = new ArrayList<Router>();
    private List<Router> unmodifiableRouters = Collections.unmodifiableList(this.routers);
    private StoreRoutesListener storeRoutesListener;
    private StoreListener storeListener;

    private synchronized void listenToActiveModels(Session s) {
        StoreListener sl = this.storeListener;
        if (sl != null) {
            sl.dispose();
        }
        if (s != null) {
            this.storeListener = new StoreListener();
            s.asyncRequest((Read)new PossibleActiveModel(Simantics.getProjectResource()), (SyncListener)this.storeListener);
        } else {
            this.resetRoutes(Collections.emptyList());
        }
    }

    void resetRoutes(List<RouteImpl> newRoutes) {
        this.routes.clear();
        newRoutes.forEach(r -> {
            RouteImpl routeImpl = r.routeService(this);
        });
        this.routes.addAll(newRoutes);
    }

    public void sessionContextChanged(SessionContextChangedEvent event) {
        ISessionContext ctx = event.getNewValue();
        Session s = ctx != null ? ctx.getSession() : null;
        this.listenToActiveModels(s);
    }

    public RouteServiceImpl() {
        Session s = Simantics.peekSession();
        Simantics.getSessionContextProvider().addContextChangedListener((ISessionContextChangedListener)this);
        if (s != null) {
            this.listenToActiveModels(s);
        }
    }

    @Override
    public void close() {
        Simantics.getSessionContextProvider().removeContextChangedListener((ISessionContextChangedListener)this);
    }

    @Override
    public void addListener(RouteServiceListener l) {
        this.listeners.add((Object)l);
    }

    @Override
    public void removeListener(RouteServiceListener l) {
        this.listeners.remove((Object)l);
    }

    @Override
    public Route createRoute(String name, Object backendModelEntity) {
        RouteImpl r = new RouteImpl(name).modelEntity((Resource)backendModelEntity).routeService(this);
        this.fireEvent(3, r);
        return r;
    }

    @Override
    public void registerRoute(Route route) {
        this.routes.add(route);
        this.fireEvent(4, route);
    }

    @Override
    public void refreshRoute(Route route) {
        this.fireEvent(8, route);
    }

    @Override
    public CompletableFuture<Route> persistRoute(Route route) {
        this.fireEvent(9, route);
        CompletableFuture<Route> future = new CompletableFuture<Route>();
        new RoutePersistenceJob((RouteImpl)route, 9, future).schedule();
        future.thenAccept(r -> this.fireEvent(10, r));
        return future;
    }

    public CompletableFuture<Route> discardRoute(Route route) {
        this.fireEvent(5, route);
        CompletableFuture<Route> result = new CompletableFuture<Route>();
        RouteImpl ri = (RouteImpl)route;
        result.thenAccept(r -> {
            this.routes.remove(route);
            this.fireEvent(6, route);
        });
        if (ri.backend() != null) {
            new RoutePersistenceJob(ri, 5, result).schedule();
        } else {
            result.complete(route);
        }
        return result;
    }

    @Override
    public List<Route> listRoutes() {
        return this.unmodifiableRoutes;
    }

    @Override
    public void registerRouter(Router router) {
        this.routers.add(router);
        this.fireEvent(1, router);
    }

    @Override
    public void unregisterRouter(Router router) {
        this.routers.add(router);
        this.fireEvent(2, router);
    }

    @Override
    public List<Router> routers() {
        return this.unmodifiableRouters;
    }

    void fireEvent(int type, Object obj) {
        RouteEvent e = new RouteEvent(this, type, obj);
        this.LOGGER.debug("firing route event {}", (Object)e);
        this.listeners.forEach(l -> {
            try {
                l.handleEvent(e);
            }
            catch (AssertionError | Exception | LinkageError ex) {
                this.LOGGER.error("Failed to invoke RouteListener {}", l, ex);
            }
        });
    }

    @Override
    public Route readRoute(Object backendRouteObject) {
        if (!(backendRouteObject instanceof Resource)) {
            return null;
        }
        try {
            return (Route)Simantics.getSession().syncRequest((Read)new RoutePersistence.RouteRequest((Resource)backendRouteObject));
        }
        catch (DatabaseException e) {
            this.LOGGER.error("Failed to read district route object for " + String.valueOf(backendRouteObject), (Throwable)e);
            return null;
        }
    }

    private class StoreListener
    extends DisposableSyncListener<Resource> {
        private StoreListener() {
        }

        public void execute(ReadGraph graph, Resource activeModel) {
            if (activeModel != null) {
                StoreRoutesListener srl = RouteServiceImpl.this.storeRoutesListener;
                if (srl != null) {
                    srl.dispose();
                }
                RouteServiceImpl.this.storeRoutesListener = new StoreRoutesListener();
                Simantics.getSession().asyncRequest((Read)new RoutePersistence.ModelRoutesRequest(activeModel), (Listener)RouteServiceImpl.this.storeRoutesListener);
            } else {
                RouteServiceImpl.this.resetRoutes(Collections.emptyList());
                RouteServiceImpl.this.fireEvent(11, RouteServiceImpl.this);
            }
        }

        public void exception(ReadGraph graph, Throwable t) {
            LOGGER.error("Failed to listen to current route service storage", t);
        }
    }

    private class StoreRoutesListener
    extends DisposableListener<List<RouteImpl>> {
        private StoreRoutesListener() {
        }

        public void execute(List<RouteImpl> result) {
            RouteServiceImpl.this.resetRoutes(result);
            RouteServiceImpl.this.fireEvent(11, RouteServiceImpl.this);
        }

        public void exception(Throwable t) {
            LOGGER.error("Failed to listen to current route store routes", t);
        }
    }
}

