/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.route.ui.actions;

import java.util.concurrent.CompletableFuture;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Read;
import org.simantics.district.route.Route;
import org.simantics.district.route.RouteJob;
import org.simantics.district.route.RouterConfiguration;
import org.simantics.district.route.internal.RoutePersistence;
import org.simantics.utils.ui.dialogs.ShowMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateRouteAction
implements ActionFactory {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ValidateRouteAction.class);

    public Runnable create(final Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        return new Runnable(){

            @Override
            public void run() {
                try {
                    Route route = (Route)Simantics.getSession().syncRequest((Read)new RoutePersistence.RouteRequest((Resource)target));
                    if (route == null) {
                        ShowMessage.showInformation((String)"Route Validation", (String)"Reading the route object failed");
                        LOGGER.error("Reading a route object failed");
                        return;
                    }
                    CompletableFuture result = new CompletableFuture();
                    ((CompletableFuture)result.exceptionally(e -> null)).thenAccept(dnElements -> {
                        if (dnElements != null) {
                            if (!dnElements.isEmpty()) {
                                ShowMessage.showInformation((String)"Route Validation", (String)"The route is valid");
                            } else {
                                ShowMessage.showInformation((String)"Route Validation", (String)"The route produced an empty list of vertices");
                            }
                        }
                    });
                    RouterConfiguration config = new RouterConfiguration();
                    new RouteJob(config, route, result).schedule();
                }
                catch (DatabaseException e2) {
                    LOGGER.error("Error in selecting route " + String.valueOf(target), (Throwable)e2);
                }
            }
        };
    }
}

