/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.region;

import java.awt.Shape;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.db.layer0.request.PossibleActiveModel;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.district.region.ontology.DiagramRegionsResource;
import org.simantics.layer0.Layer0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiagramRegions {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiagramRegions.class);

    public static Resource createRegionForDiagram(WriteGraph graph, Resource diagram, String label, double[] coordinates) throws DatabaseException {
        if (coordinates == null || coordinates.length < 6 || coordinates.length % 2 != 0) {
            throw new IllegalArgumentException("Provided coordinates are not valid : " + Arrays.toString(coordinates));
        }
        Path2D.Double path = new Path2D.Double();
        double startX = coordinates[0];
        double startY = coordinates[1];
        ((Path2D)path).moveTo(startX, startY);
        int i = 2;
        while (i < coordinates.length) {
            ((Path2D)path).lineTo(coordinates[i], coordinates[++i]);
            ++i;
        }
        path.closePath();
        DiagramRegionsResource DRR = DiagramRegionsResource.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource region = graph.newResource();
        graph.claim(region, L0.InstanceOf, DRR.Region);
        graph.claim(diagram, DRR.hasRegion, region);
        graph.claim(region, DRR.regionOf, diagram);
        graph.claimLiteral(region, L0.HasName, (Object)UUID.randomUUID().toString(), (Binding)Bindings.STRING);
        graph.claimLiteral(region, L0.HasLabel, (Object)label, (Binding)Bindings.STRING);
        graph.claimLiteral(region, DRR.Region_area, (Object)coordinates, (Binding)Bindings.DOUBLE_ARRAY);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Created region for diagram {} with label {} and area {}", new Object[]{diagram, label, Arrays.toString(coordinates)});
        }
        return region;
    }

    public static void removeRegion(WriteGraph graph, Resource region) throws DatabaseException {
        RemoverUtil.remove((WriteGraph)graph, (Resource)region);
    }

    public static Collection<DiagramRegion> findRegions(ReadGraph graph, Resource model) throws DatabaseException {
        if (model == null) {
            return Collections.emptyList();
        }
        List diagrams = QueryIndexUtils.searchByType((ReadGraph)graph, (Resource)model, (Resource)DiagramResource.getInstance((ReadGraph)graph).Diagram);
        HashSet<DiagramRegion> regions = new HashSet<DiagramRegion>();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource diagram : diagrams) {
            Collection region = graph.getObjects(diagram, DiagramRegionsResource.getInstance((ReadGraph)graph).hasRegion);
            for (Resource r : region) {
                String label = (String)graph.getRelatedValue(r, L0.HasLabel, (Binding)Bindings.STRING);
                Shape coordinatesToShape = DiagramRegions.coordinatesToShape(graph, r);
                regions.add(new DiagramRegion(r, label, coordinatesToShape));
            }
        }
        return regions;
    }

    public static Shape coordinatesToShape(ReadGraph graph, Resource region) throws DatabaseException {
        DiagramRegionsResource DRR = DiagramRegionsResource.getInstance((ReadGraph)graph);
        double[] coordinates = (double[])graph.getRelatedValue(region, DRR.Region_area, (Binding)Bindings.DOUBLE_ARRAY);
        Path2D.Double path = new Path2D.Double();
        double startX = coordinates[0];
        double startY = coordinates[1];
        ((Path2D)path).moveTo(startX, startY);
        int i = 2;
        while (i < coordinates.length) {
            ((Path2D)path).lineTo(coordinates[i], coordinates[++i]);
            ++i;
        }
        path.closePath();
        return path;
    }

    public static double[] shapeToCoordinates(Shape shape) {
        FlatteningPathIterator it = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        double[] points = new double[6];
        double moveX = 0.0;
        double moveY = 0.0;
        double thisX = 0.0;
        double thisY = 0.0;
        int type = 0;
        ArrayList<Double> coords = new ArrayList<Double>();
        while (!it.isDone()) {
            type = it.currentSegment(points);
            switch (type) {
                case 0: {
                    moveX = points[0];
                    moveY = points[1];
                    coords.add(moveX);
                    coords.add(moveY);
                    break;
                }
                case 4: {
                    points[0] = moveX;
                    points[1] = moveY;
                    break;
                }
                case 1: {
                    thisX = points[0];
                    thisY = points[1];
                    coords.add(thisX);
                    coords.add(thisY);
                }
            }
            it.next();
        }
        double[] finalCoords = new double[coords.size()];
        int i = 0;
        while (i < coords.size()) {
            double d;
            finalCoords[i] = d = ((Double)coords.get(i)).doubleValue();
            ++i;
        }
        return finalCoords;
    }

    public static Resource getDiagramForRegion(ReadGraph graph, Resource region) throws DatabaseException {
        DiagramRegionsResource DRR = DiagramRegionsResource.getInstance((ReadGraph)graph);
        Resource diagram = graph.getSingleObject(region, DRR.regionOf);
        return diagram;
    }

    public static class DiagramRegion {
        private Resource resource;
        private String label;
        private Shape shape;

        public DiagramRegion(Resource resource, String label, Shape coordinatesToShape) {
            this.resource = resource;
            this.label = label;
            this.shape = coordinatesToShape;
        }

        public Resource getResource() {
            return this.resource;
        }

        public String getLabel() {
            return this.label;
        }

        public Shape getShape() {
            return this.shape;
        }
    }

    public static class DiagramRegionsRequest
    extends UniqueRead<Collection<DiagramRegion>> {
        public Collection<DiagramRegion> perform(ReadGraph graph) throws DatabaseException {
            return DiagramRegions.findRegions(graph, (Resource)graph.syncRequest((Read)new PossibleActiveModel(Simantics.getProjectResource())));
        }
    }
}

