/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.techtype.requests;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TechTypeTableRecords
extends ResourceRead<List<Map<String, String>>> {
    static final Logger LOGGER = LoggerFactory.getLogger(TechTypeTableRecords.class);

    public TechTypeTableRecords(Resource resource) {
        super(resource);
    }

    public List<Map<String, String>> perform(ReadGraph graph) throws DatabaseException {
        Resource table = this.resource;
        String data = (String)graph.getRelatedValue2(table, DistrictNetworkResource.getInstance((ReadGraph)graph).TechType_TechTypeTable_HasData);
        if (data == null) {
            return null;
        }
        long ncommas = data.chars().filter(c -> c == 44).count();
        long nsemis = data.chars().filter(c -> c == 59).count();
        char delim = nsemis > ncommas ? (char)';' : ',';
        StringReader reader = new StringReader(data);
        ArrayList<CSVRecord> records = new ArrayList<CSVRecord>();
        try {
            CSVFormat format = CSVFormat.newFormat((char)delim).withQuote('\"');
            Throwable throwable = null;
            Object var13_13 = null;
            try (CSVParser parser = format.parse((Reader)reader);){
                Iterator it = parser.iterator();
                while (it.hasNext()) {
                    records.add((CSVRecord)it.next());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Error reading CSV data", (Throwable)e);
            throw new DatabaseException("Invalid CSV data in table " + String.valueOf(table), (Throwable)e);
        }
        CSVRecord header = (CSVRecord)records.remove(0);
        records.remove(0);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (CSVRecord r : records) {
            HashMap<String, String> valueMap = new HashMap<String, String>();
            result.add(valueMap);
            Iterator h = header.iterator();
            Iterator v = r.iterator();
            while (h.hasNext() && v.hasNext()) {
                String name = ((String)h.next()).trim().intern();
                String value = ((String)v.next()).trim();
                valueMap.put(name, value);
            }
        }
        return result;
    }
}

