/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.techtype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.util.Range;
import org.simantics.databoard.util.RangeException;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.techtype.requests.PossibleTechTypeKeyName;
import org.simantics.district.network.techtype.requests.TechTypeTableData;
import org.simantics.layer0.Layer0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TechTypeValidationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TechTypeValidationUtils.class);

    public static Set<String> validateTechTypeTable(final Resource table) throws DatabaseException {
        LOGGER.trace("Validating resource table {}", (Object)table);
        return (Set)Simantics.getSession().syncRequest((Read)new UniqueRead<Set<String>>(){

            public Set<String> perform(ReadGraph graph) throws DatabaseException {
                Resource type = graph.getPossibleObject(table, DistrictNetworkResource.getInstance((ReadGraph)graph).TechType_TechTypeTable_HasComponentType);
                if (type == null) {
                    return Collections.emptySet();
                }
                Map props = (Map)graph.syncRequest((Read)new PropertyInfoMapOfType(type), (Listener)TransientCacheListener.instance());
                HashSet<String> result = new HashSet<String>();
                Map data = (Map)graph.syncRequest((Read)new TechTypeTableData(table), (Listener)TransientCacheListener.instance());
                for (String code : data.keySet()) {
                    LOGGER.trace("  type code {}", (Object)code);
                    Map values = (Map)data.get(code);
                    for (String propertyName : values.keySet()) {
                        Range rng;
                        String range;
                        PropertyInfo info = (PropertyInfo)props.get(propertyName);
                        if (info == null) {
                            info = (PropertyInfo)props.get("_" + propertyName);
                        }
                        if (info == null) {
                            LOGGER.trace("    {} - no property", (Object)propertyName);
                            continue;
                        }
                        Datatype dt = info.requiredDatatype;
                        if (dt == null || !(dt instanceof NumberType) || (range = (String)dt.metadata.get("range")) == null) continue;
                        try {
                            rng = Range.valueOf((String)range);
                        }
                        catch (RangeException e1) {
                            LOGGER.error("Invalid range string {} for property {}", new Object[]{range, propertyName, e1});
                            continue;
                        }
                        Number value = TechTypeValidationUtils.getPossibleNumericValue(info, (String)values.get(propertyName));
                        if (value == null) {
                            LOGGER.trace("    {} - no value {} / {}", new Object[]{propertyName, values.get(propertyName), range});
                            continue;
                        }
                        if (!rng.contains(value)) {
                            LOGGER.trace("    {} - range violation {} / {}", new Object[]{propertyName, values.get(propertyName), range});
                            result.add(code + "/" + propertyName);
                            continue;
                        }
                        LOGGER.trace("    {} - valid value {} / {}", new Object[]{propertyName, values.get(propertyName), range});
                    }
                }
                return result;
            }
        });
    }

    public static Map<Resource, List<PropertyInfo>> findConsistencyViolations(final Resource table) throws DatabaseException {
        LOGGER.trace("Validating resource table {}", (Object)table);
        return (Map)Simantics.getSession().syncRequest((Read)new UniqueRead<Map<Resource, List<PropertyInfo>>>(){

            public Map<Resource, List<PropertyInfo>> perform(ReadGraph graph) throws DatabaseException {
                Resource type = graph.getPossibleObject(table, DistrictNetworkResource.getInstance((ReadGraph)graph).TechType_TechTypeTable_HasComponentType);
                if (type == null) {
                    return Collections.emptyMap();
                }
                Resource model = (Resource)graph.syncRequest((Read)new IndexRoot(table));
                Map props = (Map)graph.syncRequest((Read)new PropertyInfoMapOfType(type), (Listener)TransientCacheListener.instance());
                String keyName = (String)graph.syncRequest((Read)new PossibleTechTypeKeyName(type));
                PropertyInfo keyPredicate = (PropertyInfo)props.get(keyName);
                if (keyName.startsWith("_")) {
                    keyName = keyName.substring(1);
                }
                Map data = (Map)graph.syncRequest((Read)new TechTypeTableData(table), (Listener)TransientCacheListener.instance());
                HashMap<Resource, List<PropertyInfo>> result = new HashMap<Resource, List<PropertyInfo>>();
                for (Resource component : QueryIndexUtils.searchByType((ReadGraph)graph, (Resource)model, (Resource)type)) {
                    String key = (String)graph.getRelatedValue2(component, keyPredicate.predicate);
                    Map values = (Map)data.get(key);
                    if (values == null) {
                        TechTypeValidationUtils.addMapListItem(result, component, keyPredicate);
                        continue;
                    }
                    for (PropertyInfo prop : props.values()) {
                        String valueString;
                        if (!prop.isHasProperty || (valueString = (String)values.get(prop.name)) == null) continue;
                        Object value = null;
                        if (prop.requiredDatatype instanceof NumberType) {
                            value = TechTypeValidationUtils.getPossibleNumericValue(prop, valueString);
                        } else {
                            if (!(prop.requiredDatatype instanceof StringType)) continue;
                            value = valueString;
                        }
                        if (value == null) {
                            Statement statement = graph.getPossibleStatement(component, prop.predicate);
                            if (statement == null || !statement.getObject().equals(component)) continue;
                            TechTypeValidationUtils.addMapListItem(result, component, prop);
                            continue;
                        }
                        Object currentValue = graph.getRelatedValue2(component, prop.predicate);
                        if (Objects.equals(value, currentValue)) continue;
                        TechTypeValidationUtils.addMapListItem(result, component, prop);
                    }
                }
                return result;
            }
        });
    }

    private static Number getPossibleNumericValue(PropertyInfo info, String valueString) {
        try {
            Double num = Double.valueOf(valueString.replace(",", "."));
            NumberBinding binding = (NumberBinding)info.defaultBinding;
            Number value = (Number)binding.create((Number)num);
            return value;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        catch (BindingException e) {
            LOGGER.error("Binding error for property {}", (Object)info.name, (Object)e);
            return null;
        }
    }

    private static <A, B> void addMapListItem(Map<A, List<B>> result, A a, B b) {
        List<B> list = result.get(a);
        if (list == null) {
            list = new ArrayList<B>();
            result.put(a, list);
        }
        list.add(b);
    }

    private static class PropertyInfoMapOfType
    extends ResourceRead<Map<String, PropertyInfo>> {
        protected PropertyInfoMapOfType(Resource type) {
            super(type);
        }

        public Map<String, PropertyInfo> perform(ReadGraph graph) throws DatabaseException {
            HashMap<String, PropertyInfo> result = new HashMap<String, PropertyInfo>();
            for (Resource prop : graph.getObjects(this.resource, Layer0.getInstance((ReadGraph)graph).DomainOf)) {
                PropertyInfo info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(prop), (Listener)TransientCacheListener.instance());
                result.put(info.name, info);
            }
            return result;
        }
    }
}

