/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.techtype.table;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.csv.CSVRecord;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.simantics.district.imports.DistrictImportUtils;
import org.simantics.district.network.techtype.TechTypeUtils;
import org.simantics.district.network.ui.techtype.table.EnableListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TechTypeTableDataProvider
implements IDataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TechTypeTableDataProvider.class);
    private List<CSVRecord> records = new ArrayList<CSVRecord>();
    private boolean[] enabled;
    private String filter = null;
    private List<String> variables = null;
    private List<String> headers = null;
    private int[] filteredRows;
    private ListenerList<EnableListener> enableListeners = new ListenerList();
    private int[] sortedRows;
    private boolean showEnabled = true;
    private static final Comparator<? super String> VALUE_COMPARATOR = (a, b) -> {
        try {
            double da = Double.valueOf(a.replace(",", "."));
            double db = Double.valueOf(b.replace(",", "."));
            return Double.compare(da, db);
        }
        catch (NumberFormatException numberFormatException) {
            return TechTypeUtils.compareNatural((String)a, (String)b);
        }
    };

    public TechTypeTableDataProvider(String data, int[] enabledList) {
        this.setData(data);
        this.setEnabledFlags(enabledList);
        this.showEnabled = enabledList != null;
    }

    public TechTypeTableDataProvider(String data) {
        this.setData(data);
        this.showEnabled = false;
    }

    public void setEnabledFlags(int[] enabledList) {
        this.enabled = new boolean[this.records.size()];
        if (enabledList != null) {
            int[] nArray = enabledList;
            int n = enabledList.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                if (i >= 0 && i < this.enabled.length) {
                    this.enabled[i] = true;
                }
                ++n2;
            }
        }
        this.showEnabled = enabledList != null;
    }

    public boolean isCheckBoxColumn(int columnIndex) {
        return this.isEnabledColumn(columnIndex);
    }

    public String getVariableName(int columnIndex) {
        return this.variables != null && columnIndex > 0 && columnIndex <= this.variables.size() ? this.variables.get(columnIndex - this.columnOffset()) : null;
    }

    private int columnOffset() {
        return this.showEnabled ? 1 : 0;
    }

    public int getVariableIndex(String variableName) {
        return this.variables != null ? this.variables.indexOf(variableName) + this.columnOffset() : -1;
    }

    public CSVRecord getRecord(int rowIndex) {
        return this.records.get(this.recordIndex(rowIndex));
    }

    public boolean isEnabled(int rowIndex) {
        return this.enabled[this.recordIndex(rowIndex)];
    }

    private int recordIndex(int rowIndex) {
        return this.sortedRows[this.filteredRows[rowIndex]];
    }

    public String getHeaderValue(int columnIndex) {
        if (this.headers == null) {
            return "<empty>";
        }
        if (this.isEnabledColumn(columnIndex)) {
            return "Enabled";
        }
        return this.headers.get(columnIndex - this.columnOffset());
    }

    public Object getDataValue(int columnIndex, int rowIndex) {
        if (this.isEnabledColumn(columnIndex)) {
            return this.isEnabled(rowIndex);
        }
        return this.getRecord(rowIndex).get(columnIndex - this.columnOffset());
    }

    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        if (this.isEnabledColumn(columnIndex)) {
            boolean value = Boolean.parseBoolean((String)newValue);
            int index = this.recordIndex(rowIndex);
            this.enabled[index] = value;
            this.fireEnableEvent(index, value);
        }
    }

    public void addEnableListener(EnableListener listener) {
        this.enableListeners.add((Object)listener);
    }

    private void fireEnableEvent(int rowIndex, boolean newValue) {
        this.enableListeners.forEach(l -> l.rowEnabled(rowIndex, newValue));
    }

    public int getColumnCount() {
        if (this.records.isEmpty()) {
            return 0;
        }
        return this.records.get(0).size() + this.columnOffset();
    }

    public int getRowCount() {
        return this.filteredRows.length;
    }

    public boolean isEditable(int columnIndex, int rowIndex) {
        return this.isEnabledColumn(columnIndex);
    }

    private boolean isEnabledColumn(int columnIndex) {
        return this.showEnabled && columnIndex == 0;
    }

    public void setFilter(String text) {
        this.filter = text != null ? text.toLowerCase() : null;
        this.filteredRows = IntStream.range(0, this.records.size()).filter(k -> TechTypeTableDataProvider.isMatch(this.records.get(this.sortedRows[k]), this.filter)).toArray();
    }

    private static boolean isMatch(CSVRecord record, String filterString) {
        if (filterString == null || filterString.isEmpty()) {
            return true;
        }
        int i = 0;
        while (i < record.size()) {
            String columnContent = record.get(i);
            if (columnContent.toLowerCase().contains(filterString)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setPath(String path) {
        this.records.clear();
        if (path != null) {
            Path techTypeCsv = Paths.get(path, new String[0]);
            try {
                DistrictImportUtils.consumeCSV((Path)techTypeCsv, (char)';', (boolean)false, record -> {
                    this.records.add((CSVRecord)record);
                    return true;
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.enabled = new boolean[this.records.size()];
        this.sortedRows = IntStream.range(0, this.records.size()).toArray();
        this.setFilter(this.filter);
    }

    public void setData(String data) {
        this.records.clear();
        if (data != null) {
            long ncommas = data.chars().filter(c -> c == 44).count();
            long nsemis = data.chars().filter(c -> c == 59).count();
            long ntabs = data.chars().filter(c -> c == 9).count();
            char delim = 2L * nsemis < ncommas && 2L * ntabs < ncommas ? (char)',' : (ntabs > nsemis ? (char)'\t' : ';');
            StringReader reader = new StringReader(data);
            try {
                DistrictImportUtils.consumeCSV((Reader)reader, (char)delim, (boolean)false, record -> {
                    this.records.add((CSVRecord)record);
                    return true;
                });
            }
            catch (IOException e) {
                LOGGER.error("Error reading CSV file", (Throwable)e);
                return;
            }
            CSVRecord header = this.records.remove(0);
            CSVRecord units = this.records.remove(0);
            this.variables = new ArrayList<String>();
            this.headers = new ArrayList<String>();
            Iterator it = header.iterator();
            Iterator uit = units.iterator();
            while (it.hasNext()) {
                String variable = ((String)it.next()).trim();
                String unit = uit.hasNext() ? ((String)uit.next()).trim() : null;
                this.variables.add(variable);
                this.headers.add(variable + (String)(unit != null && !unit.isEmpty() && (!unit.startsWith("(") || !unit.endsWith(")")) ? " [" + unit + "]" : ""));
            }
        }
        this.enabled = new boolean[this.records.size()];
        this.sortedRows = IntStream.range(0, this.records.size()).toArray();
        this.setFilter(this.filter);
    }

    public void sortBy(int columnIndex, SortDirectionEnum sortDirection) {
        if (columnIndex >= 0 && !sortDirection.equals((Object)SortDirectionEnum.NONE)) {
            Comparator<Integer> comparator;
            int offset = this.columnOffset();
            Comparator<Integer> comparator2 = comparator = this.isEnabledColumn(columnIndex) ? Comparator.comparing(k -> this.enabled[this.sortedRows[k]]) : Comparator.comparing(k -> this.records.get(this.sortedRows[k]).get(columnIndex - offset), VALUE_COMPARATOR);
            if (sortDirection.equals((Object)SortDirectionEnum.DESC)) {
                comparator = comparator.reversed();
            }
            this.sortedRows = IntStream.range(0, this.records.size()).mapToObj(i -> i).sorted(comparator).mapToInt(i -> this.sortedRows[i]).toArray();
        } else {
            this.sortedRows = IntStream.range(0, this.records.size()).toArray();
        }
        this.setFilter(this.filter);
    }
}

