/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.techtype.table;

import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.simantics.district.network.ui.techtype.table.TechTypeTableView;
import org.simantics.utils.ui.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportTechTypeCSVHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportTechTypeCSVHandler.class);
    @Inject
    EPartService partService;

    @Execute
    public void execute(@Named(value="activeShell") Shell s, @Named(value="e4ActivePart") MPart part) {
        if (!(part.getObject() instanceof TechTypeTableView)) {
            return;
        }
        TechTypeTableView view = (TechTypeTableView)part.getObject();
        FileDialog dialog = new FileDialog(s);
        dialog.setFilterExtensions(new String[]{"*.*", "*.*", "*.*", "*.*"});
        dialog.setFilterNames(new String[]{"Text files (UTF-8)", "Text files (UTF-16)", "Text files (ANSI)", "Text files (System default)"});
        String path = dialog.open();
        try {
            if (path != null) {
                Path p = Paths.get(path, new String[0]);
                if (Files.exists(p, new LinkOption[0])) {
                    Charset charset;
                    switch (dialog.getFilterIndex()) {
                        case 0: {
                            charset = Charset.forName("UTF-8");
                            break;
                        }
                        case 1: {
                            charset = Charset.forName("UTF-16");
                            break;
                        }
                        case 2: {
                            charset = Charset.forName("windows-1252");
                            break;
                        }
                        default: {
                            charset = Charset.defaultCharset();
                        }
                    }
                    view.setTechTypePath(path, charset);
                } else {
                    LOGGER.warn("Path does not exist even though path != null: {}", (Object)p);
                }
            } else {
                LOGGER.error("Invalid file path given {}", (Object)path);
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not read file {}", (Object)path, (Object)e);
            ExceptionUtils.logAndShowError((String)("Could not read file " + path + " : " + e.getMessage()), (Throwable)e);
        }
    }
}

