/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.styles;

import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.SetListener;
import org.simantics.district.network.ui.nodes.ElevationServerNode;
import org.simantics.maps.elevation.server.SingletonTiffTileInterface;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Group;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.Style;
import org.simantics.scenegraph.profile.common.ObserverGroupListener;
import org.simantics.scenegraph.utils.NodeUtil;

public class ElevationRectangleStyle
implements Style {
    private ObserverGroupListener listener = null;
    private double priority;

    public void activate(RequestProcessor backend, Resource runtimeDiagram, Resource entry, Group group, EvaluationContext observer) throws DatabaseException {
        if (this.listener != null && !this.listener.isDisposed()) {
            return;
        }
        this.listener = new ObserverGroupListener((Style)this, group, (Observer)observer);
        group.trackItems(backend, runtimeDiagram, (SetListener)this.listener);
    }

    public void deactivate(Resource runtimeDiagram, Resource entry, Group group, EvaluationContext observer) {
        if (this.listener != null && !this.listener.isDisposed()) {
            this.setRectangles(observer, Collections.emptyList());
            this.listener.dispose();
            observer.update();
        }
    }

    public void apply(Resource entry, Group group, EvaluationContext observer) {
        this.apply2(entry, observer);
    }

    public void apply2(Object item, EvaluationContext observer) {
        this.setRectangles(observer, SingletonTiffTileInterface.getBoundingBoxes());
    }

    private void setRectangles(EvaluationContext observer, Collection<Rectangle2D> rectangles) {
        IG2DNode node = (IG2DNode)NodeUtil.getNearestChildByClass((G2DParentNode)observer.getSceneGraph(), ElevationServerNode.class);
        if (node != null) {
            ((ElevationServerNode)node).setRectangles(rectangles);
        }
    }

    public void setPriority(double priority) {
        this.priority = priority;
    }

    public double getPriority() {
        return this.priority;
    }
}

