/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.participants;

import java.awt.geom.Point2D;
import java.util.Set;
import org.simantics.district.network.ui.participants.DNPickSorter;
import org.simantics.district.network.ui.participants.DNTranslateMode;
import org.simantics.district.network.ui.participants.Modes;
import org.simantics.district.network.ui.participants.RoutingMode;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.ICanvasParticipant;
import org.simantics.g2d.canvas.IToolMode;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil;
import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;

public class DNPointerInteractor
extends PointerInteractor {
    private RoutingMode routingMode;
    private IToolMode lastMode;

    public DNPointerInteractor() {
        super((PickRequest.PickSorter)new DNPickSorter());
    }

    protected ICanvasParticipant createConnectTool(TerminalUtil.TerminalInfo ti, int mouseId, Point2D startCanvasPos) {
        return super.createConnectTool(ti, mouseId, startCanvasPos);
    }

    protected ICanvasParticipant createTranslateTool(int mouseId, Point2D startCanvasPos, Point2D curCanvasPos, Set<IElement> elementsToDrag) {
        return new DNTranslateMode(startCanvasPos, curCanvasPos, mouseId, elementsToDrag);
    }

    static boolean connectToolModifiersPressed(int stateMask) {
        return (stateMask & 0x2200) != 0;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleStateMask(MouseEvent me) {
        this.lastStateMask = me.stateMask;
        if (this.temporarilyEnabledConnectTool) {
            if (!DNPointerInteractor.connectToolModifiersPressed(me.stateMask)) {
                this.temporarilyEnabledConnectTool = false;
                this.setHint(Hints.KEY_TOOL, this.lastMode != null ? this.lastMode : Hints.POINTERTOOL);
            }
        } else if (this.getToolMode() == Hints.POINTERTOOL && DNPointerInteractor.connectToolModifiersPressed(me.stateMask)) {
            this.temporarilyEnabledConnectTool = true;
            this.setHint(Hints.KEY_TOOL, Hints.CONNECTTOOL);
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=-1)
    public boolean altToggled(KeyEvent ke) {
        boolean altModifier;
        int mods = ke.stateMask;
        boolean press = ke instanceof KeyEvent.KeyPressedEvent;
        boolean modifierPressed = false;
        if (ke.keyCode == 18) {
            mods = DNPointerInteractor.mask(mods, 512, press);
            modifierPressed = true;
        }
        if (ke.keyCode == 65406) {
            mods = DNPointerInteractor.mask(mods, 8192, press);
            modifierPressed = true;
        }
        if (ke.keyCode == 16) {
            mods = DNPointerInteractor.mask(mods, 64, press);
            modifierPressed = true;
        }
        if (ke.keyCode == 17) {
            mods = DNPointerInteractor.mask(mods, 128, press);
            modifierPressed = true;
        }
        if (ke.keyCode == 157) {
            modifierPressed = true;
        }
        boolean otherModifiers = (mods & 0x40) != 0;
        boolean bl = altModifier = (mods & 0x2200) != 0;
        if (modifierPressed) {
            boolean altPressed = !otherModifiers && altModifier;
            this.lastStateMask = mods;
            if (altPressed) {
                IToolMode mode = this.getToolMode();
                if (mode == Hints.POINTERTOOL || mode == Modes.INSERT_TOOL) {
                    this.lastMode = mode;
                    this.temporarilyEnabledConnectTool = true;
                    this.setHint(Hints.KEY_TOOL, Hints.CONNECTTOOL);
                }
            } else if (this.temporarilyEnabledConnectTool) {
                this.temporarilyEnabledConnectTool = false;
                this.setHint(Hints.KEY_TOOL, this.lastMode);
            }
        }
        return false;
    }

    private static int mask(int mask, int mask2, boolean set) {
        return set ? mask | mask2 : mask & ~mask2;
    }

    @EventHandlerReflection.EventHandler(priority=1000)
    public boolean enterroutingMode(KeyEvent.KeyReleasedEvent ke) {
        if (this.getToolMode() != Hints.POINTERTOOL) {
            return false;
        }
        if (Character.toLowerCase(ke.character) == 't') {
            this.startRouteMode();
            return true;
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=1000)
    public boolean handleCommands(CommandEvent e) {
        if (e.command.equals((Object)Modes.START_ROUTE_MODE_COMMAND)) {
            this.startRouteMode();
            return true;
        }
        return false;
    }

    private void startRouteMode() {
        ICanvasContext canvasContext = this.getContext();
        if (this.routingMode == null || this.routingMode.isRemoved()) {
            this.routingMode = new RoutingMode(0);
            canvasContext.add((Object)this.routingMode);
        }
    }

    public double getPickDistance() {
        return 4.0;
    }
}

