/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.nodes;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;
import org.simantics.district.network.visualisations.model.ColorBarOptions;
import org.simantics.district.network.visualisations.model.DynamicColorContribution;
import org.simantics.district.network.visualisations.model.DynamicColorMap;
import org.simantics.district.network.visualisations.model.DynamicSizeContribution;
import org.simantics.district.network.visualisations.model.DynamicSizeMap;
import org.simantics.district.network.visualisations.model.SizeBarOptions;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.utils.DPIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicVisualisationContributionsNode
extends G2DNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicVisualisationContributionsNode.class);
    public static final String ID = "dynamicVisualisationContributionsNode";
    private static final long serialVersionUID = 7400966702826774761L;
    protected boolean enabled = true;
    private Map<String, DynamicColorContribution> dynamicColoringContributions;
    private Map<String, DynamicSizeContribution> dynamicSizingContributions;
    private ColorBarOptions colorBarsOptions = ColorBarOptions.useDefault();
    private SizeBarOptions sizeBarsOptions = SizeBarOptions.useDefault();
    private double colorBarBoxWidth = 300.0;
    private double colorBarBoxHeight = 50.0;
    private double colorBarBoxPadding = 20.0;

    public void render(Graphics2D g2d) {
        if (!this.enabled) {
            return;
        }
        AffineTransform ot = g2d.getTransform();
        Color oldColor = g2d.getColor();
        try {
            g2d.transform(this.transform);
            g2d.setTransform(new AffineTransform());
            Rectangle bounds = g2d.getClipBounds();
            if (bounds == null) {
                return;
            }
            this.renderColors(g2d);
            this.renderSizes(g2d);
        }
        finally {
            g2d.setColor(oldColor);
            g2d.setTransform(ot);
        }
    }

    private void renderColors(Graphics2D g2d) {
        if (this.colorBarsOptions == null || !this.colorBarsOptions.isShowColorBars()) {
            return;
        }
        ColorBarOptions.ColorBarsLocation location = this.colorBarsOptions.getLocation();
        ColorBarOptions.ColorBarsSize size = this.colorBarsOptions.getSize();
        double colorBarBoxLeft = this.getColorBarBoxLeft(g2d, location, size);
        double colorBarBoxTopInitial = this.getColorBarBoxTop(g2d, location, size);
        double colorBarBoxWidth = this.getColorBarBoxWidth(location, size);
        double colorBarBoxHeight = this.getColorBarBoxHeight(location, size);
        Rectangle bounds = g2d.getClipBounds();
        if (bounds == null) {
            return;
        }
        int i = 0;
        if (this.dynamicColoringContributions != null) {
            for (Map.Entry<String, DynamicColorContribution> object : this.dynamicColoringContributions.entrySet()) {
                double colorVerticalTop;
                double colorVerticalLeft;
                double colorVerticalWidth;
                double colorVerticalHeigth;
                DynamicColorContribution cc = object.getValue();
                if (!cc.isUsed()) continue;
                double min = cc.getDefaultMin();
                double max = cc.getDefaultMax();
                String unit = cc.getUnit();
                String label = cc.getLabel();
                DynamicColorMap map = cc.getDefaultColorMap();
                double colorBarBoxTop = colorBarBoxTopInitial + colorBarBoxHeight * (double)i;
                ++i;
                g2d.setComposite(AlphaComposite.getInstance(3, 0.8f));
                g2d.setColor(new Color(0.9f, 0.9f, 0.9f, 0.95f));
                Rectangle2D.Double vertical = new Rectangle2D.Double(colorBarBoxLeft, colorBarBoxTop, colorBarBoxWidth, colorBarBoxHeight);
                g2d.fill(vertical);
                List intensities = map.getIntensities();
                switch (location) {
                    default: {
                        colorVerticalHeigth = colorBarBoxHeight - 30.0;
                        colorVerticalWidth = (colorBarBoxWidth - 10.0) / (double)intensities.size();
                        colorVerticalLeft = colorBarBoxLeft + 5.0;
                        colorVerticalTop = colorBarBoxTop + 15.0;
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        colorVerticalHeigth = (colorBarBoxHeight - 10.0) / (double)intensities.size();
                        colorVerticalWidth = colorBarBoxWidth - 30.0;
                        colorVerticalLeft = colorBarBoxLeft + 15.0;
                        colorVerticalTop = colorBarBoxTop + 5.0;
                    }
                }
                Font rulerFont = new Font("Tahoma", 0, DPIUtil.upscale((int)9));
                g2d.setFont(rulerFont);
                double interval = (max - min) / (double)intensities.size();
                int j = 0;
                while (j < intensities.size()) {
                    DynamicColorMap.RGBIntensity intensity = (DynamicColorMap.RGBIntensity)intensities.get(j);
                    if (this.colorBarsOptions.isUseGradients()) {
                        double gradientSize;
                        DynamicColorMap.RGBIntensity upperLimitIntensity = j + 1 != intensities.size() ? (DynamicColorMap.RGBIntensity)intensities.get(j + 1) : intensity;
                        double minRed = intensity.getRed();
                        double minGreen = intensity.getGreen();
                        double minBlue = intensity.getBlue();
                        double maxRed = upperLimitIntensity.getRed();
                        double maxGreen = upperLimitIntensity.getGreen();
                        double maxBlue = upperLimitIntensity.getBlue();
                        switch (location) {
                            default: {
                                gradientSize = colorVerticalWidth;
                                break;
                            }
                            case EAST: 
                            case WEST: {
                                gradientSize = colorVerticalHeigth;
                            }
                        }
                        double redDelta = (maxRed - minRed) / gradientSize;
                        double greenDelta = (maxGreen - minGreen) / gradientSize;
                        double blueDelta = (maxBlue - minBlue) / gradientSize;
                        int k = 0;
                        while ((double)k < gradientSize) {
                            Rectangle2D.Double colorVertical;
                            g2d.setColor(new Color((float)(minRed + (double)k * redDelta), (float)(minGreen + (double)k * greenDelta), (float)(minBlue + (double)k * blueDelta), 1.0f));
                            switch (location) {
                                default: {
                                    colorVertical = new Rectangle2D.Double(colorVerticalLeft + (double)k, colorVerticalTop, 1.0, colorVerticalHeigth);
                                    break;
                                }
                                case EAST: 
                                case WEST: {
                                    colorVertical = new Rectangle2D.Double(colorVerticalLeft, colorVerticalTop + (double)k, colorVerticalWidth, 1.0);
                                }
                            }
                            g2d.fill(colorVertical);
                            ++k;
                        }
                    } else {
                        g2d.setColor(new Color((float)intensity.getRed(), (float)intensity.getGreen(), (float)intensity.getBlue(), 1.0f));
                        Rectangle2D.Double colorVertical = new Rectangle2D.Double(colorVerticalLeft, colorVerticalTop, colorVerticalWidth, colorVerticalHeigth);
                        g2d.fill(colorVertical);
                    }
                    double value = min + (double)j * interval;
                    String str = Double.toString(value);
                    if (str.length() > 4) {
                        str = str.substring(0, 3);
                    }
                    g2d.setColor(Color.BLACK);
                    switch (location) {
                        default: {
                            g2d.drawString(str, (float)(colorVerticalLeft - 8.0), (float)(colorBarBoxTop + colorBarBoxHeight));
                            colorVerticalLeft += colorVerticalWidth;
                            break;
                        }
                        case EAST: 
                        case WEST: {
                            g2d.drawString(str, (float)(colorVerticalLeft - 18.0), (float)colorVerticalTop);
                            colorVerticalTop += colorVerticalHeigth;
                        }
                    }
                    ++j;
                }
                g2d.setColor(Color.BLACK);
                Object str = Double.toString(max);
                g2d.drawString((String)str, (float)(colorVerticalLeft - 8.0), (float)(colorBarBoxTop + colorBarBoxHeight));
                str = object.getKey() + " - " + label + " [" + unit + "]";
                g2d.drawString((String)str, (float)colorBarBoxLeft + 5.0f, (float)colorBarBoxTop + 10.0f);
            }
        }
    }

    private double getColorBarBoxTop(Graphics2D g2d, ColorBarOptions.ColorBarsLocation location, ColorBarOptions.ColorBarsSize size) {
        Rectangle bounds = g2d.getClipBounds();
        if (bounds == null) {
            throw new IllegalStateException();
        }
        double colorBarBoxHeight = this.getColorBarBoxHeight(location, size);
        switch (location) {
            case NORTH: {
                return this.colorBarBoxPadding;
            }
            case SOUTH: {
                return bounds.getMaxY() - this.colorBarBoxPadding - colorBarBoxHeight;
            }
            case EAST: 
            case WEST: {
                return bounds.getMaxY() / 2.0 - colorBarBoxHeight / 2.0;
            }
        }
        return 0.0;
    }

    private double getColorBarBoxLeft(Graphics2D g2d, ColorBarOptions.ColorBarsLocation location, ColorBarOptions.ColorBarsSize size) {
        Rectangle bounds = g2d.getClipBounds();
        if (bounds == null) {
            throw new IllegalStateException();
        }
        double colorBarBoxWidth = this.getColorBarBoxWidth(location, size);
        switch (location) {
            case EAST: {
                double right = bounds.getMaxX() - this.colorBarBoxPadding;
                return right - colorBarBoxWidth;
            }
            case WEST: {
                return this.colorBarBoxPadding;
            }
            case NORTH: 
            case SOUTH: {
                double left = bounds.getMaxX() / 2.0 - colorBarBoxWidth / 2.0;
                return left;
            }
        }
        return 0.0;
    }

    private double getColorBarBoxWidth(ColorBarOptions.ColorBarsLocation location, ColorBarOptions.ColorBarsSize size) {
        switch (location) {
            default: {
                return (double)size.getSize() * this.colorBarBoxWidth;
            }
            case EAST: 
            case WEST: 
        }
        return (double)size.getSize() * this.colorBarBoxHeight;
    }

    private double getColorBarBoxHeight(ColorBarOptions.ColorBarsLocation location, ColorBarOptions.ColorBarsSize size) {
        switch (location) {
            default: {
                return (double)size.getSize() * this.colorBarBoxHeight;
            }
            case EAST: 
            case WEST: 
        }
        return (double)size.getSize() * this.colorBarBoxWidth;
    }

    private void renderSizes(Graphics2D g2d) {
        if (this.sizeBarsOptions == null || !this.sizeBarsOptions.isShowSizeBars()) {
            return;
        }
        SizeBarOptions.SizeBarsLocation location = this.sizeBarsOptions.getLocation();
        SizeBarOptions.SizeBarsSize sizeb = this.sizeBarsOptions.getSize();
        double sizeBarBoxLeft = this.getSizeBarBoxLeft(g2d, location, sizeb);
        double sizeBarBoxTopInitial = this.getSizeBarBoxTop(g2d, location, sizeb);
        double sizeBarBoxWidth = this.getSizeBarBoxWidth(location, sizeb);
        double sizeBarBoxHeight = this.getSizeBarBoxHeight(location, sizeb);
        Rectangle bounds = g2d.getClipBounds();
        if (bounds == null) {
            return;
        }
        int i = 0;
        if (this.dynamicSizingContributions != null) {
            for (Map.Entry<String, DynamicSizeContribution> object : this.dynamicSizingContributions.entrySet()) {
                double sizeVerticalTop;
                double sizeVerticalLeft;
                double sizeVerticalWidth;
                double sizeVerticalHeigth;
                DynamicSizeContribution cc = object.getValue();
                if (!cc.isUsed()) continue;
                double min = cc.getDefaultMin();
                double max = cc.getDefaultMax();
                String unit = cc.getUnit();
                String label = cc.getLabel();
                DynamicSizeMap map = cc.getDefaultSizeMap();
                List sizes = map.getSizes();
                double sizeBarBoxTop = sizeBarBoxTopInitial + sizeBarBoxHeight * (double)i;
                ++i;
                g2d.setComposite(AlphaComposite.getInstance(3, 0.8f));
                g2d.setColor(new Color(0.9f, 0.9f, 0.9f, 0.95f));
                Rectangle2D.Double vertical = new Rectangle2D.Double(sizeBarBoxLeft, sizeBarBoxTop, sizeBarBoxWidth, sizeBarBoxHeight);
                g2d.fill(vertical);
                switch (location) {
                    default: {
                        sizeVerticalHeigth = sizeBarBoxHeight - 30.0;
                        sizeVerticalWidth = (sizeBarBoxWidth - 10.0) / (double)sizes.size();
                        sizeVerticalLeft = sizeBarBoxLeft + 5.0;
                        sizeVerticalTop = sizeBarBoxTop + 15.0;
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        sizeVerticalHeigth = (sizeBarBoxHeight - 10.0) / (double)sizes.size();
                        sizeVerticalWidth = sizeBarBoxWidth - 30.0;
                        sizeVerticalLeft = sizeBarBoxLeft + 15.0;
                        sizeVerticalTop = sizeBarBoxTop + 5.0;
                    }
                }
                Font rulerFont = new Font("Tahoma", 0, DPIUtil.upscale((int)9));
                g2d.setFont(rulerFont);
                double interval = (max - min) / (double)sizes.size();
                int j = 0;
                while (j < sizes.size()) {
                    Double size = (Double)sizes.get(j);
                    g2d.setColor(new Color(0.0f, 0.0f, 0.8f, 0.8f));
                    switch (location) {
                        default: {
                            double sizedWidth = size / 5.0 * sizeVerticalHeigth;
                            Rectangle2D.Double rect = new Rectangle2D.Double(sizeVerticalLeft, sizeVerticalTop, sizedWidth, sizeVerticalHeigth);
                            g2d.fill(rect);
                        }
                        case EAST: 
                        case WEST: 
                    }
                    double value = min + (double)j * interval;
                    String str = Double.toString(value);
                    if (str.length() > 4) {
                        str = str.substring(0, 3);
                    }
                    g2d.setColor(Color.BLACK);
                    switch (location) {
                        default: {
                            g2d.drawString(str, (float)(sizeVerticalLeft - 8.0), (float)(sizeBarBoxTop + sizeBarBoxHeight));
                            sizeVerticalLeft += sizeVerticalWidth;
                            break;
                        }
                        case EAST: 
                        case WEST: {
                            g2d.drawString(str, (float)(sizeVerticalLeft - 8.0), (float)sizeVerticalTop);
                            sizeVerticalTop += sizeVerticalHeigth;
                        }
                    }
                    ++j;
                }
                g2d.setColor(Color.BLACK);
                Object str = Double.toString(max);
                switch (location) {
                    default: {
                        g2d.drawString((String)str, (float)(sizeVerticalLeft - 30.0), (float)(sizeBarBoxTop + sizeBarBoxHeight));
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        g2d.drawString((String)str, (float)(sizeVerticalLeft - 30.0), (float)sizeVerticalTop);
                    }
                }
                str = object.getKey() + " - " + label + " [" + unit + "]";
                g2d.drawString((String)str, (float)sizeBarBoxLeft + 5.0f, (float)sizeBarBoxTop + 10.0f);
            }
        }
    }

    private double getSizeBarBoxTop(Graphics2D g2d, SizeBarOptions.SizeBarsLocation location, SizeBarOptions.SizeBarsSize size) {
        Rectangle bounds = g2d.getClipBounds();
        if (bounds == null) {
            throw new IllegalStateException();
        }
        double sizeBarBoxHeight = this.getSizeBarBoxHeight(location, size);
        switch (location) {
            case NORTH: {
                return this.colorBarBoxPadding;
            }
            case SOUTH: {
                return bounds.getMaxY() - this.colorBarBoxPadding - sizeBarBoxHeight;
            }
            case EAST: 
            case WEST: {
                return bounds.getMaxY() / 2.0 - sizeBarBoxHeight / 2.0;
            }
        }
        return 0.0;
    }

    private double getSizeBarBoxLeft(Graphics2D g2d, SizeBarOptions.SizeBarsLocation location, SizeBarOptions.SizeBarsSize size) {
        Rectangle bounds = g2d.getClipBounds();
        if (bounds == null) {
            throw new IllegalStateException();
        }
        double sizeBarBoxWidth = this.getSizeBarBoxWidth(location, size);
        switch (location) {
            case EAST: {
                double right = bounds.getMaxX() - this.colorBarBoxPadding;
                return right - sizeBarBoxWidth;
            }
            case WEST: {
                return this.colorBarBoxPadding;
            }
            case NORTH: 
            case SOUTH: {
                double left = bounds.getMaxX() / 2.0 - sizeBarBoxWidth / 2.0;
                return left;
            }
        }
        return 0.0;
    }

    private double getSizeBarBoxWidth(SizeBarOptions.SizeBarsLocation location, SizeBarOptions.SizeBarsSize size) {
        switch (location) {
            default: {
                return size.getSize() * this.colorBarBoxWidth;
            }
            case EAST: 
            case WEST: 
        }
        return size.getSize() * this.colorBarBoxHeight;
    }

    private double getSizeBarBoxHeight(SizeBarOptions.SizeBarsLocation location, SizeBarOptions.SizeBarsSize size) {
        switch (location) {
            default: {
                return size.getSize() * this.colorBarBoxHeight;
            }
            case EAST: 
            case WEST: 
        }
        return size.getSize() * this.colorBarBoxWidth;
    }

    public Rectangle2D getBoundsInLocal() {
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setDynamicColoringObjects(Map<String, DynamicColorContribution> dynamicColoringObjects) {
        this.dynamicColoringContributions = dynamicColoringObjects;
    }

    public void setColorBarOptions(ColorBarOptions colorBarsOptions) {
        this.colorBarsOptions = colorBarsOptions;
    }

    public void setDynamicSizingObjects(Map<String, DynamicSizeContribution> dynamicSizingObjects) {
        this.dynamicSizingContributions = dynamicSizingObjects;
    }

    public void setSizeBarOptions(SizeBarOptions sizeBarOptions) {
        this.sizeBarsOptions = sizeBarOptions;
    }
}

