/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.district.network.ui.nodes.DeferredNode;
import org.simantics.district.network.ui.nodes.DeferredRenderingNode;
import org.simantics.district.network.ui.nodes.DistrictNetworkEdgeNode;
import org.simantics.district.network.ui.nodes.DistrictRenderingHints;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.nodes.spatial.RTreeNode;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.utils.datastructures.Pair;

public class DistrictNetworkEdgeArrayNode
extends G2DNode
implements DeferredNode {
    private static final long serialVersionUID = -8377444630205663419L;
    public static final String NODE_KEY = "DISTRICT_NETWORK_EDGE_ARRAY";
    private static final String RENDERER_ID = "edgeArrayDeferredRenderer";
    private DistrictNetworkEdgeNode edgeNode = null;
    private double arrowLength;
    private Path2D arrowPath;

    public void render(Graphics2D g2d) {
        DeferredRenderingNode deferred;
        ParentNode root = (ParentNode)NodeUtil.getNearestParentOfType((INode)this, RTreeNode.class);
        DeferredRenderingNode deferredRenderingNode = deferred = root != null ? (DeferredRenderingNode)root.getNode(RENDERER_ID) : null;
        if (deferred != null) {
            deferred.deferNode(g2d.getTransform(), this);
        } else {
            this.renderDeferred(g2d);
        }
    }

    @Override
    public void renderDeferred(Graphics2D g2d) {
        if (this.arrowLength != Double.MIN_VALUE) {
            double scale = (Double)g2d.getRenderingHint(DistrictRenderingHints.KEY_VIEW_SCALE_UNDER_SPATIAL_ROOT);
            g2d.setColor(Color.BLACK);
            float lw = DistrictNetworkEdgeNode.STROKE.getLineWidth() / (float)scale;
            g2d.setStroke(new BasicStroke(lw, 0, 2));
            double l = this.arrowLength;
            double w = 2.0 * (double)lw * Math.signum(l);
            if (Math.abs(w) > Math.abs(l)) {
                w = l;
            }
            double offset = 2.0 * (double)lw;
            int zoomLevel = (Integer)g2d.getRenderingHint(DistrictRenderingHints.KEY_VIEW_ZOOM_LEVEL);
            Point2D centerPoint = this.edgeNode.getCenterPoint(zoomLevel);
            Point2D direction = this.edgeNode.getDirection(zoomLevel);
            double centerX = centerPoint.getX();
            double centerY = centerPoint.getY();
            double deltaX = direction.getX();
            double deltaY = direction.getY();
            double odx = offset * deltaY;
            double ody = offset * deltaX;
            if (odx < 0.0) {
                odx = -odx;
                ody = -ody;
            }
            double x0 = centerX - l / 2.0 * deltaX + ody;
            double y0 = centerY - l / 2.0 * deltaY - odx;
            double x1 = centerX + (l / 2.0 - w) * deltaX + ody;
            double y1 = centerY + (l / 2.0 - w) * deltaY - odx;
            g2d.draw(new Line2D.Double(x0, y0, x1, y1));
            this.arrowPath = new Path2D.Double();
            this.arrowPath.moveTo(x1 + w * deltaX, y1 + w * deltaY);
            this.arrowPath.lineTo(x1 + w * deltaY, y1 - w * deltaX);
            this.arrowPath.lineTo(x1 - w * deltaY, y1 + w * deltaX);
            this.arrowPath.closePath();
            g2d.fill(this.arrowPath);
        }
    }

    public Rectangle2D getBoundsInLocal() {
        return null;
    }

    public void setEdgeNode(DistrictNetworkEdgeNode edgeNode) {
        this.edgeNode = edgeNode;
    }

    public void setArrowLength(double length) {
        this.arrowLength = length;
    }

    public static Pair<String, Class<DeferredRenderingNode>> renderer() {
        return Pair.make((Object)RENDERER_ID, DeferredRenderingNode.class);
    }
}

