/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.simantics.district.network.ui.nodes.DistrictNetworkNodeUtils;
import org.simantics.g2d.utils.GeometryUtils;
import org.simantics.scenegraph.g2d.G2DNode;

public class ConnectionLineNode
extends G2DNode {
    public static final String NODE_NAME = "districtNetworkConnection";
    private static final BasicStroke STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{4.0f, 2.0f}, 0.0f);
    private static final Color[] colors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.ORANGE, Color.CYAN, Color.PINK};
    private float strokeWidth;
    private Line2D[] lines;
    private static final long serialVersionUID = 1L;

    public Rectangle2D getBoundsInLocal() {
        return null;
    }

    public Rectangle2D getBoundsInLocal(boolean b) {
        return null;
    }

    public Rectangle2D getBounds() {
        return null;
    }

    public void setStrokeWidth(float w) {
        this.strokeWidth = w;
    }

    public void setPoints(List<Point2D> result) {
        Point2D p0 = DistrictNetworkNodeUtils.calculatePoint2D(result.get(0), null);
        this.lines = new Line2D[result.size() - 1];
        int i = 1;
        while (i < result.size()) {
            Point2D p = result.get(i);
            this.lines[i - 1] = p != null ? new Line2D.Double(p0, DistrictNetworkNodeUtils.calculatePoint2D(p, null)) : null;
            ++i;
        }
    }

    public void render(Graphics2D g2d) {
        if (this.lines == null || this.lines.length == 0) {
            return;
        }
        float scaleRecip = (float)GeometryUtils.getScale((AffineTransform)g2d.getTransform());
        g2d.setStroke(GeometryUtils.scaleStroke((Stroke)STROKE, (float)(this.strokeWidth / scaleRecip)));
        int i = 0;
        while (i < this.lines.length) {
            if (this.lines[i] != null) {
                g2d.setColor(colors[i % colors.length]);
                g2d.draw(this.lines[i]);
            }
            ++i;
        }
    }
}

