/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.ui.DistrictDiagramViewerListener;
import org.simantics.district.network.ui.DistrictNetworkUIUtil;
import org.simantics.district.network.ui.breakdown.SubgraphProvider;
import org.simantics.district.route.RouteService;
import org.simantics.modeling.ModelingResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends AbstractUIPlugin {
    private static final String PROPERTY_TABLE_HIGHLIGHT = "PROPERTY_TABLE_HIGHLIGHT";
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    public static final String PLUGIN_ID = "org.simantics.district.network.ui";
    private static Activator instance;
    private static BundleContext context;
    private ServiceTracker<SubgraphProvider, SubgraphProvider> subgraphProviderTracker;
    private ServiceTracker<RouteService, RouteService> routeServiceTracker;
    private ServiceTracker<DistrictDiagramViewerListener, DistrictDiagramViewerListener> districtDiagramViewerListenerTracker;
    private HighlightSelectionEventHandler eventHandler;

    public void start(BundleContext context) throws Exception {
        instance = this;
        Activator.context = context;
        this.subgraphProviderTracker = new ServiceTracker(context, SubgraphProvider.class.getName(), null);
        this.subgraphProviderTracker.open();
        this.routeServiceTracker = new ServiceTracker(context, RouteService.class.getName(), null);
        this.routeServiceTracker.open();
        this.districtDiagramViewerListenerTracker = new ServiceTracker(context, DistrictDiagramViewerListener.class.getName(), null);
        this.districtDiagramViewerListenerTracker.open();
        this.initializeEventListener();
    }

    public void stop(BundleContext context) throws Exception {
        this.subgraphProviderTracker.close();
        this.routeServiceTracker.close();
        this.deinitializeEventListener();
        instance = null;
        Activator.context = null;
    }

    public static Activator getInstance() {
        return instance;
    }

    public static BundleContext getContext() {
        return context;
    }

    public SubgraphProvider[] getSubgraphProviders() {
        return (SubgraphProvider[])this.subgraphProviderTracker.getServices((Object[])new SubgraphProvider[0]);
    }

    public RouteService getRouteService() {
        return (RouteService)this.routeServiceTracker.getService();
    }

    public DistrictDiagramViewerListener[] getDistrictDiagramViewerListeners() {
        return (DistrictDiagramViewerListener[])this.districtDiagramViewerListenerTracker.getServices((Object[])new DistrictDiagramViewerListener[0]);
    }

    private void initializeEventListener() {
        IEclipseContext contxt = E4Workbench.getServiceContext();
        IEventBroker broker = (IEventBroker)contxt.get(IEventBroker.class);
        this.eventHandler = new HighlightSelectionEventHandler();
        if (broker != null) {
            broker.subscribe(PROPERTY_TABLE_HIGHLIGHT, (EventHandler)this.eventHandler);
        } else {
            LOGGER.info("EventBroker is somehow null for {}", (Object)this);
        }
    }

    private void deinitializeEventListener() {
        IEclipseContext contxt = E4Workbench.getServiceContext();
        IEventBroker broker = (IEventBroker)contxt.get(IEventBroker.class);
        if (broker != null) {
            broker.unsubscribe((EventHandler)this.eventHandler);
        } else {
            LOGGER.info("EventBroker is somehow null for {}", (Object)this);
        }
    }

    static /* synthetic */ Logger access$0() {
        return LOGGER;
    }

    private static final class HighlightSelectionEventHandler
    implements EventHandler {
        private HighlightSelectionEventHandler() {
        }

        public void handleEvent(Event event) {
            Object data = event.getProperty("org.eclipse.e4.data");
            if (data instanceof Variable[]) {
                final Variable[] propertyTableComponents = (Variable[])data;
                try {
                    List dnElements = (List)Simantics.getSession().syncRequest((Read)new UniqueRead<List<Resource>>(){

                        public List<Resource> perform(ReadGraph graph) throws DatabaseException {
                            DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                            return Arrays.asList(propertyTableComponents).stream().map(var -> {
                                try {
                                    Resource res = var.getPossibleRepresents(graph);
                                    Resource element = res != null ? graph.getPossibleObject(res, modelingResources.ComponentToElement) : null;
                                    return element != null ? graph.getPossibleObject(element, districtNetworkResource.MappedFromElement) : null;
                                }
                                catch (Exception e) {
                                    String varURI = var.toString();
                                    try {
                                        varURI = var.getURI(graph);
                                    }
                                    catch (DatabaseException ex) {
                                        LOGGER.error("Unable to resole uri for {}", var, (Object)ex);
                                    }
                                    LOGGER.error("Could not get dn element for {}", (Object)varURI, (Object)e);
                                    return null;
                                }
                            }).filter(Objects::nonNull).collect(Collectors.toList());
                        }
                    });
                    DistrictNetworkUIUtil.openDNDiagramWithSelection(Display.getDefault(), dnElements);
                }
                catch (DatabaseException e) {
                    LOGGER.error("Could not convert variables to dn elements", (Object)propertyTableComponents, (Object)e);
                }
            }
        }
    }
}

