/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.contributions;

import java.util.List;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.ui.IEditorPart;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.ui.DistrictDiagramEditor;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.e4.E4WorkbenchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToggleSplitToMultipleDiagrams {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToggleSplitToMultipleDiagrams.class);
    private static final String COMMAND_ID = "org.simantics.district.network.ui.command.splittomultiplediagrams";

    @AboutToShow
    public void aboutToShow(@Named(value="e4ActivePart") MPart mActiveEditorPart, MApplication app, List<MMenuElement> items) {
        Resource diagram = ToggleSplitToMultipleDiagrams.getDiagramFromEditorInput(mActiveEditorPart);
        if (diagram != null) {
            MHandledMenuItem menuItem = MMenuFactory.INSTANCE.createHandledMenuItem();
            menuItem.setType(ItemType.CHECK);
            menuItem.setLabel("Split to Multiple Diagrams");
            menuItem.setContributorURI("org.simantics.district.network.ui");
            menuItem.setCommand(app.getCommand(COMMAND_ID));
            menuItem.setSelected(ToggleSplitToMultipleDiagrams.isSplitToMultipleEnabled(diagram));
            items.add((MMenuElement)menuItem);
        }
    }

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MPart mActiveEditorPart) {
        IEditorPart activeEditorPart = E4WorkbenchUtils.getActiveIEditorPart((MPart)mActiveEditorPart);
        if (activeEditorPart == null) {
            return false;
        }
        return activeEditorPart instanceof DistrictDiagramEditor;
    }

    @Execute
    public void toggleSplitToMultiple(@Named(value="e4ActivePart") MPart mActiveEditorPart) {
        Resource diagram = ToggleSplitToMultipleDiagrams.getDiagramFromEditorInput(mActiveEditorPart);
        if (diagram != null) {
            Simantics.getSession().asyncRequest(graph -> graph.claimLiteral(diagram, DistrictNetworkResource.getInstance((ReadGraph)graph).Diagram_splitToMultipleEnabled, (Object)(ToggleSplitToMultipleDiagrams.splitToMultipleEnabled((ReadGraph)graph, diagram) == false ? 1 : 0), (Binding)Bindings.BOOLEAN));
        }
    }

    private static boolean isSplitToMultipleEnabled(Resource diagram) {
        try {
            return (Boolean)Simantics.getSession().syncRequest((Read)new SplitToMultipleEnabledRequest(diagram));
        }
        catch (DatabaseException e) {
            LOGGER.error("Could not check if split to multiple is enabled for diagram {}", (Object)diagram, (Object)e);
            return false;
        }
    }

    private static Boolean splitToMultipleEnabled(ReadGraph graph, Resource diagram) throws DatabaseException {
        return Boolean.TRUE.equals(graph.getPossibleRelatedValue(diagram, DistrictNetworkResource.getInstance((ReadGraph)graph).Diagram_splitToMultipleEnabled));
    }

    private static Resource getDiagramFromEditorInput(MPart mActiveEditorPart) {
        IEditorPart activeEditorPart = E4WorkbenchUtils.getActiveIEditorPart((MPart)mActiveEditorPart);
        if (activeEditorPart == null) {
            return null;
        }
        if (!(activeEditorPart instanceof DistrictDiagramEditor)) {
            return null;
        }
        IResourceEditorInput input = (IResourceEditorInput)activeEditorPart.getEditorInput();
        return input.getResource();
    }

    private static class SplitToMultipleEnabledRequest
    extends UnaryRead<Resource, Boolean> {
        public SplitToMultipleEnabledRequest(Resource diagram) {
            super((Object)diagram);
        }

        public Boolean perform(ReadGraph graph) throws DatabaseException {
            return ToggleSplitToMultipleDiagrams.splitToMultipleEnabled(graph, (Resource)this.parameter);
        }
    }
}

