/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.contributions;

import java.util.List;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResetLengthHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResetLengthHandler.class);

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ISelection selection) {
        return ResetLengthHandler.canResetLength(selection);
    }

    public static boolean canResetLength(ISelection selection) {
        List elements = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (elements.size() != 1) {
            return false;
        }
        try {
            return (Boolean)Simantics.getSession().syncRequest(graph -> {
                DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                for (Resource e : elements) {
                    if (graph.isInstanceOf(e, DN.Edge)) continue;
                    return false;
                }
                return true;
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Could not evaluate if reset length can be executed for selection {}", (Object)elements, (Object)e);
            return false;
        }
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") ISelection selection) throws DatabaseException {
        List elements = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (elements.size() != 1) {
            return;
        }
        Simantics.getSession().syncRequest(graph -> {
            graph.markUndoPoint();
            DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
            Resource edge = (Resource)elements.get(0);
            double distance = DistrictNetworkUtil.calculateDetailedDistance((ReadGraph)graph, (Resource)edge);
            graph.claimLiteral(edge, DN.Edge_HasLength, (Object)distance, (Binding)Bindings.DOUBLE);
        });
    }
}

