/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.contributions;

import java.util.List;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResetElevationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResetElevationHandler.class);

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ISelection selection) {
        return ResetElevationHandler.canResetElevation(selection);
    }

    public static boolean canResetElevation(ISelection selection) {
        final List elements = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (elements.size() != 1) {
            return false;
        }
        try {
            return (Boolean)Simantics.getSession().syncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph graph) throws DatabaseException {
                    DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                    for (Resource selection : elements) {
                        if (graph.isInstanceOf(selection, DN.Vertex)) continue;
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Could not evaluate if mapping can be changed for selection {}", (Object)elements, (Object)e);
            return false;
        }
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") ISelection selection) throws DatabaseException {
        final List elements = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (elements.size() != 1) {
            return;
        }
        Simantics.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                Resource vertex = (Resource)elements.iterator().next();
                double[] coords = (double[])graph.getPossibleRelatedValue(vertex, DIA.HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
                if (coords != null) {
                    double elevation = DistrictNetworkUtil.elevationFromServer((double[])coords);
                    graph.deny(vertex, DN.Vertex_HasElevation);
                    graph.claimLiteral(vertex, DN.Vertex_HasElevation, (Object)elevation, (Binding)Bindings.DOUBLE);
                }
            }
        });
    }
}

