/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.contributions;

import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.AboutToHide;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.swt.widgets.Display;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.scl.SCLScripts;
import org.simantics.scl.compiler.top.ValueNotFound;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkElementActionMenuContribution {
    private static Logger LOGGER = LoggerFactory.getLogger(NetworkElementActionMenuContribution.class);

    @AboutToShow
    public void aboutToShow(@Named(value="org.eclipse.ui.selection") Object selection, final Display display, List<MMenuElement> items) {
        List actions;
        List vertices = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (vertices.size() != 1) {
            return;
        }
        final Resource vertex = (Resource)vertices.get(0);
        try {
            actions = (List)Simantics.getSession().syncRequest((Read)new ActionItemRequest(vertex), (Listener)TransientCacheListener.instance());
        }
        catch (DatabaseException e) {
            LOGGER.error("Error fetching action items for " + String.valueOf(vertex), (Throwable)e);
            return;
        }
        if (actions == null || actions.isEmpty()) {
            return;
        }
        items.add((MMenuElement)MMenuFactory.INSTANCE.createMenuSeparator());
        MMenu subMenu = MMenuFactory.INSTANCE.createMenu();
        List children = subMenu.getChildren();
        subMenu.setLabel("Component Actions");
        items.add((MMenuElement)subMenu);
        for (Tuple2 action : actions) {
            final String label = (String)action.c0;
            final Function function = (Function)action.c1;
            Object handler = new Object(){

                @CanExecute
                public boolean canExecute() {
                    try {
                        return (Boolean)Simantics.getSession().syncRequest((Read)new ResourceRead<Boolean>(vertex){

                            public Boolean perform(ReadGraph graph) throws DatabaseException {
                                DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                                if (graph.isInstanceOf(vertex, DN.Element) && graph.hasStatement(vertex, DN.MappedComponent)) {
                                    return true;
                                }
                                return false;
                            }
                        }, (Listener)TransientCacheListener.instance());
                    }
                    catch (DatabaseException databaseException) {
                        return false;
                    }
                }

                @Execute
                public void execute() {
                    final SCLReportingHandler handler = new SCLReportingHandler(){
                        private SCLReportingHandler handler;

                        private SCLReportingHandler getHandler() {
                            if (this.handler == null) {
                                this.handler = (SCLReportingHandler)SCLScripts.getOrCreateConsoleCommandSession().second;
                            }
                            return this.handler;
                        }

                        public void printError(String error) {
                            display.asyncExec(() -> this.getHandler().printError(error));
                        }

                        public void printCommand(String command) {
                            display.asyncExec(() -> this.getHandler().printCommand(command));
                        }

                        public void print(String text) {
                            display.asyncExec(() -> this.getHandler().print(text));
                        }

                        public void didWork(double amount) {
                            display.asyncExec(() -> this.getHandler().didWork(amount));
                        }
                    };
                    Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                            Resource component = graph.getPossibleObject(vertex, DN.MappedComponent);
                            if (component == null) {
                                return;
                            }
                            Variable v = Variables.getVariable((ReadGraph)graph, (Resource)graph.getSingleObject(component, ModelingResources.getInstance((ReadGraph)graph).ElementToComponent));
                            graph.markUndoPoint();
                            Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)(label + " for " + v.getName((ReadGraph)graph)));
                            SCLContext context = SCLContext.getCurrent();
                            Object oldHandler = context.put((Object)"reportingHandler", (Object)handler);
                            try {
                                Simantics.applySCLWrite((WriteGraph)graph, (Function1)function, (Object)v);
                            }
                            finally {
                                context.put((Object)"reportingHandler", oldHandler);
                            }
                        }
                    }, e -> {
                        if (e != null) {
                            LOGGER.error("Running command " + label + " for " + String.valueOf(vertex) + " failed", (Throwable)e);
                        }
                    });
                }
            };
            MDirectMenuItem dynamicItem = MMenuFactory.INSTANCE.createDirectMenuItem();
            dynamicItem.setLabel(label);
            dynamicItem.setObject(handler);
            children.add(dynamicItem);
        }
    }

    @AboutToHide
    public void aboutToHide() {
    }

    private static final class ActionItemRequest
    extends ResourceRead<List<Tuple2>> {
        private ActionItemRequest(Resource resource) {
            super(resource);
        }

        public List<Tuple2> perform(ReadGraph graph) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
            if (!graph.isInstanceOf(this.resource, DN.Element)) {
                return Collections.emptyList();
            }
            Resource component = graph.getPossibleObject(this.resource, DN.MappedComponent);
            if (component == null) {
                return Collections.emptyList();
            }
            Resource mapping = graph.getPossibleObject(this.resource, DN.HasMapping);
            if (mapping == null) {
                return Collections.emptyList();
            }
            String name = (String)graph.getPossibleRelatedValue(mapping, DN.Mapping_ComponentType);
            if (name == null) {
                return Collections.emptyList();
            }
            Resource root = graph.getSingleObject(graph.getSingleObject(mapping, L0.PartOf), L0.PartOf);
            Resource uc = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)root, (String)name);
            if (uc == null) {
                return Collections.emptyList();
            }
            Resource actionsModule = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)uc, (String)"Actions");
            if (actionsModule == null) {
                return Collections.emptyList();
            }
            String uri = graph.getURI(actionsModule);
            SCLContext sclContext = SCLContext.getCurrent();
            Object oldGraph = sclContext.put((Object)"graph", (Object)graph);
            try {
                Function actionsFun = (Function)SCLOsgi.MODULE_REPOSITORY.getValue(uri, "actions");
                Variable variable = Variables.getPossibleVariable((ReadGraph)graph, (Resource)graph.getSingleObject(component, ModelingResources.getInstance((ReadGraph)graph).ElementToComponent));
                List list = (List)actionsFun.apply((Object)variable);
                return list;
            }
            catch (ValueNotFound e) {
                throw new NoSingleResultException("No value for " + uri + "/actions", (Throwable)e);
            }
            finally {
                sclContext.put((Object)"graph", oldGraph);
            }
        }
    }
}

