/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.contributions;

import java.util.List;
import javax.inject.Named;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;

public class DrawMapToggleHandler {
    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ISelection selection) throws DatabaseException {
        return DrawMapToggleHandler.canDrawMap(selection);
    }

    public static boolean canDrawMap(ISelection selection) throws DatabaseException {
        List diagrams = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (diagrams.size() != 1) {
            return false;
        }
        final Resource diagram = (Resource)diagrams.get(0);
        return (Boolean)Simantics.getSession().syncRequest((Read)new UniqueRead<Boolean>(){

            public Boolean perform(ReadGraph graph) throws DatabaseException {
                return graph.isInstanceOf(diagram, DistrictNetworkResource.getInstance((ReadGraph)graph).Diagram);
            }
        });
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") Object selection) {
        final List diagrams = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        DatabaseJob job = new DatabaseJob("Toggle draw map"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Simantics.getSession().syncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            DistrictNetworkUtil.toggleDrawMap((WriteGraph)graph, (Resource)((Resource)diagrams.get(0)));
                        }
                    });
                }
                catch (DatabaseException e) {
                    return new Status(4, "org.simantics.district.network.ui", this.getName() + " failed.", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

