/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.contributions;

import java.util.List;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;

public class DeleteHandler {
    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ISelection selection) throws DatabaseException {
        return DeleteHandler.canDelete(selection);
    }

    public static boolean canDelete(ISelection selection) throws DatabaseException {
        final List elements = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (elements.size() == 0) {
            return false;
        }
        return (Boolean)Simantics.getSession().syncRequest((Read)new UniqueRead<Boolean>(){

            public Boolean perform(ReadGraph graph) throws DatabaseException {
                DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                for (Resource selection : elements) {
                    if (graph.isInstanceOf(selection, DN.Element)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") ISelection selection) throws DatabaseException {
        final List elements = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        Simantics.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                for (Resource resource : elements) {
                    RemoverUtil.remove((WriteGraph)graph, (Resource)resource);
                }
            }
        });
    }
}

