/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.breakdown;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.simantics.DatabaseJob;
import org.simantics.NameLabelMode;
import org.simantics.NameLabelUtil;
import org.simantics.ObjectIdentitySchedulingRule;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.DisposableListener;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.request.ActiveModels;
import org.simantics.db.request.Read;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.ui.DistrictNetworkUIUtil;
import org.simantics.district.network.ui.breakdown.Input;
import org.simantics.district.network.ui.breakdown.SubgraphProvider;
import org.simantics.district.network.ui.internal.Activator;
import org.simantics.modeling.ModelingResources;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.strings.StringUtils;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.SWTUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistrictNetworkBreakdownPanel
extends Composite {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistrictNetworkBreakdownPanel.class);
    private DisposableListener<Input.NetworkDiagrams> inputListener;
    private ConcurrentMap<Input.NetworkDiagram, Input.Subgraph[]> subgraphs = new ConcurrentHashMap<Input.NetworkDiagram, Input.Subgraph[]>();
    private ResourceManager rm = new LocalResourceManager(JFaceResources.getResources(), (Control)this);
    private TreeViewer tree;
    private TreeComparator treeComparator;
    private ImageDescriptor mapImg = BundleUtils.getImageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/map.png");
    private static final String PENDING = "Pending...";
    private static final Input.Subgraph[] PENDING_RESULT = new Input.Subgraph[0];

    public DistrictNetworkBreakdownPanel(Composite parent, int style) {
        super(parent, style);
        this.addDisposeListener(e -> this.widgetDisposed());
        this.createUI(parent);
        this.trackInput();
    }

    protected void widgetDisposed() {
        if (this.inputListener != null) {
            this.inputListener.dispose();
        }
    }

    private void createUI(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        Composite treeParent = new Composite((Composite)this, 0);
        TreeColumnLayout treeLayout = new TreeColumnLayout();
        treeParent.setLayout((Layout)treeLayout);
        GridDataFactory.fillDefaults().grab(true, true).span(1, 1).applyTo((Control)treeParent);
        this.treeComparator = new TreeComparator();
        this.tree = new TreeViewer(treeParent, 68354);
        this.tree.setUseHashlookup(true);
        this.tree.getTree().setHeaderVisible(true);
        this.tree.setContentProvider((IContentProvider)new ContentProvider());
        this.tree.setComparator((ViewerComparator)this.treeComparator);
        this.createColumns(treeLayout);
        this.tree.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    e.doit = false;
                    DistrictNetworkBreakdownPanel.this.refreshSelection();
                }
            }
        });
        this.tree.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                new ShowSubnetworkAction(DistrictNetworkBreakdownPanel.this.selectedSubgraphs()).run();
            }
        });
        MenuManager menuManager = new MenuManager("District Network Breakdown Actions", "#DistrictNetworkBreakdownPopup");
        menuManager.setRemoveAllWhenShown(true);
        Menu menu = menuManager.createContextMenu((Control)this.tree.getTree());
        this.tree.getTree().setMenu(menu);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                List<Input.Subgraph> sel = DistrictNetworkBreakdownPanel.this.selectedSubgraphs();
                if (sel.size() > 0 && this.fromSameDiagram(sel)) {
                    manager.add((IAction)new ShowSubnetworkAction(sel));
                }
                HashSet<Input.NetworkDiagram> diagrams = new HashSet<Input.NetworkDiagram>();
                if (sel.size() > 0) {
                    for (Input.Subgraph graph : sel) {
                        diagrams.add(graph.parent);
                    }
                }
                if (diagrams.isEmpty()) {
                    diagrams.addAll(DistrictNetworkBreakdownPanel.this.subgraphs.keySet());
                }
                manager.add((IAction)new RefreshAction(diagrams));
            }

            private boolean fromSameDiagram(List<Input.Subgraph> list) {
                Input.NetworkDiagram d = null;
                for (Input.Subgraph sg : list) {
                    if (d == null) {
                        d = sg.parent;
                        continue;
                    }
                    if (d.equals((Object)sg.parent)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    protected void refreshSelection() {
        Object[] objectArray = this.tree.getStructuredSelection().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof Input.NetworkDiagram) {
                this.subgraphs.remove(obj);
                this.tree.refresh(obj);
            }
            ++n2;
        }
    }

    protected void scheduleRefresh(Input.NetworkDiagram diagram) {
        SWTUtils.asyncExec((Widget)this.tree.getTree(), () -> {
            if (!this.tree.getTree().isDisposed()) {
                this.tree.refresh((Object)diagram);
            }
        });
    }

    private void createColumns(TreeColumnLayout layout) {
        TreeViewerColumn nameCol = this.createColumn(0, layout, "Diagram", "Diagram / Subgraph Number", (CellLabelProvider)new NameLabeler(), 1, 100, 16384);
        this.createColumn(1, layout, "Nodes", "Node Count of Subnetwork", (CellLabelProvider)new NodeCountLabeler(), 0, 100, 16384);
        this.createColumn(2, layout, "Edges", "Edge Count of Subnetwork", (CellLabelProvider)new EdgeCountLabeler(), 0, 100, 16384);
        this.setSortColumn(nameCol.getColumn(), 1);
    }

    private TreeViewerColumn createColumn(int index, TreeColumnLayout layout, String text, String tooltip, CellLabelProvider labelProvider, int weight, int minimumWidth, int style) {
        TreeViewerColumn column = new TreeViewerColumn(this.tree, style);
        column.getColumn().setText(text);
        column.getColumn().setToolTipText(StringUtils.safeString((String)tooltip));
        column.getColumn().setResizable(true);
        column.getColumn().setMoveable(true);
        column.getColumn().addSelectionListener(this.getSelectionAdapter(column.getColumn(), index));
        column.setLabelProvider(labelProvider);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight, minimumWidth));
        return column;
    }

    private List<Input.Subgraph> selectedSubgraphs() {
        return ISelectionUtils.filterSelection((ISelection)this.tree.getStructuredSelection(), Input.Subgraph.class);
    }

    private void setSortColumn(TreeColumn column, int index) {
        this.treeComparator.setColumn(index);
        int dir = this.treeComparator.getDirection();
        this.tree.getTree().setSortDirection(dir);
        this.tree.getTree().setSortColumn(column);
    }

    private SelectionListener getSelectionAdapter(final TreeColumn column, final int index) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DistrictNetworkBreakdownPanel.this.setSortColumn(column, index);
                DistrictNetworkBreakdownPanel.this.tree.refresh(true);
            }
        };
    }

    private Runnable setInput(Input.NetworkDiagrams input) {
        return () -> {
            if (!this.tree.getTree().isDisposed()) {
                this.tree.setInput((Object)input);
            }
        };
    }

    private void configureInput(Input.NetworkDiagrams input) {
        SWTUtils.asyncExec((Widget)this, (Runnable)this.setInput(input));
    }

    private void trackInput() {
        this.inputListener = new DisposableListener<Input.NetworkDiagrams>(){

            public void execute(Input.NetworkDiagrams input) {
                DistrictNetworkBreakdownPanel.this.configureInput(input);
            }

            public void exception(Throwable t) {
                LOGGER.error("Problems resolving active models", t);
            }
        };
        Simantics.getSession().asyncRequest((Read)new ResolveInput(Simantics.getProjectResource()), this.inputListener);
    }

    public static boolean openDiagram(List<Input.Subgraph> subgraphs) throws DatabaseException {
        DistrictNetworkUIUtil.Input in;
        if (subgraphs.isEmpty()) {
            return false;
        }
        Input.Subgraph subgraph = subgraphs.get(0);
        Resource dhElement = subgraph.vertices.size() > 0 ? subgraph.vertices.get(0) : (subgraph.edges.size() > 0 ? subgraph.edges.get(0) : null);
        DistrictNetworkUIUtil.Input input = in = dhElement != null ? (DistrictNetworkUIUtil.Input)((Object)Simantics.getSession().syncRequest((Read)new DistrictNetworkUIUtil.ElementToInput(dhElement))) : null;
        if (in != null) {
            ArrayList selection = new ArrayList();
            subgraphs.forEach(sg -> {
                sg.vertices.forEach(selection::add);
                sg.edges.forEach(selection::add);
            });
            DistrictNetworkUIUtil.openDNDiagramEditorWithSelection(in, selection.toArray());
            return true;
        }
        return false;
    }

    private class CalculateSubgraphs
    extends DatabaseJob {
        private Input.NetworkDiagram diagram;

        public CalculateSubgraphs(Input.NetworkDiagram diagram) {
            super("Calculate subgraphs");
            this.diagram = diagram;
            this.setUser(true);
            this.setRule((ISchedulingRule)new ObjectIdentitySchedulingRule((Object)diagram));
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                SubgraphProvider[] sgps = Activator.getInstance().getSubgraphProviders();
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)"Calculating district network breakdown for {0}", (Object)this.diagram.name), (int)sgps.length);
                ArrayList<Input.Subgraph> result = new ArrayList<Input.Subgraph>();
                SubgraphProvider[] subgraphProviderArray = sgps;
                int n = sgps.length;
                int n2 = 0;
                while (n2 < n) {
                    SubgraphProvider sgp = subgraphProviderArray[n2];
                    Input.Subgraph[] subgraphArray = sgp.getProvider((IProgressMonitor)mon.split(1), this.diagram);
                    int n3 = subgraphArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Input.Subgraph sg = subgraphArray[n4];
                        result.add(sg);
                        ++n4;
                    }
                    ++n2;
                }
                DistrictNetworkBreakdownPanel.this.subgraphs.put(this.diagram, result.toArray(new Input.Subgraph[result.size()]));
                DistrictNetworkBreakdownPanel.this.scheduleRefresh(this.diagram);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((Input.NetworkDiagrams)((Object)inputElement)).diagrams.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof Input.Subgraph) {
                return ((Input.Subgraph)element).parent;
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Input.NetworkDiagram) {
                Input.NetworkDiagram nd = (Input.NetworkDiagram)((Object)parentElement);
                Object[] sgs = (Input.Subgraph[])DistrictNetworkBreakdownPanel.this.subgraphs.get((Object)nd);
                if (sgs != null) {
                    return sgs;
                }
                DistrictNetworkBreakdownPanel.this.subgraphs.put(nd, PENDING_RESULT);
                new CalculateSubgraphs(nd).schedule();
                return new Object[]{DistrictNetworkBreakdownPanel.PENDING};
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Input.NetworkDiagram) {
                Input.NetworkDiagram nd = (Input.NetworkDiagram)((Object)element);
                Input.Subgraph[] sgs = (Input.Subgraph[])DistrictNetworkBreakdownPanel.this.subgraphs.get((Object)nd);
                if (sgs != null) {
                    return sgs.length > 0;
                }
                return true;
            }
            return false;
        }
    }

    private class EdgeCountLabeler
    extends ColumnLabelProvider {
        private EdgeCountLabeler() {
        }

        public String getText(Object element) {
            if (element instanceof Input.Subgraph) {
                Input.Subgraph sg = (Input.Subgraph)element;
                return Integer.toString(sg.edges.size());
            }
            return "";
        }
    }

    private class NameLabeler
    extends ColumnLabelProvider {
        private NameLabeler() {
        }

        public String getText(Object element) {
            if (element instanceof Input.NetworkDiagram) {
                return ((Input.NetworkDiagram)((Object)element)).name;
            }
            if (element instanceof Input.Subgraph) {
                return "" + ((Input.Subgraph)element).index;
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            if (element instanceof Input.NetworkDiagram) {
                return (Image)DistrictNetworkBreakdownPanel.this.rm.get((DeviceResourceDescriptor)DistrictNetworkBreakdownPanel.this.mapImg);
            }
            return null;
        }
    }

    private class NodeCountLabeler
    extends ColumnLabelProvider {
        private NodeCountLabeler() {
        }

        public String getText(Object element) {
            if (element instanceof Input.Subgraph) {
                Input.Subgraph sg = (Input.Subgraph)element;
                return Integer.toString(sg.vertices.size());
            }
            return "";
        }
    }

    private class RefreshAction
    extends Action {
        private Set<Input.NetworkDiagram> diagram;

        public RefreshAction(Set<Input.NetworkDiagram> diagrams) {
            super("Refresh");
            this.diagram = diagrams;
        }

        public void run() {
            this.diagram.forEach(d -> {
                DistrictNetworkBreakdownPanel.this.subgraphs.remove(d);
                DistrictNetworkBreakdownPanel.this.tree.refresh();
            });
        }
    }

    private static class ResolveInput
    extends UnaryRead<Resource, Input.NetworkDiagrams> {
        public ResolveInput(Resource parameter) {
            super((Object)parameter);
        }

        public Input.NetworkDiagrams perform(ReadGraph graph) throws DatabaseException {
            DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            Instances index = (Instances)graph.getPossibleAdapter(DN.Diagram, Instances.class);
            Input.NetworkDiagrams result = new Input.NetworkDiagrams();
            for (Resource model : (Collection)graph.syncRequest((Read)new ActiveModels((Resource)this.parameter))) {
                for (Resource diagram : index.find(graph, model)) {
                    Resource composite = graph.getPossibleObject(diagram, MOD.DiagramToComposite);
                    String name = NameLabelUtil.modalName((ReadGraph)graph, (Resource)(composite != null ? composite : diagram), (NameLabelMode)NameLabelMode.NAME_AND_LABEL);
                    result.diagrams.add(new Input.NetworkDiagram(name, diagram));
                }
            }
            return result;
        }
    }

    private static class ShowSubnetworkAction
    extends Action {
        private final List<Input.Subgraph> subgraphs;

        public ShowSubnetworkAction(List<Input.Subgraph> subgraphs) {
            super("Show Subnetwork on Diagram");
            this.subgraphs = subgraphs;
        }

        public void run() {
            try {
                DistrictNetworkBreakdownPanel.openDiagram(this.subgraphs);
            }
            catch (DatabaseException e) {
                LOGGER.error("Failed to show selected subnetwork", (Throwable)e);
            }
        }
    }

    public class TreeComparator
    extends ViewerComparator {
        private static final int DESCENDING = 1;
        private int propertyIndex = -1;
        private int direction = 0;

        public int getDirection() {
            return this.direction == 1 ? 1024 : 128;
        }

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = 0;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int rc = 0;
            if (e1 instanceof Input.NetworkDiagram) {
                Input.NetworkDiagram nd1 = (Input.NetworkDiagram)((Object)e1);
                Input.NetworkDiagram nd2 = (Input.NetworkDiagram)((Object)e2);
                rc = AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)nd1.name, (Object)nd2.name);
            } else if (e1 instanceof Input.Subgraph) {
                Input.Subgraph sg1 = (Input.Subgraph)e1;
                Input.Subgraph sg2 = (Input.Subgraph)e2;
                switch (this.propertyIndex) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        rc = Integer.compare(sg1.vertices.size(), sg2.vertices.size());
                        break;
                    }
                    case 2: {
                        rc = Integer.compare(sg1.edges.size(), sg2.edges.size());
                        break;
                    }
                    default: {
                        rc = 0;
                    }
                }
            }
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }
}

