/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.adapters;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import org.simantics.district.network.ModelledCRS;
import org.simantics.district.network.ui.DistrictNetworkEdge;
import org.simantics.district.network.ui.adapters.DistrictNetworkAdditionalColor;
import org.simantics.district.network.ui.nodes.DistrictNetworkEdgeNode;
import org.simantics.g2d.connection.handler.ConnectionHandler;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.Pick;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.impl.ConnectionSelectionOutline;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.maps.MapScalingTransform;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.SVGNode;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistrictNetworkEdgeElement {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistrictNetworkEdgeElement.class);
    public static final IHintContext.Key KEY_DN_EDGE = new IHintContext.KeyOf(DistrictNetworkEdge.class, "DN_EDGE");
    public static final IHintContext.Key KEY_DN_EDGE_NODE = new SceneGraphNodeKey(DistrictNetworkEdgeNode.class, "DN_EDGE_NODE");
    public static final IHintContext.Key KEY_DN_EDGE_SYMBOL_NODE = new SceneGraphNodeKey(DistrictNetworkEdgeNode.class, "DN_EDGE_SYMBOL_NODE");
    public static final ElementClass CLASS = ElementClass.compile((ElementHandler[])new ElementHandler[]{DefaultTransform.INSTANCE, DNEdgeInternalSize.INSTANCE, DNEdgeSceneGraph.INSTANCE, DNEdgeConnectionHandler.INSTANCE, SimpleElementLayers.INSTANCE, ConnectionSelectionOutline.INSTANCE, DistrictNetworkAdditionalColor.INSTANCE}).setId(DistrictNetworkEdgeElement.class.getSimpleName());

    static class DNEdgeConnectionHandler
    implements ConnectionHandler {
        private static final long serialVersionUID = -6882671891381761687L;
        public static final DNEdgeConnectionHandler INSTANCE = new DNEdgeConnectionHandler();

        DNEdgeConnectionHandler() {
        }

        public Collection<IElement> getChildren(IElement connection, Collection<IElement> result) {
            return Collections.emptyList();
        }

        public Collection<IElement> getBranchPoints(IElement connection, Collection<IElement> result) {
            return Collections.emptyList();
        }

        public Collection<IElement> getSegments(IElement connection, Collection<IElement> result) {
            return Collections.emptyList();
        }

        public Collection<Topology.Connection> getTerminalConnections(IElement connection, Collection<Topology.Connection> result) {
            return Collections.emptyList();
        }
    }

    static final class DNEdgeInternalSize
    implements InternalSize,
    Outline,
    Pick {
        private static final Logger LOGGER = LoggerFactory.getLogger(DNEdgeInternalSize.class);
        private static final long serialVersionUID = -7346653820911240628L;
        public static final DNEdgeInternalSize INSTANCE = new DNEdgeInternalSize();

        DNEdgeInternalSize() {
        }

        public Rectangle2D getBounds(IElement e, Rectangle2D size) {
            DistrictNetworkEdgeNode edgeNode = (DistrictNetworkEdgeNode)((Object)e.getHint(KEY_DN_EDGE_NODE));
            if (size == null) {
                size = new Rectangle2D.Double();
            }
            if (edgeNode != null) {
                size.setFrame(edgeNode.getBoundsInLocal());
            } else {
                LOGGER.debug("Element {} does not have edge!", (Object)e);
            }
            return size;
        }

        public Shape getElementShape(IElement e) {
            DistrictNetworkEdgeNode edgeNode = (DistrictNetworkEdgeNode)((Object)e.getHint(KEY_DN_EDGE_NODE));
            if (edgeNode != null) {
                return edgeNode.getPath();
            }
            return this.getBounds(e, null);
        }

        public boolean pickTest(IElement e, Shape s, PickRequest.PickPolicy policy) {
            DistrictNetworkEdge edge = (DistrictNetworkEdge)e.getHint(KEY_DN_EDGE);
            if (edge != null) {
                Rectangle2D bounds = this.getBounds(s);
                switch (policy) {
                    case PICK_CONTAINED_OBJECTS: {
                        return this.pickContainedObjects(edge, bounds);
                    }
                    case PICK_INTERSECTING_OBJECTS: {
                        return this.pickIntersectingObjects(e, edge, bounds);
                    }
                }
                return false;
            }
            return false;
        }

        private boolean pickContainedObjects(DistrictNetworkEdge edge, Rectangle2D bounds) {
            double bminx = bounds.getMinX() / MapScalingTransform.getScaleX();
            double bminy = bounds.getMinY() / MapScalingTransform.getScaleY();
            double bmaxx = bounds.getMaxX() / MapScalingTransform.getScaleX();
            double bmaxy = bounds.getMaxY() / MapScalingTransform.getScaleY();
            double bsminx = ModelledCRS.xToLongitude((double)bminx);
            double bsminy = ModelledCRS.yToLatitude((double)(-bminy));
            double bsmaxx = ModelledCRS.xToLongitude((double)bmaxx);
            double bsmaxy = ModelledCRS.yToLatitude((double)(-bmaxy));
            double boundsMinY = Math.min(bsminy, bsmaxy);
            double boundsMaxY = Math.max(bsminy, bsmaxy);
            Point2D start = edge.getStartPoint();
            Point2D end = edge.getEndPoint();
            double eminx = Math.min(start.getX(), end.getX());
            double eminy = Math.min(start.getY(), end.getY());
            double emaxx = Math.max(start.getX(), end.getX());
            double emaxy = Math.max(start.getY(), end.getY());
            return eminx >= bsminx && eminy >= boundsMinY && emaxx <= bsmaxx && emaxy <= boundsMaxY;
        }

        private boolean pickIntersectingObjects(IElement e, DistrictNetworkEdge edge, Rectangle2D bounds) {
            double dx = bounds.getWidth() / MapScalingTransform.getScaleX();
            double dy = bounds.getHeight() / MapScalingTransform.getScaleY();
            DistrictNetworkEdgeNode node = (DistrictNetworkEdgeNode)((Object)e.getHint(KEY_DN_EDGE_NODE));
            AffineTransform at = NodeUtil.getLocalToGlobalTransform((IG2DNode)node);
            Path2D path = node.getPath();
            if (path == null) {
                return false;
            }
            double lineWidth = node.getStrokeWidth(at, true);
            double tolerance = Math.sqrt(dx * dx + dy * dy) / 2.0 + lineWidth / 2.0;
            double sx = bounds.getCenterX() / MapScalingTransform.getScaleX();
            double sy = bounds.getCenterY() / MapScalingTransform.getScaleY();
            double[] coords = new double[6];
            Point2D.Double prevPoint = new Point2D.Double();
            Point2D.Double curPoint = new Point2D.Double();
            Line2D.Double line = new Line2D.Double();
            PathIterator it = path.getPathIterator(null);
            while (!it.isDone()) {
                int type = it.currentSegment(coords);
                switch (type) {
                    case 0: {
                        ((Point2D)curPoint).setLocation(coords[0], coords[1]);
                        break;
                    }
                    case 1: {
                        prevPoint.setLocation(curPoint);
                        ((Point2D)curPoint).setLocation(coords[0], coords[1]);
                        line.setLine(prevPoint, curPoint);
                        double distSq = line.ptSegDistSq(sx, sy);
                        if (!(distSq <= tolerance * tolerance)) break;
                        return true;
                    }
                    default: {
                        LOGGER.error("Invalid edge path", (Throwable)new IllegalStateException());
                        return false;
                    }
                }
                it.next();
            }
            return false;
        }

        private Rectangle2D getBounds(Shape shape) {
            if (shape instanceof Rectangle2D) {
                return (Rectangle2D)shape;
            }
            return shape.getBounds2D();
        }
    }

    static final class DNEdgeSceneGraph
    implements SceneGraph {
        public static final DNEdgeSceneGraph INSTANCE = new DNEdgeSceneGraph();
        private static final long serialVersionUID = 68135568495835923L;

        DNEdgeSceneGraph() {
        }

        public void init(IElement edgeElement, G2DParentNode parent) {
            try {
                DistrictNetworkEdge edge = (DistrictNetworkEdge)edgeElement.getHint(KEY_DN_EDGE);
                if (edge == null) {
                    this.cleanup(edgeElement);
                } else {
                    DistrictNetworkEdgeNode node = (DistrictNetworkEdgeNode)((Object)edgeElement.getHint(KEY_DN_EDGE_NODE));
                    if (node == null) {
                        node = (DistrictNetworkEdgeNode)((Object)parent.addNode(ElementUtils.generateNodeId((IElement)edgeElement), DistrictNetworkEdgeNode.class));
                        edgeElement.setHint(KEY_DN_EDGE_NODE, (Object)node);
                        SVGNode symbol = (SVGNode)node.addNode(ElementUtils.generateNodeId((IElement)edgeElement), SVGNode.class);
                        edgeElement.setHint(KEY_DN_EDGE_SYMBOL_NODE, (Object)symbol);
                    }
                    node.setColor(ElementUtils.getAdditionalColor((IElement)edgeElement, (Color)Color.BLUE));
                    node.setDNEdge(edge);
                    AffineTransform at = ElementUtils.getTransform((IElement)edgeElement);
                    if (at != null) {
                        node.setTransform(at);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not initialize element {} for parent {}", new Object[]{edgeElement, parent, e});
            }
        }

        public void cleanup(IElement edge) {
            ElementUtils.removePossibleNode((IElement)edge, (IHintContext.Key)KEY_DN_EDGE_SYMBOL_NODE);
            ElementUtils.removePossibleNode((IElement)edge, (IHintContext.Key)KEY_DN_EDGE_NODE);
            edge.removeHint(KEY_DN_EDGE_NODE);
            edge.removeHint(KEY_DN_EDGE_SYMBOL_NODE);
        }
    }
}

