/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.maps.MapScalingTransform;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.utils.page.MarginUtils;

public class DistrictTransformUtil
extends TransformUtil {
    public void fitArea(Rectangle2D controlArea, Rectangle2D diagramArea, MarginUtils.Margins margins) {
        if (margins == null) {
            MarginUtils.Margin margin = MarginUtils.marginOf((double)0.0, (double)0.0, (double)0.0);
            margins = new MarginUtils.Margins(margin, margin, margin, margin);
        }
        GeometryUtils.expandRectangle((Rectangle2D)diagramArea, (double)-1.0);
        diagramArea = GeometryUtils.expandRectangle((Rectangle2D)diagramArea, (double)margins.top.diagramAbsolute, (double)margins.bottom.diagramAbsolute, (double)margins.left.diagramAbsolute, (double)margins.right.diagramAbsolute);
        controlArea = GeometryUtils.expandRectangle((Rectangle2D)controlArea, (double)(-margins.top.controlAbsolute - margins.top.controlRelative * controlArea.getHeight()), (double)(-margins.bottom.controlAbsolute - margins.bottom.controlRelative * controlArea.getHeight()), (double)(-margins.left.controlAbsolute - margins.left.controlRelative * controlArea.getWidth()), (double)(-margins.right.controlAbsolute - margins.right.controlRelative * controlArea.getWidth()));
        double controlAspectRatio = controlArea.getWidth() / controlArea.getHeight();
        double canvasAspectRatio = diagramArea.getWidth() / diagramArea.getHeight();
        double scale = 1.0;
        double tx = 0.0;
        double ty = 0.0;
        scale = controlAspectRatio > canvasAspectRatio ? controlArea.getHeight() / diagramArea.getHeight() : controlArea.getWidth() / diagramArea.getWidth();
        AffineTransform current = this.getTransform();
        double currentX = current.getScaleX();
        double targetX = scale;
        double toBeX = currentX;
        if (targetX > 0.0) {
            if (targetX == Double.POSITIVE_INFINITY) {
                targetX = Double.MAX_VALUE;
            }
            AffineTransform tar = new AffineTransform();
            tar.scale(targetX, targetX);
            int tarZoomLevel = MapScalingTransform.zoomLevel((AffineTransform)tar);
            toBeX = tarZoomLevel < 20 && tarZoomLevel > 0 ? Math.pow(2.0, tarZoomLevel) : (tarZoomLevel > 20 ? Math.pow(2.0, 20.0) : (tarZoomLevel < 0 ? 2.0 : targetX));
            if (controlAspectRatio > canvasAspectRatio) {
                tx = (controlArea.getWidth() - diagramArea.getWidth() * toBeX) / 2.0;
                ty = diagramArea.getHeight() * (targetX - toBeX) / 2.0;
            } else {
                ty = (controlArea.getHeight() - diagramArea.getHeight() * toBeX) / 2.0;
                tx = diagramArea.getWidth() * (targetX - toBeX) / 2.0;
            }
            AffineTransform at = new AffineTransform();
            at.translate(tx, ty);
            at.translate(controlArea.getMinX(), controlArea.getMinY());
            at.scale(toBeX, toBeX);
            at.translate(-diagramArea.getMinX(), -diagramArea.getMinY());
            this.setTransform(at);
        }
    }
}

