/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.actions.NavigateToTarget;
import org.simantics.scl.runtime.tuple.Tuple4;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.SWTUtils;

public class DistrictNetworkUIUtil {
    public static Resource getInputResource(ReadGraph graph, Object input) throws DatabaseException {
        if (input instanceof Resource) {
            return (Resource)input;
        }
        if (input instanceof Variable) {
            return ((Variable)input).getPossibleRepresents(graph);
        }
        if (input instanceof ISelection) {
            return (Resource)ISelectionUtils.filterSingleSelection((Object)((ISelection)input), Resource.class);
        }
        return WorkbenchSelectionUtils.getPossibleResource((RequestProcessor)graph, (Object)input);
    }

    public static Consumer<IEditorPart> editorActivationCallback(Collection<? extends Object> selectedObjects) {
        return part -> {
            ICanvasContext openedCanvas = (ICanvasContext)part.getAdapter(ICanvasContext.class);
            assert (openedCanvas != null);
            openedCanvas.getDefaultHintContext().setHint(DiagramHints.KEY_INITIAL_ZOOM_TO_FIT, (Object)Boolean.FALSE);
            ThreadUtils.asyncExec((IThreadWorkQueue)openedCanvas.getThreadAccess(), (Runnable)NavigateToTarget.elementSelectorZoomer((ICanvasContext)openedCanvas, (Collection)selectedObjects, (boolean)false));
        };
    }

    public static void openEditorWithSelection(String editorId, Input input, Object ... selection) {
        NavigateToTarget.editorActivator((String)editorId, (Resource)input.diagram(), (Resource)input.model(), (RVI)input.rvi(), DistrictNetworkUIUtil.editorActivationCallback(Arrays.asList(selection))).run();
    }

    public static void openDNDiagramEditorWithSelection(Input input, Object ... selection) {
        DistrictNetworkUIUtil.openEditorWithSelection("org.simantics.district.network.ui.diagrameditor", input, selection);
    }

    public static boolean openDNDiagramWithSelection(Display display, List<Resource> dnElements) throws DatabaseException {
        if (dnElements.isEmpty()) {
            return false;
        }
        Input in = (Input)((Object)Simantics.getSession().syncRequest((Read)new ElementToInput(dnElements.get(0))));
        if (in == null) {
            return false;
        }
        SWTUtils.asyncExec((Display)display, () -> DistrictNetworkUIUtil.openDNDiagramEditorWithSelection(in, dnElements.toArray()));
        return true;
    }

    public static class ElementToInput
    extends UnaryRead<Resource, Input> {
        public ElementToInput(Resource element) {
            super((Object)element);
        }

        public Input perform(ReadGraph graph) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Resource diagram = graph.getPossibleObject((Resource)this.parameter, L0.PartOf);
            if (diagram == null) {
                return null;
            }
            Resource model = (Resource)graph.syncRequest((Read)new PossibleModel(diagram));
            if (model == null) {
                return null;
            }
            RVI rvi = ElementToInput.getDiagramCompositeRvi(graph, diagram);
            if (rvi == null) {
                return null;
            }
            return new Input(model, diagram, (Resource)this.parameter, rvi);
        }

        private static RVI getDiagramCompositeRvi(ReadGraph graph, Resource diagram) throws DatabaseException {
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            Resource composite = graph.getPossibleObject(diagram, MOD.DiagramToComposite);
            if (composite == null) {
                return null;
            }
            Variable v = Variables.getPossibleVariable((ReadGraph)graph, (Resource)composite);
            return v != null ? v.getPossibleRVI(graph) : null;
        }
    }

    public static class FindMappedComponent
    extends UnaryRead<Object, Input> {
        public FindMappedComponent(Object parameter) {
            super(parameter);
        }

        public Input perform(ReadGraph graph) throws DatabaseException {
            Resource e = DistrictNetworkUtil.getMappedElement((ReadGraph)graph, (Resource)DistrictNetworkUIUtil.getInputResource(graph, this.parameter));
            return e != null ? (Input)((Object)graph.syncRequest((Read)new ElementToInput(e))) : null;
        }
    }

    public static class FindMappedDNElement
    extends UnaryRead<Object, Input> {
        public FindMappedDNElement(Object parameter) {
            super(parameter);
        }

        public Input perform(ReadGraph graph) throws DatabaseException {
            Resource e = DistrictNetworkUtil.getMappedDNElement((ReadGraph)graph, (Resource)DistrictNetworkUtil.getDiagramElement((ReadGraph)graph, (Resource)DistrictNetworkUIUtil.getInputResource(graph, this.parameter)));
            return e != null ? (Input)((Object)graph.syncRequest((Read)new ElementToInput(e))) : null;
        }
    }

    public static class GetInputResource
    extends UnaryRead<Object, Resource> {
        public GetInputResource(Object input) {
            super(input);
        }

        public Resource perform(ReadGraph graph) throws DatabaseException {
            return DistrictNetworkUIUtil.getInputResource(graph, this.parameter);
        }
    }

    public static class Input
    extends Tuple4 {
        public Input(Resource model, Resource diagram, Resource element, RVI diagramCompositeRvi) {
            super((Object)model, (Object)diagram, (Object)element, (Object)diagramCompositeRvi);
        }

        public Resource model() {
            return (Resource)this.get(0);
        }

        public Resource diagram() {
            return (Resource)this.get(1);
        }

        public Resource element() {
            return (Resource)this.get(2);
        }

        public RVI rvi() {
            return (RVI)this.get(3);
        }
    }
}

