/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.prefs;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class MapsClientPreferences {
    public static final String P_NODE = "org.simantics.district.maps";
    public static final String P_TILESERVER_URL = "org.simantics.district.maps.prefs.tileserverURL";
    public static final String P_USE_BUILTIN = "org.simantics.district.maps.prefs.tileserverURL";
    public static final String P_DEFAULT_PORT = "org.simantics.maps.server.defaultPort";
    public static final String P_CURRENT_MBTILES = "org.simantics.maps.server.currentMbTiles";
    public static final String P_CURRENT_TM2STYLE = "org.simantics.maps.server.currentTM2Style";
    public static final String P_SERVER_NODE = "org.simantics.maps.server";

    public static IEclipsePreferences getServerPreferences() {
        return InstanceScope.INSTANCE.getNode(P_SERVER_NODE);
    }

    public static IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode(P_NODE);
    }

    public static String tileserverURL() {
        return MapsClientPreferences.getPreferences().get("org.simantics.district.maps.prefs.tileserverURL", "");
    }

    public static boolean useBuiltinServer() {
        return MapsClientPreferences.getPreferences().getBoolean("org.simantics.district.maps.prefs.tileserverURL", true);
    }

    public static String possibleBuiltinServerURL() {
        int port = MapsClientPreferences.getServerPreferences().getInt(P_DEFAULT_PORT, 8585);
        String style = MapsClientPreferences.getServerPreferences().get(P_CURRENT_TM2STYLE, "mapbox-studio-osm-bright.tm2");
        if (port != -1 && style != null) {
            try {
                return new URL("http", "localhost", port, "/" + style).toString();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static void addPreferenceChangeListenerMapsServer(IEclipsePreferences.IPreferenceChangeListener listener) {
        MapsClientPreferences.getServerPreferences().addPreferenceChangeListener(listener);
    }

    public static void removePreferenceChangeListenerMapsServer(IEclipsePreferences.IPreferenceChangeListener listener) {
        MapsClientPreferences.getServerPreferences().removePreferenceChangeListener(listener);
    }
}

