/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.osm;

import java.awt.geom.Rectangle2D;
import java.net.MalformedURLException;

public class OSMGetMapQuery {
    String srs = "EPSG:4326";
    int width;
    int height;
    Rectangle2D bbox;
    String[] styles;
    String[] layers;
    String format;

    public OSMGetMapQuery(int width, int height, Rectangle2D bbox, String format, String ... layers) throws MalformedURLException {
        this.width = width;
        this.height = height;
        this.bbox = bbox;
        this.format = format;
        this.layers = layers;
    }

    public void setSpatialReferenceSystem(String srs) {
        this.srs = srs;
    }

    public void setStyles(String ... styles) {
        this.styles = styles;
    }

    public void setLayers(String ... layers) {
        this.layers = layers;
    }

    public static String getTileNumber(double lat, double lon, int zoom) {
        int xtile = (int)Math.floor((lon + 180.0) / 360.0 * (double)(1 << zoom));
        int ytile = (int)Math.floor((1.0 - Math.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0 * (double)(1 << zoom));
        return zoom + "/" + xtile + "/" + ytile + ".png";
    }

    public String toString() {
        return OSMGetMapQuery.getTileNumber(this.bbox.getMinX(), this.bbox.getMinY(), 16);
    }
}

