/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.imports.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.simantics.district.imports.CSVImportModel;
import org.simantics.district.imports.DistrictImportUtils;
import org.simantics.district.imports.ui.CSVImportWizardFirstPage;
import org.simantics.district.imports.ui.CSVImportWizardPage;
import org.simantics.district.imports.ui.ComponentMappingPage;
import org.simantics.utils.ui.ExceptionUtils;

public class CSVImportWizard
extends Wizard
implements IImportWizard {
    private CSVImportModel model;

    public CSVImportWizard() {
        this.setWindowTitle("Import CSV data");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.model = new CSVImportModel();
        this.addPage((IWizardPage)new CSVImportWizardFirstPage(this.model));
        this.addPage((IWizardPage)new CSVImportWizardPage(this.model));
        this.addPage((IWizardPage)new ComponentMappingPage(this.model));
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask("Importing CSV", 1);
                        if (CSVImportWizard.this.model.isVertexImport()) {
                            DistrictImportUtils.importVertices((CSVImportModel)CSVImportWizard.this.model);
                        } else {
                            DistrictImportUtils.importEdges((CSVImportModel)CSVImportWizard.this.model);
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            return true;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            WizardPage cp = (WizardPage)this.getContainer().getCurrentPage();
            cp.setErrorMessage(t.getMessage());
            ExceptionUtils.logAndShowError((Throwable)t);
            return false;
        }
        catch (InterruptedException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
            return false;
        }
    }
}

