/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.devs.internal;

import java.util.Arrays;
import java.util.Collection;
import org.simantics.scl.devs.internal.Task;

public class TaskQueue {
    Task[] tasks = new Task[16];
    int size = 0;

    public Task head() {
        return this.tasks[0];
    }

    public void pop() {
        this.tasks[0].queuePos = -1;
        --this.size;
        if (this.size > 0) {
            Task e;
            this.tasks[0] = e = this.tasks[this.size];
            e.queuePos = 0;
            this.adjustDown(e);
        }
        this.tasks[this.size] = null;
    }

    private void heads(int i, double t, Collection<Task> accum) {
        if (this.tasks[i].time <= t) {
            accum.add(this.tasks[i]);
            i *= 2;
            if (++i >= this.size) {
                return;
            }
            this.heads(i, t, accum);
            if (++i >= this.size) {
                return;
            }
            this.heads(i, t, accum);
        }
    }

    public void heads(Collection<Task> accum) {
        this.heads(0, this.tasks[0].time, accum);
    }

    public void add(Task e) {
        if (this.size == this.tasks.length) {
            this.tasks = Arrays.copyOf(this.tasks, this.size + this.size / 2);
        }
        this.tasks[this.size] = e;
        e.queuePos = this.size++;
        this.adjustUp(e);
    }

    private boolean adjustUp(Task e) {
        int pos = e.queuePos;
        while (pos > 0) {
            int upId = (pos - 1) / 2;
            Task upE = this.tasks[upId];
            if (e.time >= upE.time) break;
            this.tasks[pos] = upE;
            upE.queuePos = pos;
            pos = upId;
        }
        if (e.queuePos != pos) {
            this.tasks[pos] = e;
            e.queuePos = pos;
            return true;
        }
        return false;
    }

    private void adjustDown(Task e) {
        int downId;
        int pos = e.queuePos;
        while ((downId = pos * 2 + 1) < this.size) {
            if (downId + 1 < this.size && this.tasks[downId].time > this.tasks[downId + 1].time) {
                ++downId;
            }
            Task downE = this.tasks[downId];
            if (!(e.time > downE.time)) break;
            this.tasks[pos] = downE;
            downE.queuePos = pos;
            pos = downId;
        }
        if (e.queuePos != pos) {
            this.tasks[pos] = e;
            e.queuePos = pos;
        }
    }

    public void adjust(Task e) {
        if (!this.adjustUp(e)) {
            this.adjustDown(e);
        }
    }

    public boolean isEmpty() {
        return this.size == 0;
    }
}

