/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.devs;

import org.simantics.scl.devs.internal.Composed;
import org.simantics.scl.runtime.function.Function;

public class EventChannel<T> {
    protected Object listener;

    public void send(T value) {
        if (this.listener != null) {
            EventChannel.send(this.listener, value);
        }
    }

    protected static <T> void send(Object listener, T value) {
        while (true) {
            if (listener instanceof Function) {
                ((Function)listener).apply(value);
                return;
            }
            Composed composed = (Composed)listener;
            EventChannel.send(composed.a, value);
            listener = composed.b;
        }
    }

    public void listen(Function listener) {
        this.listener = this.listener == null ? listener : new Composed(listener, this.listener);
    }
}

