/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.devs;

import org.simantics.scl.devs.internal.MersenneTwisterFast;
import org.simantics.scl.devs.internal.Task;
import org.simantics.scl.devs.internal.TaskQueue;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.tuple.Tuple0;

public class DevsContext {
    private double currentTime;
    private TaskQueue taskQueue = new TaskQueue();
    private MersenneTwisterFast random;

    public DevsContext() {
        this.random = new MersenneTwisterFast();
    }

    public DevsContext(long seed) {
        this.random = new MersenneTwisterFast(seed);
    }

    public double getCurrentTime() {
        return this.currentTime;
    }

    public void schedule(Task task, double time) {
        if (time < this.currentTime) {
            throw new IllegalArgumentException("Cannot schedule tasks into the past. (currentTime=" + this.currentTime + "scheduledTime=" + time + ")");
        }
        task.time = time;
        if (task.inQueue()) {
            this.taskQueue.adjust(task);
        } else {
            this.taskQueue.add(task);
        }
    }

    public void simulateDuration(double duration) {
        SCLContext context = SCLContext.getCurrent();
        Object oldDevsContext = context.put((Object)"devs", (Object)this);
        try {
            double endTime = this.currentTime + duration;
            while (!this.taskQueue.isEmpty()) {
                Task head = this.taskQueue.head();
                if (head.time > endTime) break;
                this.taskQueue.pop();
                this.currentTime = head.time;
                head.function.apply((Object)Tuple0.INSTANCE);
            }
            this.currentTime = endTime;
        }
        finally {
            context.put((Object)"devs", oldDevsContext);
        }
    }

    public double rndUniform() {
        return this.random.nextDouble();
    }

    public boolean rndChoice(double probability) {
        return this.random.nextBoolean(probability);
    }

    public double rndGaussian() {
        return this.random.nextGaussian();
    }

    public int rndInteger(int n) {
        return this.random.nextInt(n);
    }

    public static DevsContext createModel(Function f) {
        return DevsContext.createModelInternal(f, new DevsContext());
    }

    public static DevsContext createModelWithSeed(long seed, Function f) {
        return DevsContext.createModelInternal(f, new DevsContext(seed));
    }

    private static DevsContext createModelInternal(Function f, DevsContext devsContext) {
        SCLContext context = SCLContext.getCurrent();
        Object oldDevsContext = context.put((Object)"devs", (Object)devsContext);
        try {
            f.apply((Object)Tuple0.INSTANCE);
        }
        finally {
            context.put((Object)"devs", oldDevsContext);
        }
        return devsContext;
    }
}

