/*
 * Decompiled with CFR 0.152.
 */
package xtc.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public final class Utilities {
    private static final int BUFFER_SIZE = 4096;
    private static char[] charBuffer = null;
    public static final Pattern WHITE_SPACE = Pattern.compile("\\s+");
    public static final Pattern SPACE_NEWLINE_SPACE = Pattern.compile("[ \t\f]*(?:\r\n|\r|\n)[ \t\f]*");
    public static final Pattern COMMENT_NEWLINE = Pattern.compile("[ \t\f]*(?:\r\n|\r|\n)[ \t\f]*\\**[ \t\f]*");
    public static final int ESCAPE_BELL_VT = 1;
    public static final int ESCAPE_DOUBLE = 2;
    public static final int ESCAPE_REGEX = 4;
    public static final int ESCAPE_UNICODE = 8;
    public static final int ESCAPE_HTML = 16;
    public static final int C_ESCAPES = 9;
    public static final int JAVA_ESCAPES = 8;
    public static final int JAVA_HTML_ESCAPES = 24;
    public static final int FULL_ESCAPES = 12;
    public static final int FULL_HTML_ESCAPES = 28;

    private Utilities() {
    }

    public static boolean isQualified(String name) {
        int length = name.length();
        boolean opaque = false;
        int i = 0;
        while (i < length) {
            char c = name.charAt(i);
            if (opaque) {
                if (')' == c) {
                    opaque = false;
                }
            } else {
                if ('.' == c) {
                    return true;
                }
                if ('(' == c) {
                    opaque = true;
                }
            }
            ++i;
        }
        return false;
    }

    public static String getQualifier(String qname) {
        boolean opaque = false;
        int i = qname.length() - 1;
        while (i >= 0) {
            char c = qname.charAt(i);
            if (opaque) {
                if ('(' == c) {
                    opaque = false;
                }
            } else {
                if ('.' == c) {
                    return qname.substring(0, i);
                }
                if (')' == c) {
                    opaque = true;
                }
            }
            --i;
        }
        return null;
    }

    public static String getName(String qname) {
        boolean opaque = false;
        int i = qname.length() - 1;
        while (i >= 0) {
            char c = qname.charAt(i);
            if (opaque) {
                if ('(' == c) {
                    opaque = false;
                }
            } else {
                if ('.' == c) {
                    return qname.substring(i + 1);
                }
                if (')' == c) {
                    opaque = true;
                }
            }
            --i;
        }
        return qname;
    }

    public static String unqualify(String name) {
        return Utilities.isQualified(name) ? Utilities.getName(name) : name;
    }

    public static String qualify(String qualifier, String name) {
        return qualifier == null ? name : String.valueOf(qualifier) + '.' + name;
    }

    public static String[] toComponents(String qname) {
        int length = qname.length();
        int count = 1;
        boolean opaque = false;
        int i = 0;
        while (i < length) {
            char c = qname.charAt(i);
            if (opaque) {
                if (')' == c) {
                    opaque = false;
                }
            } else {
                if ('.' == c) {
                    ++count;
                }
                if ('(' == c) {
                    opaque = true;
                }
            }
            ++i;
        }
        if (1 == count) {
            return new String[]{qname};
        }
        String[] components = new String[count];
        int start = -1;
        count = 0;
        int i2 = 0;
        while (i2 < length) {
            char c = qname.charAt(i2);
            if (opaque) {
                if (')' == c) {
                    opaque = false;
                }
            } else if ('.' == c) {
                components[count] = qname.substring(start + 1, i2);
                start = i2;
                ++count;
            } else if ('(' == c) {
                opaque = true;
            }
            ++i2;
        }
        components[count] = qname.substring(start + 1, length);
        return components;
    }

    private static String requalify(String s, char qual) {
        int length = s.length();
        StringBuilder buf = new StringBuilder(length);
        boolean opaque = false;
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            if (opaque) {
                buf.append(c);
                if (')' == c) {
                    opaque = false;
                }
            } else if ('.' == c) {
                buf.append(qual);
            } else {
                buf.append(c);
                if ('(' == c) {
                    opaque = true;
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String toIdentifier(String qname) {
        return Utilities.requalify(qname, '$');
    }

    public static String toPath(String qname) {
        return Utilities.requalify(qname, File.separatorChar);
    }

    public static String toPath(String qname, String ext) {
        return String.valueOf(Utilities.toPath(qname)) + '.' + ext;
    }

    public static File locate(List<File> roots, String path) throws FileNotFoundException {
        for (File root : roots) {
            File file = new File(root, path);
            if (!file.exists() || !file.isFile()) continue;
            return file;
        }
        throw new FileNotFoundException(String.valueOf(path) + " not found");
    }

    public static void pump(Reader in, Writer out) throws IOException {
        if (charBuffer == null) {
            charBuffer = new char[4096];
        }
        int number = in.read(charBuffer);
        while (-1 != number) {
            out.write(charBuffer, 0, number);
            number = in.read(charBuffer);
        }
    }

    public static String withoutSpace(String s) {
        return WHITE_SPACE.matcher(s).replaceAll("");
    }

    public static boolean useBellVTEscapes(int flags) {
        return (1 & flags) != 0;
    }

    public static boolean useDoubleEscapes(int flags) {
        return (2 & flags) != 0;
    }

    public static boolean useRegexEscapes(int flags) {
        return (4 & flags) != 0;
    }

    public static boolean useUnicodeEscapes(int flags) {
        return (8 & flags) != 0;
    }

    public static boolean useHTMLEscapes(int flags) {
        return (0x10 & flags) != 0;
    }

    public static void escape(char c, Appendable out, int flags) throws IOException {
        switch (c) {
            case '\u0007': {
                if (!Utilities.useBellVTEscapes(flags)) break;
                if (Utilities.useDoubleEscapes(flags)) {
                    out.append("\\\\a");
                    break;
                }
                out.append("\\a");
                break;
            }
            case '\b': {
                if (Utilities.useDoubleEscapes(flags)) {
                    out.append("\\\\b");
                } else {
                    out.append("\\b");
                }
                return;
            }
            case '\t': {
                if (Utilities.useDoubleEscapes(flags)) {
                    out.append("\\\\t");
                } else {
                    out.append("\\t");
                }
                return;
            }
            case '\n': {
                if (Utilities.useDoubleEscapes(flags)) {
                    out.append("\\\\n");
                } else {
                    out.append("\\n");
                }
                return;
            }
            case '\u000b': {
                if (!Utilities.useBellVTEscapes(flags)) break;
                if (Utilities.useDoubleEscapes(flags)) {
                    out.append("\\\\v");
                    break;
                }
                out.append("\\v");
                break;
            }
            case '\f': {
                if (Utilities.useDoubleEscapes(flags)) {
                    out.append("\\\\f");
                } else {
                    out.append("\\f");
                }
                return;
            }
            case '\r': {
                if (Utilities.useDoubleEscapes(flags)) {
                    out.append("\\\\r");
                } else {
                    out.append("\\r");
                }
                return;
            }
            case '\"': {
                if (Utilities.useDoubleEscapes(flags)) {
                    out.append("\\\\\\\"");
                } else {
                    out.append("\\\"");
                }
                return;
            }
            case '\'': {
                if (Utilities.useDoubleEscapes(flags)) {
                    out.append("\\\\\\'");
                } else {
                    out.append("\\'");
                }
                return;
            }
            case '-': {
                if (Utilities.useRegexEscapes(flags)) {
                    if (Utilities.useDoubleEscapes(flags)) {
                        out.append("\\\\-");
                    } else {
                        out.append("\\-");
                    }
                } else {
                    out.append('-');
                }
                return;
            }
            case '<': {
                if (Utilities.useHTMLEscapes(flags)) {
                    out.append("&lt;");
                } else {
                    out.append('<');
                }
                return;
            }
            case '>': {
                if (Utilities.useHTMLEscapes(flags)) {
                    out.append("&gt;");
                } else {
                    out.append('>');
                }
                return;
            }
            case '[': {
                if (Utilities.useRegexEscapes(flags)) {
                    if (Utilities.useDoubleEscapes(flags)) {
                        out.append("\\\\[");
                    } else {
                        out.append("\\[");
                    }
                } else {
                    out.append('[');
                }
                return;
            }
            case '\\': {
                if (Utilities.useDoubleEscapes(flags)) {
                    out.append("\\\\\\\\");
                } else {
                    out.append("\\\\");
                }
                return;
            }
            case ']': {
                if (Utilities.useRegexEscapes(flags)) {
                    if (Utilities.useDoubleEscapes(flags)) {
                        out.append("\\\\]");
                    } else {
                        out.append("\\]");
                    }
                } else {
                    out.append(']');
                }
                return;
            }
        }
        if (Utilities.useUnicodeEscapes(flags) && (' ' > c || '~' < c)) {
            String padding;
            String hex = Integer.toHexString(c);
            switch (hex.length()) {
                case 1: {
                    padding = "000";
                    break;
                }
                case 2: {
                    padding = "00";
                    break;
                }
                case 3: {
                    padding = "0";
                    break;
                }
                default: {
                    padding = "";
                }
            }
            if (Utilities.useDoubleEscapes(flags)) {
                out.append("\\\\");
            } else {
                out.append("\\");
            }
            out.append('u');
            out.append(padding);
            out.append(hex);
        } else {
            out.append(c);
        }
    }

    public static void escape(String s, Appendable out, int flags) throws IOException {
        int length = s.length();
        int i = 0;
        while (i < length) {
            Utilities.escape(s.charAt(i), out, flags);
            ++i;
        }
    }

    public static String escape(char c, int flags) {
        StringBuilder buf;
        block2: {
            buf = new StringBuilder(1);
            try {
                Utilities.escape(c, (Appendable)buf, flags);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return buf.toString();
    }

    public static String escape(String s, int flags) {
        StringBuilder buf;
        block2: {
            buf = new StringBuilder(s.length());
            try {
                Utilities.escape(s, (Appendable)buf, flags);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return buf.toString();
    }

    public static String unescape(String s) {
        if (-1 == s.indexOf(92)) {
            return s;
        }
        int length = s.length();
        StringBuilder buf = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            int c = s.charAt(i);
            if (92 != c) {
                buf.append((char)c);
            } else {
                if (++i >= length) {
                    throw new IllegalArgumentException("incomplete escape sequence");
                }
                c = s.charAt(i);
                switch (c) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        int val = c;
                        if (i + 1 < length && 48 <= (c = s.charAt(i + 1)) && c <= 55) {
                            val = val * 8 + c;
                            if (++i + 1 < length && 48 <= (c = (int)s.charAt(i + 1)) && c <= 55) {
                                val = val * 8 + c;
                                ++i;
                            }
                        }
                        buf.append((char)val);
                        break;
                    }
                    case 34: {
                        buf.append('\"');
                        break;
                    }
                    case 39: {
                        buf.append('\'');
                        break;
                    }
                    case 45: {
                        buf.append('-');
                        break;
                    }
                    case 63: {
                        buf.append('?');
                        break;
                    }
                    case 91: {
                        buf.append('[');
                        break;
                    }
                    case 92: {
                        buf.append('\\');
                        break;
                    }
                    case 93: {
                        buf.append(']');
                        break;
                    }
                    case 97: {
                        buf.append('\u0007');
                        break;
                    }
                    case 98: {
                        buf.append('\b');
                        break;
                    }
                    case 102: {
                        buf.append('\f');
                        break;
                    }
                    case 110: {
                        buf.append('\n');
                        break;
                    }
                    case 114: {
                        buf.append('\r');
                        break;
                    }
                    case 116: {
                        buf.append('\t');
                        break;
                    }
                    case 117: {
                        int n;
                        if ((i += 4) >= length) {
                            throw new IllegalArgumentException("incomplete universal character name " + s.substring(i - 3));
                        }
                        try {
                            n = Integer.parseInt(s.substring(i - 3, i + 1), 16);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalArgumentException("malformed universal character name " + s.substring(i - 3, i + 1));
                        }
                        buf.append((char)n);
                        break;
                    }
                    case 118: {
                        buf.append('\u000b');
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal escaped character '\\" + (char)c + "'");
                    }
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String format(List<?> l) {
        int length = l.size();
        StringBuilder buf = new StringBuilder();
        Iterator<?> iter = l.iterator();
        while (iter.hasNext()) {
            String el = iter.next().toString();
            if (1 < length && !iter.hasNext()) {
                buf.append("and ");
            }
            buf.append(el);
            if (2 == length && iter.hasNext()) {
                buf.append(' ');
                continue;
            }
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public static String split(String id, char separator) {
        int idx = id.indexOf(36);
        if (-1 != idx) {
            id = id.substring(0, idx);
        }
        int length = id.length();
        boolean startsUpper = false;
        int upperCount = 0;
        int i = 0;
        while (i < length) {
            if (Character.isUpperCase(id.charAt(i))) {
                if (i == 0) {
                    startsUpper = true;
                }
                ++upperCount;
            }
            ++i;
        }
        if (upperCount == 0 || length == upperCount) {
            return id;
        }
        int size = startsUpper ? length + upperCount - 1 : length + upperCount;
        StringBuilder buf = new StringBuilder(size);
        int i2 = 0;
        while (i2 < length) {
            char c = id.charAt(i2);
            if (Character.isUpperCase(c)) {
                if (i2 != 0) {
                    buf.append(separator);
                }
                buf.append(Character.toLowerCase(c));
            } else {
                buf.append(c);
            }
            ++i2;
        }
        return buf.toString();
    }

    public static String toArticle(String noun) {
        if (noun.startsWith("a") || noun.startsWith("e") || noun.startsWith("i") || noun.startsWith("o") || noun.startsWith("u")) {
            return "an";
        }
        return "a";
    }
}

