/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import xtc.tree.Node;
import xtc.util.Pair;

public abstract class GNode
extends Node {
    public static final int MAX_FIXED = 8;
    final String name;

    GNode(String name) {
        this.name = name;
    }

    public int hashCode() {
        int hash = this.name.hashCode();
        int size = this.size();
        int i = 0;
        while (i < size) {
            Object child = this.get(i);
            hash = 37 * hash + (child == null ? 0 : child.hashCode());
            ++i;
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GNode)) {
            return false;
        }
        GNode other = (GNode)o;
        if (!this.name.equals(other.name)) {
            return false;
        }
        int size = this.size();
        if (other.size() != size) {
            return false;
        }
        int i = 0;
        while (i < size) {
            Object child1 = this.get(i);
            Object child2 = other.get(i);
            if (child1 == null ? child2 != null : !child1.equals(child2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public final boolean isGeneric() {
        return true;
    }

    @Override
    public final boolean hasTraversal() {
        return true;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final boolean hasName(String name) {
        return this.name.equals(name);
    }

    public static GNode create(String name) {
        return new Variable(name);
    }

    public static GNode create(String name, int capacity) {
        return new Variable(name, capacity);
    }

    public static GNode create(String name, boolean variable) {
        if (variable) {
            return new Variable(name);
        }
        return new Fixed0(name);
    }

    public static GNode create(String name, Object child) {
        return new Fixed1(name, child);
    }

    public static GNode create(String name, Object c1, Object c2) {
        return new Fixed2(name, c1, c2);
    }

    public static GNode create(String name, Object c1, Object c2, Object c3) {
        return new Fixed3(name, c1, c2, c3);
    }

    public static GNode create(String name, Object c1, Object c2, Object c3, Object c4) {
        return new Fixed4(name, c1, c2, c3, c4);
    }

    public static GNode create(String name, Object c1, Object c2, Object c3, Object c4, Object c5) {
        return new Fixed5(name, c1, c2, c3, c4, c5);
    }

    public static GNode create(String name, Object c1, Object c2, Object c3, Object c4, Object c5, Object c6) {
        return new Fixed6(name, c1, c2, c3, c4, c5, c6);
    }

    public static GNode create(String name, Object c1, Object c2, Object c3, Object c4, Object c5, Object c6, Object c7) {
        return new Fixed7(name, c1, c2, c3, c4, c5, c6, c7);
    }

    public static GNode create(String name, Object c1, Object c2, Object c3, Object c4, Object c5, Object c6, Object c7, Object c8) {
        return new Fixed8(name, c1, c2, c3, c4, c5, c6, c7, c8);
    }

    public static GNode createFromPair(String name, Pair p) {
        int size = p.size();
        Object c1 = null;
        Object c2 = null;
        Object c3 = null;
        Object c4 = null;
        Object c5 = null;
        Object c6 = null;
        Object c7 = null;
        Object c8 = null;
        switch (size) {
            case 8: {
                c1 = p.head();
                p = p.tail();
            }
            case 7: {
                c2 = p.head();
                p = p.tail();
            }
            case 6: {
                c3 = p.head();
                p = p.tail();
            }
            case 5: {
                c4 = p.head();
                p = p.tail();
            }
            case 4: {
                c5 = p.head();
                p = p.tail();
            }
            case 3: {
                c6 = p.head();
                p = p.tail();
            }
            case 2: {
                c7 = p.head();
                p = p.tail();
            }
            case 1: {
                c8 = p.head();
            }
            case 0: {
                break;
            }
            default: {
                Variable result = new Variable(name, size);
                result.addAll(p);
                return result;
            }
        }
        switch (size) {
            case 8: {
                return new Fixed8(name, c1, c2, c3, c4, c5, c6, c7, c8);
            }
            case 7: {
                return new Fixed7(name, c2, c3, c4, c5, c6, c7, c8);
            }
            case 6: {
                return new Fixed6(name, c3, c4, c5, c6, c7, c8);
            }
            case 5: {
                return new Fixed5(name, c4, c5, c6, c7, c8);
            }
            case 4: {
                return new Fixed4(name, c5, c6, c7, c8);
            }
            case 3: {
                return new Fixed3(name, c6, c7, c8);
            }
            case 2: {
                return new Fixed2(name, c7, c8);
            }
            case 1: {
                return new Fixed1(name, c8);
            }
            case 0: {
                return new Fixed0(name);
            }
        }
        throw new AssertionError((Object)"Internal error");
    }

    public static GNode createFromPair(String name, Object base, Pair rest) {
        int size = rest.size();
        Object c2 = null;
        Object c3 = null;
        Object c4 = null;
        Object c5 = null;
        Object c6 = null;
        Object c7 = null;
        Object c8 = null;
        switch (size) {
            case 7: {
                c2 = rest.head();
                rest = rest.tail();
            }
            case 6: {
                c3 = rest.head();
                rest = rest.tail();
            }
            case 5: {
                c4 = rest.head();
                rest = rest.tail();
            }
            case 4: {
                c5 = rest.head();
                rest = rest.tail();
            }
            case 3: {
                c6 = rest.head();
                rest = rest.tail();
            }
            case 2: {
                c7 = rest.head();
                rest = rest.tail();
            }
            case 1: {
                c8 = rest.head();
                rest = rest.tail();
            }
            case 0: {
                break;
            }
            default: {
                Variable result = new Variable(name, size + 1);
                result.add(base);
                result.addAll(rest);
                return result;
            }
        }
        switch (size) {
            case 7: {
                return new Fixed8(name, base, c2, c3, c4, c5, c6, c7, c8);
            }
            case 6: {
                return new Fixed7(name, base, c3, c4, c5, c6, c7, c8);
            }
            case 5: {
                return new Fixed6(name, base, c4, c5, c6, c7, c8);
            }
            case 4: {
                return new Fixed5(name, base, c5, c6, c7, c8);
            }
            case 3: {
                return new Fixed4(name, base, c6, c7, c8);
            }
            case 2: {
                return new Fixed3(name, base, c7, c8);
            }
            case 1: {
                return new Fixed2(name, base, c8);
            }
            case 0: {
                return new Fixed1(name, base);
            }
        }
        throw new AssertionError((Object)"Internal error");
    }

    public static GNode create(GNode node) {
        if (node instanceof Variable) {
            return new Variable((Variable)node);
        }
        switch (node.size()) {
            case 0: {
                return new Fixed0((Fixed0)node);
            }
            case 1: {
                return new Fixed1((Fixed1)node);
            }
            case 2: {
                return new Fixed2((Fixed2)node);
            }
            case 3: {
                return new Fixed3((Fixed3)node);
            }
            case 4: {
                return new Fixed4((Fixed4)node);
            }
            case 5: {
                return new Fixed5((Fixed5)node);
            }
            case 6: {
                return new Fixed6((Fixed6)node);
            }
            case 7: {
                return new Fixed7((Fixed7)node);
            }
            case 8: {
                return new Fixed8((Fixed8)node);
            }
        }
        throw new AssertionError((Object)"Internal error");
    }

    public static GNode ensureVariable(GNode node) {
        if (node instanceof Variable) {
            return node;
        }
        ArrayList<Object> children = new ArrayList<Object>(node.size());
        node.addAllTo(children);
        return new Variable(node.name, children);
    }

    public static final boolean test(Object o) {
        return o instanceof Node && ((Node)o).strip().isGeneric();
    }

    public static final GNode cast(Object o) {
        Node n = (Node)o;
        return n == null ? null : (GNode)n.strip();
    }

    static abstract class Fixed
    extends GNode {
        Fixed(String name) {
            super(name);
        }

        @Override
        public Node add(Object O) {
            throw new UnsupportedOperationException("Generic node with a fixed number of children");
        }

        @Override
        public Node add(int index, Object o) {
            throw new UnsupportedOperationException("Generic node with a fixed number of children");
        }

        @Override
        public Node addAll(Pair<?> p) {
            throw new UnsupportedOperationException("Generic node with a fixed number of children");
        }

        @Override
        public Node addAll(int index, Pair<?> p) {
            throw new UnsupportedOperationException("Generic node with a fixed number of children");
        }

        @Override
        public Node addAll(Collection<?> c) {
            throw new UnsupportedOperationException("Generic node with a fixed number of children");
        }

        @Override
        public Node addAll(int index, Collection<?> c) {
            throw new UnsupportedOperationException("Generic node with a fixed number of children");
        }

        @Override
        public Object remove(int index) {
            throw new UnsupportedOperationException("Generic node with a fixed number of children");
        }
    }

    static class Fixed0
    extends Fixed {
        Fixed0(String name) {
            super(name);
        }

        Fixed0(Fixed0 node) {
            super(node.name);
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Object get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
        }

        @Override
        public Object set(int index, Object value) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
        }

        @Override
        public void addAllTo(Collection<Object> c) {
        }
    }

    static class Fixed1
    extends Fixed {
        Object c1;

        Fixed1(String name, Object c1) {
            super(name);
            this.c1 = c1;
        }

        Fixed1(Fixed1 node) {
            this(node.name, node.c1);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Object get(int index) {
            if (index == 0) {
                return this.c1;
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
        }

        @Override
        public Object set(int index, Object value) {
            if (index == 0) {
                Object old = this.c1;
                this.c1 = value;
                return old;
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
        }

        @Override
        public void addAllTo(Collection<Object> c) {
            c.add(this.c1);
        }
    }

    static class Fixed2
    extends Fixed {
        Object c1;
        Object c2;

        Fixed2(String name, Object c1, Object c2) {
            super(name);
            this.c1 = c1;
            this.c2 = c2;
        }

        Fixed2(Fixed2 node) {
            this(node.name, node.c1, node.c2);
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public Object get(int index) {
            switch (index) {
                case 0: {
                    return this.c1;
                }
                case 1: {
                    return this.c2;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 2");
        }

        @Override
        public Object set(int index, Object value) {
            switch (index) {
                case 0: {
                    Object old = this.c1;
                    this.c1 = value;
                    return old;
                }
                case 1: {
                    Object old = this.c2;
                    this.c2 = value;
                    return old;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 2");
        }

        @Override
        public void addAllTo(Collection<Object> c) {
            c.add(this.c1);
            c.add(this.c2);
        }
    }

    static class Fixed3
    extends Fixed {
        Object c1;
        Object c2;
        Object c3;

        Fixed3(String name, Object c1, Object c2, Object c3) {
            super(name);
            this.c1 = c1;
            this.c2 = c2;
            this.c3 = c3;
        }

        Fixed3(Fixed3 node) {
            this(node.name, node.c1, node.c2, node.c3);
        }

        @Override
        public int size() {
            return 3;
        }

        @Override
        public Object get(int index) {
            switch (index) {
                case 0: {
                    return this.c1;
                }
                case 1: {
                    return this.c2;
                }
                case 2: {
                    return this.c3;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 3");
        }

        @Override
        public Object set(int index, Object value) {
            switch (index) {
                case 0: {
                    Object old = this.c1;
                    this.c1 = value;
                    return old;
                }
                case 1: {
                    Object old = this.c2;
                    this.c2 = value;
                    return old;
                }
                case 2: {
                    Object old = this.c3;
                    this.c3 = value;
                    return old;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 3");
        }

        @Override
        public void addAllTo(Collection<Object> c) {
            c.add(this.c1);
            c.add(this.c2);
            c.add(this.c3);
        }
    }

    static class Fixed4
    extends Fixed {
        Object c1;
        Object c2;
        Object c3;
        Object c4;

        Fixed4(String name, Object c1, Object c2, Object c3, Object c4) {
            super(name);
            this.c1 = c1;
            this.c2 = c2;
            this.c3 = c3;
            this.c4 = c4;
        }

        Fixed4(Fixed4 node) {
            this(node.name, node.c1, node.c2, node.c3, node.c4);
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public Object get(int index) {
            switch (index) {
                case 0: {
                    return this.c1;
                }
                case 1: {
                    return this.c2;
                }
                case 2: {
                    return this.c3;
                }
                case 3: {
                    return this.c4;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 4");
        }

        @Override
        public Object set(int index, Object value) {
            switch (index) {
                case 0: {
                    Object old = this.c1;
                    this.c1 = value;
                    return old;
                }
                case 1: {
                    Object old = this.c2;
                    this.c2 = value;
                    return old;
                }
                case 2: {
                    Object old = this.c3;
                    this.c3 = value;
                    return old;
                }
                case 3: {
                    Object old = this.c4;
                    this.c4 = value;
                    return old;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 4");
        }

        @Override
        public void addAllTo(Collection<Object> c) {
            c.add(this.c1);
            c.add(this.c2);
            c.add(this.c3);
            c.add(this.c4);
        }
    }

    static class Fixed5
    extends Fixed {
        Object c1;
        Object c2;
        Object c3;
        Object c4;
        Object c5;

        Fixed5(String name, Object c1, Object c2, Object c3, Object c4, Object c5) {
            super(name);
            this.c1 = c1;
            this.c2 = c2;
            this.c3 = c3;
            this.c4 = c4;
            this.c5 = c5;
        }

        Fixed5(Fixed5 node) {
            this(node.name, node.c1, node.c2, node.c3, node.c4, node.c5);
        }

        @Override
        public int size() {
            return 5;
        }

        @Override
        public Object get(int index) {
            switch (index) {
                case 0: {
                    return this.c1;
                }
                case 1: {
                    return this.c2;
                }
                case 2: {
                    return this.c3;
                }
                case 3: {
                    return this.c4;
                }
                case 4: {
                    return this.c5;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 5");
        }

        @Override
        public Object set(int index, Object value) {
            switch (index) {
                case 0: {
                    Object old = this.c1;
                    this.c1 = value;
                    return old;
                }
                case 1: {
                    Object old = this.c2;
                    this.c2 = value;
                    return old;
                }
                case 2: {
                    Object old = this.c3;
                    this.c3 = value;
                    return old;
                }
                case 3: {
                    Object old = this.c4;
                    this.c4 = value;
                    return old;
                }
                case 4: {
                    Object old = this.c5;
                    this.c5 = value;
                    return old;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 5");
        }

        @Override
        public void addAllTo(Collection<Object> c) {
            c.add(this.c1);
            c.add(this.c2);
            c.add(this.c3);
            c.add(this.c4);
            c.add(this.c5);
        }
    }

    static class Fixed6
    extends Fixed {
        Object c1;
        Object c2;
        Object c3;
        Object c4;
        Object c5;
        Object c6;

        Fixed6(String name, Object c1, Object c2, Object c3, Object c4, Object c5, Object c6) {
            super(name);
            this.c1 = c1;
            this.c2 = c2;
            this.c3 = c3;
            this.c4 = c4;
            this.c5 = c5;
            this.c6 = c6;
        }

        Fixed6(Fixed6 node) {
            this(node.name, node.c1, node.c2, node.c3, node.c4, node.c5, node.c6);
        }

        @Override
        public int size() {
            return 6;
        }

        @Override
        public Object get(int index) {
            switch (index) {
                case 0: {
                    return this.c1;
                }
                case 1: {
                    return this.c2;
                }
                case 2: {
                    return this.c3;
                }
                case 3: {
                    return this.c4;
                }
                case 4: {
                    return this.c5;
                }
                case 5: {
                    return this.c6;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 6");
        }

        @Override
        public Object set(int index, Object value) {
            switch (index) {
                case 0: {
                    Object old = this.c1;
                    this.c1 = value;
                    return old;
                }
                case 1: {
                    Object old = this.c2;
                    this.c2 = value;
                    return old;
                }
                case 2: {
                    Object old = this.c3;
                    this.c3 = value;
                    return old;
                }
                case 3: {
                    Object old = this.c4;
                    this.c4 = value;
                    return old;
                }
                case 4: {
                    Object old = this.c5;
                    this.c5 = value;
                    return old;
                }
                case 5: {
                    Object old = this.c6;
                    this.c6 = value;
                    return old;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 6");
        }

        @Override
        public void addAllTo(Collection<Object> c) {
            c.add(this.c1);
            c.add(this.c2);
            c.add(this.c3);
            c.add(this.c4);
            c.add(this.c5);
            c.add(this.c6);
        }
    }

    static class Fixed7
    extends Fixed {
        Object c1;
        Object c2;
        Object c3;
        Object c4;
        Object c5;
        Object c6;
        Object c7;

        Fixed7(String name, Object c1, Object c2, Object c3, Object c4, Object c5, Object c6, Object c7) {
            super(name);
            this.c1 = c1;
            this.c2 = c2;
            this.c3 = c3;
            this.c4 = c4;
            this.c5 = c5;
            this.c6 = c6;
            this.c7 = c7;
        }

        Fixed7(Fixed7 node) {
            this(node.name, node.c1, node.c2, node.c3, node.c4, node.c5, node.c6, node.c7);
        }

        @Override
        public int size() {
            return 7;
        }

        @Override
        public Object get(int index) {
            switch (index) {
                case 0: {
                    return this.c1;
                }
                case 1: {
                    return this.c2;
                }
                case 2: {
                    return this.c3;
                }
                case 3: {
                    return this.c4;
                }
                case 4: {
                    return this.c5;
                }
                case 5: {
                    return this.c6;
                }
                case 6: {
                    return this.c7;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 7");
        }

        @Override
        public Object set(int index, Object value) {
            switch (index) {
                case 0: {
                    Object old = this.c1;
                    this.c1 = value;
                    return old;
                }
                case 1: {
                    Object old = this.c2;
                    this.c2 = value;
                    return old;
                }
                case 2: {
                    Object old = this.c3;
                    this.c3 = value;
                    return old;
                }
                case 3: {
                    Object old = this.c4;
                    this.c4 = value;
                    return old;
                }
                case 4: {
                    Object old = this.c5;
                    this.c5 = value;
                    return old;
                }
                case 5: {
                    Object old = this.c6;
                    this.c6 = value;
                    return old;
                }
                case 6: {
                    Object old = this.c7;
                    this.c7 = value;
                    return old;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 7");
        }

        @Override
        public void addAllTo(Collection<Object> c) {
            c.add(this.c1);
            c.add(this.c2);
            c.add(this.c3);
            c.add(this.c4);
            c.add(this.c5);
            c.add(this.c6);
            c.add(this.c7);
        }
    }

    static class Fixed8
    extends Fixed {
        Object c1;
        Object c2;
        Object c3;
        Object c4;
        Object c5;
        Object c6;
        Object c7;
        Object c8;

        Fixed8(String name, Object c1, Object c2, Object c3, Object c4, Object c5, Object c6, Object c7, Object c8) {
            super(name);
            this.c1 = c1;
            this.c2 = c2;
            this.c3 = c3;
            this.c4 = c4;
            this.c5 = c5;
            this.c6 = c6;
            this.c7 = c7;
            this.c8 = c8;
        }

        Fixed8(Fixed8 node) {
            this(node.name, node.c1, node.c2, node.c3, node.c4, node.c5, node.c6, node.c7, node.c8);
        }

        @Override
        public int size() {
            return 8;
        }

        @Override
        public Object get(int index) {
            switch (index) {
                case 0: {
                    return this.c1;
                }
                case 1: {
                    return this.c2;
                }
                case 2: {
                    return this.c3;
                }
                case 3: {
                    return this.c4;
                }
                case 4: {
                    return this.c5;
                }
                case 5: {
                    return this.c6;
                }
                case 6: {
                    return this.c7;
                }
                case 7: {
                    return this.c8;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 8");
        }

        @Override
        public Object set(int index, Object value) {
            switch (index) {
                case 0: {
                    Object old = this.c1;
                    this.c1 = value;
                    return old;
                }
                case 1: {
                    Object old = this.c2;
                    this.c2 = value;
                    return old;
                }
                case 2: {
                    Object old = this.c3;
                    this.c3 = value;
                    return old;
                }
                case 3: {
                    Object old = this.c4;
                    this.c4 = value;
                    return old;
                }
                case 4: {
                    Object old = this.c5;
                    this.c5 = value;
                    return old;
                }
                case 5: {
                    Object old = this.c6;
                    this.c6 = value;
                    return old;
                }
                case 6: {
                    Object old = this.c7;
                    this.c7 = value;
                    return old;
                }
                case 7: {
                    Object old = this.c8;
                    this.c8 = value;
                    return old;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 8");
        }

        @Override
        public void addAllTo(Collection<Object> c) {
            c.add(this.c1);
            c.add(this.c2);
            c.add(this.c3);
            c.add(this.c4);
            c.add(this.c5);
            c.add(this.c6);
            c.add(this.c7);
            c.add(this.c8);
        }
    }

    static class Variable
    extends GNode {
        private ArrayList<Object> children;

        Variable(String name) {
            super(name);
            this.children = new ArrayList();
        }

        Variable(String name, int capacity) {
            super(name);
            this.children = new ArrayList(capacity);
        }

        Variable(String name, ArrayList<Object> children) {
            super(name);
            this.children = children;
        }

        Variable(Variable node) {
            super(node.name);
            this.children = new ArrayList<Object>(node.children);
        }

        @Override
        public boolean hasVariable() {
            return true;
        }

        @Override
        public Node add(Object o) {
            this.children.add(o);
            return this;
        }

        @Override
        public Node add(int index, Object o) {
            this.children.add(index, o);
            return this;
        }

        @Override
        public Node addAll(Pair<?> p) {
            p.addTo(this.children);
            return this;
        }

        @Override
        public Node addAll(int index, Pair<?> p) {
            p.addTo(this.children.subList(0, index));
            return this;
        }

        @Override
        public Node addAll(Collection<?> c) {
            this.children.addAll(c);
            return this;
        }

        @Override
        public Node addAll(int index, Collection<?> c) {
            this.children.addAll(index, c);
            return this;
        }

        @Override
        public void addAllTo(Collection<Object> c) {
            c.addAll(this.children);
        }

        @Override
        public Iterator<Object> iterator() {
            return this.children.iterator();
        }

        @Override
        public int size() {
            return this.children.size();
        }

        @Override
        public Object get(int index) {
            return this.children.get(index);
        }

        @Override
        public Object set(int index, Object value) {
            return this.children.set(index, value);
        }

        @Override
        public Object remove(int index) {
            return this.children.remove(index);
        }
    }
}

