/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.typicals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.simantics.NameLabelMode;
import org.simantics.NameLabelUtil;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.FreshName;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.request.Configuration;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.SimanticsClipboardBuilder;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteResult;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ModelingUtils;
import org.simantics.modeling.services.ComponentNamingUtil;
import org.simantics.modeling.services.NamingException;
import org.simantics.modeling.typicals.SyncTypicalTemplatesToInstances;
import org.simantics.modeling.typicals.TypicalCompositeCopyHandler;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.function.Function2;
import org.simantics.scl.runtime.function.Function4;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.utils.StructuralUtils;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.dialogs.ShowMessage;

public class TypicalUtil {
    private static final boolean DEBUG = false;

    public static Collection<NamedResource> toNamedResources(RequestProcessor processor, Collection<Resource> rs) throws DatabaseException {
        return TypicalUtil.toNamedResources(processor, rs, (Function2<ReadGraph, Resource, String>)new TypicalNamingFunction());
    }

    public static Collection<NamedResource> toNamedResources(RequestProcessor processor, final Collection<Resource> rs, final Function2<ReadGraph, Resource, String> namingFunction) throws DatabaseException {
        return (Collection)processor.syncRequest((Read)new UniqueRead<Collection<NamedResource>>(){

            public Collection<NamedResource> perform(ReadGraph graph) throws DatabaseException {
                return TypicalUtil.toNamedResources(graph, (Collection<Resource>)rs, (Function2<ReadGraph, Resource, String>)namingFunction);
            }
        });
    }

    public static Collection<NamedResource> toNamedResources(ReadGraph graph, Collection<Resource> rs, Function2<ReadGraph, Resource, String> namingFunction) throws DatabaseException {
        ArrayList<NamedResource> result = new ArrayList<NamedResource>(rs.size());
        for (Resource r : rs) {
            result.add(new NamedResource((String)namingFunction.apply((Object)graph, (Object)r), r));
        }
        return result;
    }

    public static String getName(ReadGraph graph, Resource r) throws DatabaseException {
        String s = (String)graph.getPossibleAdapter(r, String.class);
        if (s == null) {
            s = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)r);
        }
        return s;
    }

    public static WriteResult<Resource> instantiateTemplate(final Resource target, final NamedResource template, final Callback<Pair<WriteGraph, Resource>> successContinuation) {
        return new WriteResultRequest<Resource>(){

            public Resource perform(WriteGraph graph) throws DatabaseException {
                CommonDBUtils.selectClusterSet((WriteGraph)graph, (Resource)target);
                SimanticsClipboardImpl clipboard = new SimanticsClipboardImpl();
                TypicalCompositeCopyHandler ch = new TypicalCompositeCopyHandler(template.getResource());
                ch.copyToClipboard((ReadGraph)graph, (SimanticsClipboardBuilder)clipboard);
                for (Set object : clipboard.getContents()) {
                    TransferableGraph1 tg = (TransferableGraph1)ClipboardUtils.accept((ReadGraph)graph, (Set)object, (IHintContext.Key)SimanticsKeys.KEY_TRANSFERABLE_GRAPH);
                    if (tg == null) continue;
                    DiagramPasteImportAdvisor advisor = new DiagramPasteImportAdvisor((ReadGraph)graph, target, template.getName());
                    TransferableGraphs.importGraph1((WriteGraph)graph, (TransferableGraph1)tg, (IImportAdvisor)advisor);
                    Resource copy = advisor.getRoot();
                    TypicalUtil.configureCopyType(graph, copy, template.getResource());
                    TypicalUtil.associateCopyToTemplate(graph, copy, template.getResource());
                    if (successContinuation != null) {
                        successContinuation.run((Object)Pair.make((Object)graph, (Object)copy));
                    }
                    return copy;
                }
                throw new DatabaseException("Failed to instantiate typical template through clipboard");
            }
        };
    }

    public static void configureCopyType(WriteGraph graph, Resource copy, Resource template) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        for (Resource type : graph.getObjects(template, L0.InstanceOf)) {
            if (graph.isInheritedFrom(type, MOD.MasterTypicalCompositeType)) {
                graph.deny(copy, L0.InstanceOf, type);
                continue;
            }
            graph.claim(copy, L0.InstanceOf, null, type);
        }
        for (Resource templateDiagram : graph.getObjects(template, MOD.CompositeToDiagram)) {
            Resource templateDiagramType = graph.getPossibleType(templateDiagram, DIA.Diagram);
            if (templateDiagramType == null) continue;
            for (Resource copiedDiagram : graph.getObjects(copy, MOD.CompositeToDiagram)) {
                graph.claim(copiedDiagram, L0.InstanceOf, null, templateDiagramType);
            }
        }
    }

    public static void associateCopyToTemplate(WriteGraph graph, Resource copy, Resource template) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource templateDiagram = graph.getSingleObject(template, MOD.CompositeToDiagram);
        Resource copyDiagram = graph.getSingleObject(copy, MOD.CompositeToDiagram);
        Map templateDiagramElements = (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(templateDiagram));
        Map copyDiagramElements = (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(copyDiagram));
        graph.claim(copyDiagram, MOD.HasDiagramSource, MOD.DiagramHasInstance, templateDiagram);
        for (String element : templateDiagramElements.keySet()) {
            Resource templateElement = (Resource)templateDiagramElements.get(element);
            if (!graph.isInstanceOf(templateElement, DIA.Element)) continue;
            Resource copyElement = (Resource)copyDiagramElements.get(element);
            graph.claim(copyElement, MOD.HasElementSource, MOD.ElementHasInstance, templateElement);
            graph.claim(copyElement, MOD.IsTemplatized, MOD.IsTemplatized, copyElement);
        }
        Long modCount = (Long)graph.getPossibleRelatedValue(copyDiagram, DIA.HasModCount);
        if (modCount == null) {
            modCount = 0L;
        }
        modCount = modCount + 0x100000000L;
        graph.claimLiteral(copyDiagram, DiagramResource.getInstance((ReadGraph)graph).HasModCount, (Object)modCount, (Binding)Bindings.LONG);
    }

    public static void generateFreshModuleNames(WriteGraph graph, Resource typicalCompositeInstance, Set<Resource> excludedComponents) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource configurationRoot = (Resource)graph.sync((ReadInterface)new Configuration(typicalCompositeInstance));
        for (Map.Entry entry : ((Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(typicalCompositeInstance))).entrySet()) {
            Resource component = (Resource)entry.getValue();
            if (!graph.isInstanceOf(component, STR.Component) || excludedComponents != null && excludedComponents.contains(component)) continue;
            try {
                String renamed = ComponentNamingUtil.findFreshInstanceName((ReadGraph)graph, SimanticsUI.getProject(), configurationRoot, typicalCompositeInstance, component);
                graph.claimLiteral((Resource)entry.getValue(), L0.HasName, L0.NameOf, (Object)renamed, (Binding)Bindings.STRING);
            }
            catch (NamingException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
    }

    public static void applyTypicalModuleNames(WriteGraph graph, Resource typicalInstanceComposite, Set<Resource> renamedComponentsOutput) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Function4<ReadGraph, Resource, Resource, String, String> nameEvaluator = TypicalUtil.getTypicalNamingFunction((ReadGraph)graph, typicalInstanceComposite);
        if (nameEvaluator == null) {
            return;
        }
        Collection components = (Collection)graph.syncRequest((Read)new ObjectsWithType(typicalInstanceComposite, L0.ConsistsOf, STR.Component));
        for (Resource component : components) {
            TypicalUtil.applyTypicalModuleName(graph, component, nameEvaluator, renamedComponentsOutput);
        }
    }

    public static boolean applyTypicalModuleName(WriteGraph graph, Resource instanceComponent, Function4<ReadGraph, Resource, Resource, String, String> nameEvaluator, Set<Resource> renamedComponentsOutput) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource componentType = graph.getPossibleType(instanceComponent, STR.Component);
        if (componentType == null) {
            return false;
        }
        Resource instanceElement = graph.getPossibleObject(instanceComponent, MOD.ComponentToElement);
        if (instanceElement == null) {
            return false;
        }
        Resource templateElement = graph.getPossibleObject(instanceElement, MOD.HasElementSource);
        if (templateElement == null) {
            return false;
        }
        Resource templateComponent = graph.getPossibleObject(templateElement, MOD.ElementToComponent);
        if (templateComponent == null) {
            return false;
        }
        String nameExpression = (String)graph.getPossibleRelatedValue(templateComponent, L0.HasName, (Binding)Bindings.STRING);
        if (nameExpression == null) {
            return false;
        }
        Resource instanceComposite = graph.getPossibleObject(instanceComponent, L0.PartOf);
        if (instanceComposite == null) {
            return false;
        }
        String evaluatedInstanceName = (String)nameEvaluator.apply((Object)graph, (Object)instanceComposite, (Object)instanceComponent, (Object)nameExpression);
        if (evaluatedInstanceName == null) {
            return false;
        }
        String instanceName = (String)graph.getPossibleRelatedValue(instanceComponent, L0.HasName, (Binding)Bindings.STRING);
        if (instanceName == null) {
            return false;
        }
        if (!evaluatedInstanceName.equals(instanceName)) {
            graph.claimLiteral(instanceComponent, L0.HasName, (Object)evaluatedInstanceName, (Binding)Bindings.STRING);
            if (renamedComponentsOutput != null) {
                renamedComponentsOutput.add(instanceComponent);
            }
            return true;
        }
        return false;
    }

    public static void applySelectedModuleNames(WriteGraph graph, Resource typicalComposite, List<Resource> componentsToCheck) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Function4<ReadGraph, Resource, Resource, String, String> nameEvaluator = TypicalUtil.getTypicalNamingFunction((ReadGraph)graph, typicalComposite);
        if (nameEvaluator == null) {
            return;
        }
        for (Resource component : componentsToCheck) {
            String evaluatedInstanceName;
            String nameExpression;
            Resource templateComponent;
            Resource templateElement;
            Resource element;
            Resource componentType = graph.getPossibleType(component, STR.Component);
            if (componentType == null || (element = graph.getPossibleObject(component, MOD.ComponentToElement)) == null || (templateElement = graph.getPossibleObject(element, MOD.HasElementSource)) == null || (templateComponent = graph.getPossibleObject(templateElement, MOD.ElementToComponent)) == null || (nameExpression = (String)graph.getPossibleRelatedValue(templateComponent, L0.HasName, (Binding)Bindings.STRING)) == null || (evaluatedInstanceName = (String)nameEvaluator.apply((Object)graph, (Object)typicalComposite, (Object)component, (Object)nameExpression)) == null || evaluatedInstanceName.equals(nameExpression)) continue;
            graph.claimLiteral(component, L0.HasName, (Object)evaluatedInstanceName, (Binding)Bindings.STRING);
        }
    }

    public static Function4<ReadGraph, Resource, Resource, String, String> getTypicalNamingFunction(ReadGraph graph, Resource typicalComposite) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Function4 nameEvaluator = (Function4)graph.getPossibleRelatedValue2(typicalComposite, MOD.TypicalComposite_typicalNamingFunction);
        return nameEvaluator;
    }

    public static Collection<Resource> findModelTypicals(RequestProcessor processor, final Resource model) throws DatabaseException {
        return (Collection)processor.syncRequest((Read)new UniqueRead<Collection<Resource>>(){

            public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                Resource typicalMasterType = graph.getSingleObject(model, MOD.StructuralModel_HasMasterTypicalCompositeType);
                Instances query = (Instances)graph.adapt(typicalMasterType, Instances.class);
                return query.find(graph, model);
            }
        });
    }

    public static <T> T syncExec(Callback<Procedure<T>> runnable) throws DatabaseException {
        final AtomicReference ref = new AtomicReference();
        final AtomicReference exc = new AtomicReference();
        final Semaphore sem = new Semaphore(0);
        runnable.run((Object)new Procedure<T>(){

            public void execute(T result) {
                if (ref.compareAndSet(null, result)) {
                    sem.release();
                }
            }

            public void exception(Throwable t) {
                if (exc.compareAndSet(null, t)) {
                    sem.release();
                }
            }
        });
        try {
            sem.acquire();
            Throwable t = (Throwable)exc.get();
            if (t != null) {
                if (t instanceof DatabaseException) {
                    throw (DatabaseException)t;
                }
                throw new DatabaseException(t);
            }
            return (T)ref.get();
        }
        catch (InterruptedException ex) {
            throw new DatabaseException((Throwable)ex);
        }
    }

    public static void syncTypicalInstance(WriteGraph graph, Resource instance) throws DatabaseException {
        SyncTypicalTemplatesToInstances sync = SyncTypicalTemplatesToInstances.syncSingleInstance(null, instance);
        sync.perform(graph);
    }

    public static Resource newMasterTypical(final Resource target) throws DatabaseException {
        return (Resource)Simantics.getSession().syncRequest((WriteResult)new WriteResultRequest<Resource>(){

            public Resource perform(WriteGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                Resource indexRoot = (Resource)graph.sync((ReadInterface)new PossibleIndexRoot(target));
                if (indexRoot == null) {
                    ShowMessage.showInformation((String)"No Model or Shared Library", (String)"Cannot find a containing model or shared library from the input selection. Typical master diagram creation not possible.");
                    return null;
                }
                Resource compositeBaseType = graph.getPossibleObject(indexRoot, MOD.StructuralModel_HasTypicalCompositeBaseType);
                Resource diagramBaseType = graph.getPossibleObject(indexRoot, MOD.StructuralModel_HasTypicalDiagramBaseType);
                Resource masterCompositeType = graph.getPossibleObject(indexRoot, MOD.StructuralModel_HasMasterTypicalCompositeType);
                Collection cloneSymbolContributionsFrom = graph.getObjects(indexRoot, MOD.StructuralModel_CloneTypicalDiagramSymbolContributionsFrom);
                if (compositeBaseType == null || diagramBaseType == null || masterCompositeType == null) {
                    ShowMessage.showInformation((String)"No Typical Support", (String)"Creation of typical diagrams is not supported for this container.");
                    return null;
                }
                Resource compositeType = graph.newResource();
                graph.claim(compositeType, L0.Inherits, compositeBaseType);
                String compositeTypeName = NameUtils.findFreshName((ReadGraph)graph, (String)"TypicalCompositeType", (Resource)target);
                graph.claimLiteral(compositeType, L0.HasName, (Object)compositeTypeName);
                Resource diagramType = graph.newResource();
                graph.claim(diagramType, L0.Inherits, diagramBaseType);
                graph.claimLiteral(diagramType, L0.HasName, (Object)"Type");
                String name = NameUtils.findFreshName((ReadGraph)graph, (String)"Typical", (Resource)target, (Resource)L0.ConsistsOf, (String)"%s%d");
                Resource composite = StructuralUtils.newComponent((WriteGraph)graph, (Resource)target, (String)(String.valueOf(name) + "@1"), (Resource)compositeType);
                graph.claim(composite, L0.InstanceOf, null, masterCompositeType);
                Resource diagram = graph.newResource();
                graph.claim(diagram, L0.InstanceOf, null, diagramType);
                graph.claimLiteral(diagram, L0.HasName, (Object)"__DIAGRAM__", (Binding)Bindings.STRING);
                graph.claim(diagram, L0.SubrelationOf, null, L0.HasNext);
                graph.claim(diagram, MOD.DiagramToComposite, composite);
                Resource diagramInv = graph.newResource();
                graph.claim(diagramInv, L0.InverseOf, diagram);
                graph.claim(diagramInv, L0.SubrelationOf, null, L0.HasPrevious);
                graph.claimLiteral(diagramInv, L0.HasName, (Object)"Inverse", (Binding)Bindings.STRING);
                graph.claim(diagram, L0.ConsistsOf, diagramInv);
                graph.claim(diagram, diagram, diagramInv, diagram);
                Resource mapping = graph.newResource();
                graph.claim(diagram, L0X.HasTrigger, mapping);
                graph.claim(mapping, L0.InstanceOf, null, MOD.DiagramToCompositeMapping);
                Resource container = graph.newResource();
                graph.claim(container, L0.InstanceOf, null, DIA.DiagramContainer);
                graph.addLiteral(container, L0.HasName, L0.NameOf, L0.String, (Object)"__CONTAINER__", (Binding)Bindings.STRING);
                graph.claim(diagram, L0.ConsistsOf, diagramType);
                graph.claim(container, L0.ConsistsOf, diagram);
                graph.claim(composite, L0.ConsistsOf, container);
                graph.claim(composite, L0.ConsistsOf, compositeType);
                for (Resource symbolContributionSource : cloneSymbolContributionsFrom) {
                    for (Resource contribution : graph.getObjects(symbolContributionSource, DIA.HasSymbolContribution)) {
                        graph.claim(diagramType, DIA.HasSymbolContribution, contribution);
                    }
                }
                Resource indexContribution = graph.newResource();
                graph.claim(indexContribution, L0.InstanceOf, DIA.IndexRootSymbolContribution);
                graph.claim(diagramType, DIA.HasSymbolContribution, indexContribution);
                CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                graph.addMetadata((Metadata)cm.add("Created typical master diagram " + composite));
                return composite;
            }
        });
    }

    public static class DiagramPasteImportAdvisor
    implements IImportAdvisor {
        protected final Resource library;
        protected final Resource model;
        protected Resource diagram;
        protected final String diagramName;

        public DiagramPasteImportAdvisor(ReadGraph graph, Resource library, String originalName) throws DatabaseException {
            this.library = library;
            this.diagram = null;
            this.diagramName = (String)graph.syncRequest((Read)new FreshName(library, originalName));
            this.model = (Resource)graph.syncRequest((Read)new PossibleModel(library));
        }

        public void analyzeType(ReadGraph graph, Root root) throws DatabaseException {
        }

        public Resource analyzeRoot(ReadGraph graph, Root root) throws DatabaseException {
            if ("%model".equals(root.name)) {
                return this.model;
            }
            return null;
        }

        public Resource createRoot(WriteOnlyGraph graph, Root root) throws DatabaseException {
            Layer0 l0 = (Layer0)graph.getService(Layer0.class);
            if (ModelingUtils.CompositeInfo.isComposite(root.name)) {
                if (this.diagram == null) {
                    this.diagram = graph.newResource();
                }
                graph.claim(this.library, l0.ConsistsOf, l0.PartOf, this.diagram);
                graph.newClusterSet(this.diagram);
                graph.setClusterSet4NewResource(this.diagram);
                graph.addLiteral(this.diagram, l0.HasName, l0.NameOf, l0.String, (Object)this.diagramName, (Binding)Bindings.STRING);
                return this.diagram;
            }
            if (ModelingUtils.DiagramComponentInfo.isDiagramComponent(root.name)) {
                ModelingUtils.DiagramComponentInfo info = ModelingUtils.DiagramComponentInfo.parse(root.name);
                Resource child = graph.newResource();
                graph.addLiteral(child, l0.HasName, l0.NameOf, l0.String, (Object)info.getUnescapedComponentName(), (Binding)Bindings.STRING);
                return child;
            }
            throw new DatabaseException("Unclassified root " + root.name);
        }

        public Resource getRoot() {
            return this.diagram;
        }
    }

    private static class TypicalNamingFunction
    implements Function2<ReadGraph, Resource, String> {
        private NameLabelMode mode;

        private TypicalNamingFunction() {
        }

        public String apply(ReadGraph graph, Resource r) {
            try {
                Resource root;
                Variable v;
                if (this.mode == null) {
                    this.mode = NameLabelUtil.getNameLabelMode((RequestProcessor)graph);
                }
                if ((v = Variables.getPossibleVariable((ReadGraph)graph, (Resource)r)) != null && (root = Variables.getPossibleIndexRoot((ReadGraph)graph, (Variable)v)) != null) {
                    Variable rootV = Variables.getVariable((ReadGraph)graph, (Resource)root);
                    List path = Variables.getPath((ReadGraph)graph, (Variable)rootV, (Variable)v);
                    path.add(0, rootV);
                    return this.typicalLabel(graph, v, path);
                }
                return TypicalUtil.getName(graph, r);
            }
            catch (DatabaseException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
        }

        protected String typicalLabel(ReadGraph graph, Variable v, List<Variable> path) throws DatabaseException {
            StringBuilder sb = new StringBuilder();
            this.labelVariable(graph, v, sb);
            if (path.size() > 0) {
                sb.append(" (");
                for (Variable vv : path) {
                    sb.append("/");
                    this.labelVariable(graph, vv, sb);
                }
                sb.append(")");
            }
            return sb.toString();
        }

        protected StringBuilder labelVariable(ReadGraph graph, Variable v, StringBuilder result) throws DatabaseException {
            Resource r = v.getPossibleRepresents(graph);
            if (r != null) {
                result.append(NameLabelUtil.modalName((ReadGraph)graph, (Resource)r, (NameLabelMode)this.mode));
            } else {
                result.append(NameLabelUtil.modalName((ReadGraph)graph, (Variable)v, (NameLabelMode)this.mode));
            }
            return result;
        }
    }
}

