/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.typicals;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.ReadInterface;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ModelingUtils;
import org.simantics.modeling.adapters.CompositeCopyHandler;
import org.simantics.structural.stubs.StructuralResource2;

public class TypicalCompositeCopyHandler
extends CompositeCopyHandler {
    public TypicalCompositeCopyHandler(Resource composite) {
        super(composite);
    }

    @Override
    protected TransferableGraphConfiguration2 createConfiguration(ReadGraph graph, boolean cut) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 SR = StructuralResource2.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource resource = this.getResource();
        ArrayList<Resource> exclusions = new ArrayList<Resource>();
        for (Resource join : graph.getObjects(resource, SR.HasConnectionJoin)) {
            if (graph.getPossibleObject(join, SR.JoinsComposite) != null) continue;
            exclusions.add(join);
        }
        for (Resource type : graph.getObjects(resource, L0.InstanceOf)) {
            if (!graph.isInheritedFrom(type, MOD.TypicalComposite)) continue;
            exclusions.add(type);
        }
        Resource diagram = graph.getPossibleObject(resource, MOD.CompositeToDiagram);
        if (diagram != null) {
            for (Resource type : graph.getObjects(diagram, L0.InstanceOf)) {
                if (!graph.isInheritedFrom(type, DIA.Diagram)) continue;
                exclusions.add(type);
            }
        }
        ArrayList<NamedResource> roots = new ArrayList<NamedResource>();
        ModelingUtils.CompositeInfo info = ModelingUtils.CompositeInfo.fromResource(graph, resource);
        roots.add(new NamedResource(info.getTGName(), resource));
        for (Resource child : (Collection)graph.sync((ReadInterface)new ObjectsWithType(resource, L0.ConsistsOf, SR.Component))) {
            ModelingUtils.DiagramComponentInfo cinfo = ModelingUtils.DiagramComponentInfo.fromResource(graph, info, child);
            roots.add(new NamedResource(cinfo.getTGName(info), child));
        }
        return TransferableGraphConfiguration2.createWithNames((RequestProcessor)graph, roots, exclusions, (boolean)true, (boolean)false);
    }
}

