/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.typicals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.typicals.ITypicalSynchronizationRule;

public class AvailableSynchronizationRules
extends ResourceRead<Collection<NamedResource>> {
    public AvailableSynchronizationRules(Resource resource) {
        super(resource);
    }

    public Collection<NamedResource> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        HashSet<Resource> rules = new HashSet<Resource>();
        for (Resource element : (Collection)graph.syncRequest((Read)new ObjectsWithType(this.resource, L0.ConsistsOf, DIA.Element))) {
            for (Resource rule : graph.getObjects(element, MOD.HasTypicalSynchronizationRule)) {
                ITypicalSynchronizationRule r = (ITypicalSynchronizationRule)graph.getPossibleAdapter(rule, ITypicalSynchronizationRule.class);
                if (r == null) continue;
                rules.add(rule);
            }
        }
        ArrayList<NamedResource> result = new ArrayList<NamedResource>();
        for (Resource rule : rules) {
            String name = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)rule);
            result.add(new NamedResource(name, rule));
        }
        return result;
    }
}

