/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.template2d;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.databoard.container.DataFormatException;
import org.simantics.databoard.container.FormatHandler;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.DefaultPasteImportAdvisor;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.TGStatusMonitor;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.TransferableGraph1;

public class DiagramTemplates {
    public static Resource importTemplate(IProgressMonitor monitor, final Session session, File templateFile, Resource targetContainer) throws IOException, DatabaseException {
        final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Importing diagram template", (int)100);
        final DefaultPasteImportAdvisor advisor = new DefaultPasteImportAdvisor(targetContainer);
        DiagramTemplateFormatHandler handler = new DiagramTemplateFormatHandler(){

            public Resource process(DataContainer container) throws Exception {
                TransferableGraphs.importGraph1WithMonitor((Session)session, (TransferableGraph1)((TransferableGraph1)container.content.getValue()), (IImportAdvisor)advisor, (TGStatusMonitor)new TGMonitor(mon));
                return advisor.getRoot();
            }
        };
        return DiagramTemplates.importTemplate(templateFile, targetContainer, handler);
    }

    public static Resource importTemplate(IProgressMonitor monitor, final WriteGraph graph, File templateFile, Resource targetContainer) throws IOException, DatabaseException {
        final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Importing diagram template", (int)100);
        final DefaultPasteImportAdvisor advisor = new DefaultPasteImportAdvisor(targetContainer);
        DiagramTemplateFormatHandler handler = new DiagramTemplateFormatHandler(){

            public Resource process(DataContainer container) throws Exception {
                TransferableGraphs.importGraph1((WriteGraph)graph, (TransferableGraph1)((TransferableGraph1)container.content.getValue()), (IImportAdvisor)advisor, (TGStatusMonitor)new TGMonitor(mon));
                return advisor.getRoot();
            }
        };
        return DiagramTemplates.importTemplate(templateFile, targetContainer, handler);
    }

    private static Resource importTemplate(File modelFile, Resource target, FormatHandler<Resource> handler) throws IOException, DatabaseException {
        try {
            HashMap<String, FormatHandler<Resource>> handlers = new HashMap<String, FormatHandler<Resource>>(2);
            handlers.put("drawingTemplate:1", handler);
            handlers.put("drawingTemplate:2", handler);
            return (Resource)DataContainers.readFile((File)modelFile, handlers);
        }
        catch (DataFormatException e) {
            throw new IOException(e);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IOException(e);
        }
    }

    private static abstract class DiagramTemplateFormatHandler
    implements FormatHandler<Resource> {
        private DiagramTemplateFormatHandler() {
        }

        public Binding getBinding() {
            return TransferableGraph1.BINDING;
        }
    }

    private static class TGMonitor
    implements TGStatusMonitor {
        private final SubMonitor mon;
        private int last = 0;

        public TGMonitor(SubMonitor mon) {
            this.mon = mon;
        }

        public void status(int percentage) {
            if (percentage > this.last) {
                this.mon.worked(percentage - this.last);
                this.last = percentage;
            }
        }
    }
}

