/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.subscription;

import java.util.UUID;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleActiveExperiment;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.subscription.SubscriptionItem;
import org.simantics.modeling.subscription.SubscriptionItemLabel;

public class SubscriptionItemQuery
extends ResourceRead<SubscriptionItem> {
    public SubscriptionItemQuery(Resource resource) {
        super(resource);
    }

    public SubscriptionItem perform(ReadGraph graph) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SubscriptionItem item = new SubscriptionItem();
        item.variableId = "";
        item.groupItemId = "";
        Resource subscriptionItem = this.resource;
        Resource subscription = null;
        if (subscriptionItem != null) {
            item.simpleLabel = (String)graph.getPossibleRelatedValue(subscriptionItem, L0.HasLabel, (Binding)Bindings.STRING);
            subscription = (Resource)graph.syncRequest((AsyncRead)new PossibleTypedParent(subscriptionItem, MOD.Subscription));
        }
        if (item.simpleLabel == null) {
            item.simpleLabel = "";
        }
        if (subscriptionItem != null) {
            Variable configuration;
            Binding rviBinding;
            RVI rvi;
            item.groupItemId = (String)graph.getPossibleRelatedValue(subscriptionItem, L0.HasName, (Binding)Bindings.STRING);
            if (item.groupItemId != null && (rvi = (RVI)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_VariableId, rviBinding = ((Databoard)graph.getService(Databoard.class)).getBindingUnchecked(RVI.class))) != null && (configuration = Variables.getPossibleConfigurationContext((ReadGraph)graph, (Resource)subscription)) != null) {
                Resource activeExperiment = (Resource)graph.syncRequest((Read)new PossibleActiveExperiment(subscription));
                if (activeExperiment != null) {
                    Variable experimentVariable = null;
                    try {
                        experimentVariable = Variables.switchRealization((ReadGraph)graph, (Variable)configuration, (Resource)activeExperiment);
                    }
                    catch (DatabaseException e) {
                        experimentVariable = Variables.switchPossibleContext((ReadGraph)graph, (Variable)configuration, (Resource)activeExperiment);
                    }
                    if (experimentVariable != null) {
                        configuration = experimentVariable;
                    }
                }
                item.variableId = item.variableReference = rvi.toPossibleString(graph, configuration);
                if (item.variableId != null) {
                    if (item.simpleLabel.isEmpty()) {
                        item.simpleLabel = SubscriptionItemLabel.removeVariablePrefixPath(item.variableId);
                    }
                    item.groupId = subscription != null ? (String)graph.getPossibleRelatedValue(subscription, L0.HasName, (Binding)Bindings.STRING) : UUID.randomUUID().toString();
                    item.unit = (String)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_Unit, (Binding)Bindings.STRING);
                }
            }
        }
        if (item.groupItemId == null) {
            item.groupItemId = "";
        }
        if (item.variableId == null) {
            item.variableId = "";
        }
        if (item.groupId == null) {
            item.groupId = "";
        }
        if (item.unit == null) {
            item.unit = "";
        }
        return item;
    }
}

