/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.subscription;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.PendingVariableException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.request.PossibleVariableValue;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.subscription.ModelContexts;
import org.simantics.modeling.subscription.ModelContextsRequest;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.format.FormattingUtils;
import org.simantics.utils.format.ValueFormat;

public class SubscriptionItemLabel {
    private static final String NO_VARIABLE_ID = "<no variable id>";

    public static String resolveLabel(ReadGraph graph, Resource item, boolean synchronous) throws DatabaseException {
        IEclipsePreferences chartPreferenceNode = InstanceScope.INSTANCE.getNode("org.simantics.charts");
        String s = chartPreferenceNode.get("chart.valueformat", ValueFormat.Default.name());
        ValueFormat valueFormat = ValueFormat.valueOf((String)s);
        return SubscriptionItemLabel.resolveLabel(graph, item, valueFormat, synchronous);
    }

    public static String resolveLabel(ReadGraph graph, Resource item, ValueFormat valueFormat, boolean synchronous) throws DatabaseException {
        return SubscriptionItemLabel.resolveLabel(graph, item, valueFormat, synchronous, true, true);
    }

    public static String resolveLabel(ReadGraph graph, Resource item, ValueFormat valueFormat, boolean synchronous, boolean tryLabel, boolean showValue) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        String label = tryLabel ? (String)graph.getPossibleRelatedValue(item, L0.HasLabel, (Binding)Bindings.STRING) : null;
        boolean labelDefined = SubscriptionItemLabel.isNonempty(label);
        if (!showValue && labelDefined) {
            return label;
        }
        Binding rviBinding = ((Databoard)graph.getService(Databoard.class)).getBindingUnchecked(RVI.class);
        RVI rvi = (RVI)graph.getPossibleRelatedValue(item, MOD.Subscription_Item_VariableId, rviBinding);
        if (rvi == null) {
            return NO_VARIABLE_ID;
        }
        Resource model = (Resource)graph.syncRequest((Read)new PossibleModel(item));
        if (model != null) {
            ModelContexts contexts = (ModelContexts)((Object)graph.syncRequest((Read)new ModelContextsRequest(model), (AsyncProcedure)TransientCacheAsyncListener.instance()));
            Variable configurationContext = contexts.getConfigurationContext();
            Variable experimentContext = contexts.getExperimentContext();
            if (configurationContext != null) {
                Variable variable = null;
                Variable resolutionContext = experimentContext;
                String resolutionContextURI = contexts.getExperimentContextURI();
                if (showValue && experimentContext != null) {
                    variable = rvi.resolvePossible(graph, experimentContext);
                }
                if (variable == null) {
                    resolutionContext = configurationContext;
                    resolutionContextURI = contexts.getConfigurationContextURI();
                    variable = rvi.resolvePossible(graph, configurationContext);
                }
                if (variable != null) {
                    if (!labelDefined) {
                        label = SubscriptionItemLabel.relativeURI(graph, variable, resolutionContextURI);
                        if (label == null) {
                            label = rvi.toPossibleString(graph, configurationContext);
                        }
                        if (label != null) {
                            label = SubscriptionItemLabel.removeVariablePrefixPath(label);
                            label = URIStringUtils.unescape((String)label);
                        }
                    }
                    if (showValue && resolutionContext == experimentContext) {
                        StringBuilder sb;
                        block16: {
                            sb = new StringBuilder(label);
                            Double gain = (Double)graph.getPossibleRelatedValue(item, MOD.Subscription_Item_Gain, (Binding)Bindings.DOUBLE);
                            Double bias = (Double)graph.getPossibleRelatedValue(item, MOD.Subscription_Item_Bias, (Binding)Bindings.DOUBLE);
                            String unit = (String)graph.getPossibleRelatedValue(item, MOD.Subscription_Item_Unit, (Binding)Bindings.STRING);
                            boolean oldSync = graph.setSynchronous(synchronous);
                            try {
                                try {
                                    Object value = graph.syncRequest((Read)new PossibleVariableValue(variable));
                                    sb = SubscriptionItemLabel.formatValue(value, gain, bias, unit, valueFormat, sb);
                                }
                                catch (PendingVariableException e) {
                                    sb.append(" (<pending>)");
                                    graph.setSynchronous(oldSync);
                                    break block16;
                                }
                            }
                            catch (Throwable throwable) {
                                graph.setSynchronous(oldSync);
                                throw throwable;
                            }
                            graph.setSynchronous(oldSync);
                        }
                        label = sb.toString();
                    }
                }
            }
        }
        return label != null ? label : NO_VARIABLE_ID;
    }

    private static StringBuilder formatValue(Object value, Double gain, Double bias, String unit, ValueFormat valueFormat, StringBuilder sb) {
        if (value instanceof Number) {
            double d;
            double ad = d = ((Number)value).doubleValue();
            if (gain != null) {
                ad *= gain.doubleValue();
            }
            if (bias != null) {
                ad += bias.doubleValue();
            }
            sb.append(" (").append(valueFormat.format.format(ad));
        } else {
            sb.append(" (").append(FormattingUtils.engineeringFormat((Object)value));
        }
        if (unit != null && !unit.isEmpty()) {
            sb.append(' ').append(unit);
        }
        return sb.append(')');
    }

    public static String removeVariablePrefixPath(String rvi) {
        int propIndex = rvi.indexOf(35);
        if (propIndex == -1) {
            return rvi;
        }
        int prevSlash = rvi.lastIndexOf(47, propIndex);
        if (prevSlash == -1) {
            return rvi;
        }
        Pair<String, Integer> attrKey = SubscriptionItemLabel.attributeKey(rvi, propIndex + 1);
        return String.valueOf(rvi.substring(prevSlash + 1, propIndex + 1)) + (String)attrKey.first + (attrKey.second != null ? "(" + ((Integer)attrKey.second + 1) + ")" : "");
    }

    private static Pair<String, Integer> attributeKey(String key, int start) {
        ChildReference child;
        boolean isIndexed;
        int iy = key.lastIndexOf(47);
        boolean bl = isIndexed = iy >= start;
        if (isIndexed && (child = ChildReference.parsePath((String)key.substring(iy + 1))) instanceof IndexReference) {
            return Pair.make((Object)key.substring(start, iy), (Object)((IndexReference)child).getIndex());
        }
        return Pair.make((Object)key.substring(start), null);
    }

    private static boolean isNonempty(String label) {
        return label != null && !label.trim().isEmpty();
    }

    private static String relativeURI(ReadGraph graph, Variable variable, String contextURI) throws DatabaseException {
        return SubscriptionItemLabel.relativeURI(variable.getURI(graph), contextURI);
    }

    private static String relativeURI(String fullURI, String contextURI) {
        return fullURI.substring(contextURI.length());
    }
}

