/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.subscription;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.ObjectIdentitySchedulingRule;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.Bean;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.procedure.adapter.ListenerAdapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.history.Collector;
import org.simantics.history.History;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.history.ItemManager;
import org.simantics.history.impl.FileHistory;
import org.simantics.history.impl.FlushPolicy;
import org.simantics.history.util.subscription.SubscriptionItem;
import org.simantics.modeling.subscription.SubscriptionCollectionResult;
import org.simantics.simulation.data.Datasource;
import org.simantics.simulation.data.DatasourceAdapter;
import org.simantics.simulation.data.VariableHandle;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IDynamicExperiment;
import org.simantics.utils.datastructures.Callable;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.threads.IThreadWorkQueue;

public class ModelHistoryCollector {
    private Logger log = Logger.getLogger(this.getClass().getName());
    static final String BUNDLE_ID = "org.simantics.modeling";
    private Session session;
    private HistoryManager history;
    private Resource model;
    private IDynamicExperiment dynamicExperiment;
    private ILog logger;
    private Callable<Read<SubscriptionCollectionResult>> subscriptionFunction;
    private Runnable loadCallback;
    private IThreadWorkQueue loadThread;
    private VariableSetListener variableListener;
    private Semaphore initMutex = new Semaphore(0);
    private final ItemCollector itemCollector = new ItemCollector();

    public static ModelHistoryCollector createCollector(IDynamicExperiment dynamicExperiment, HistoryManager history, ILog log, Callable<Read<SubscriptionCollectionResult>> subscriptionRequestFunction, Runnable loadCallback) throws DatabaseException, IOException {
        return ModelHistoryCollector.createCollector(dynamicExperiment, history, log, subscriptionRequestFunction, loadCallback, null);
    }

    public static ModelHistoryCollector createCollector(IDynamicExperiment dynamicExperiment, HistoryManager history, ILog log, Callable<Read<SubscriptionCollectionResult>> subscriptionRequestFunction, Runnable loadCallback, IThreadWorkQueue loadThread) throws DatabaseException, IOException {
        ModelHistoryCollector data = new ModelHistoryCollector();
        data.history = history;
        data.model = dynamicExperiment.getModel();
        data.dynamicExperiment = dynamicExperiment;
        data.logger = log;
        data.subscriptionFunction = subscriptionRequestFunction;
        data.loadCallback = loadCallback;
        data.loadThread = loadThread;
        return data;
    }

    private ModelHistoryCollector() {
    }

    public void initialize(RequestProcessor processor, double startTime) throws DatabaseException, HistoryException, InterruptedException {
        this.initialize(processor, startTime, false);
    }

    public void initialize(RequestProcessor processor, double startTime, boolean listenToVariableSet) throws DatabaseException, HistoryException, InterruptedException {
        this.session = processor.getSession();
        this.itemCollector.init(this.history, this.dynamicExperiment, startTime, this.model);
        this.refresh0(processor, listenToVariableSet);
    }

    public void refresh() throws HistoryException, DatabaseException, InterruptedException {
        this.refresh0((RequestProcessor)this.session, false);
    }

    public File getWorkarea() {
        return this.history instanceof FileHistory ? ((FileHistory)this.history).getWorkarea() : null;
    }

    public HistoryManager getHistoryManager() {
        return this.itemCollector.history;
    }

    private void refresh0(RequestProcessor processor, boolean listenToVariableSet) throws HistoryException, DatabaseException, InterruptedException {
        if (listenToVariableSet) {
            if (this.variableListener == null) {
                this.variableListener = new VariableSetListener();
                this.initMutex = new Semaphore(0);
                processor.asyncRequest((Read)this.subscriptionFunction.call(), (Listener)this.variableListener);
                this.initMutex.acquire();
            }
        } else if (this.variableListener == null) {
            SubscriptionCollectionResult variables = (SubscriptionCollectionResult)((Object)processor.syncRequest((Read)this.subscriptionFunction.call()));
            if (!variables.getStatus().isOK() && this.logger != null) {
                this.logger.log((IStatus)variables.getStatus());
            }
            this.itemCollector.load(variables.getSubscriptions());
            if (this.loadCallback != null) {
                this.loadCallback.run();
            }
        }
    }

    public void dispose() {
        if (this.variableListener != null) {
            this.variableListener.dispose();
            this.variableListener = null;
        }
        this.itemCollector.dispose();
    }

    public void primeInitialSubscription(ReadGraph graph) throws DatabaseException {
        SubscriptionCollectionResult variables = (SubscriptionCollectionResult)((Object)graph.syncRequest((Read)this.subscriptionFunction.call()));
        HashSet<Pair> variableIds = new HashSet<Pair>();
        for (Bean hi : variables.getSubscriptions()) {
            String variableId = (String)hi.getFieldUnchecked("variableId");
            variableIds.add(Pair.make((Object)hi, (Object)variableId));
        }
        Datasource source = this.dynamicExperiment.getDatasource();
        for (Pair ids : variableIds) {
            Datatype type = source.getType((String)ids.second);
            Binding valueBinding = Bindings.getBinding((Datatype)type);
            VariableHandle handle = source.openHandle((Bean)ids.first, (String)ids.second, valueBinding);
            try {
                try {
                    handle.getValue();
                }
                catch (AccessorException e) {
                    this.logger.log((IStatus)new Status(4, "org.simantics.simulation", e.getLocalizedMessage(), (Throwable)e));
                    handle.dispose();
                    continue;
                }
            }
            catch (Throwable throwable) {
                handle.dispose();
                throw throwable;
            }
            handle.dispose();
        }
    }

    public Collector getCollector() {
        return this.itemCollector.collector;
    }

    public static class ItemCollector {
        IDynamicExperiment experiment;
        Datasource source;
        HistoryManager history;
        Collector collector;
        DatasourceAdapter adapter;
        Resource model;

        public synchronized void init(HistoryManager history, IDynamicExperiment experiment, double startTime, Resource model) {
            this.experiment = experiment;
            this.source = experiment.getDatasource();
            this.history = history;
            this.collector = History.createCollector((HistoryManager)this.history, (FlushPolicy)FlushPolicy.NoFlush);
            this.model = model;
        }

        public synchronized void load(List<Bean> items) throws HistoryException, DatabaseException {
            if (this.isDisposed()) {
                return;
            }
            ExperimentState oldState = this.experiment.getState();
            if (oldState == ExperimentState.RUNNING) {
                this.experiment.changeState(ExperimentState.STOPPED);
            }
            try {
                ItemManager im = new ItemManager(items);
                if (this.collector == null) {
                    this.collector = History.createCollector((HistoryManager)this.history);
                }
                SubscriptionItem[] subscriptionItemArray = this.collector.getItems();
                int n = subscriptionItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SubscriptionItem oldItem = subscriptionItemArray[n2];
                    String id = (String)oldItem.getFieldUnchecked("id");
                    Bean newItem = im.get(id);
                    if (newItem == null) {
                        oldItem.enabled = false;
                        this.collector.setItem((Bean)oldItem);
                    }
                    ++n2;
                }
                for (Bean newItem : items) {
                    this.collector.setItem(newItem);
                }
                this.history.modify(items.toArray(new Bean[items.size()]));
                if (this.adapter == null) {
                    this.adapter = new DatasourceAdapter(this.collector);
                    this.source.addListener((Datasource.DatasourceListener)this.adapter);
                } else {
                    this.adapter.reset();
                }
            }
            finally {
                this.experiment.changeState(oldState);
            }
        }

        public synchronized void dispose() {
            if (this.source != null && this.adapter != null) {
                this.source.removeListener((Datasource.DatasourceListener)this.adapter);
            }
            if (this.adapter != null) {
                this.adapter.reset();
            }
            if (this.collector != null) {
                this.collector.close();
            }
            if (this.history != null) {
                this.history.close();
            }
            this.experiment = null;
        }

        public HistoryManager getCollector() {
            return this.history;
        }

        public boolean isDisposed() {
            return this.experiment == null;
        }
    }

    class VariableSetListener
    extends ListenerAdapter<SubscriptionCollectionResult> {
        boolean disposed;

        VariableSetListener() {
        }

        public void execute(final SubscriptionCollectionResult result) {
            Job job = new Job("Reloading history subscriptions"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        if (ModelHistoryCollector.this.itemCollector.isDisposed()) {
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        if (!result.getStatus().isOK() && ModelHistoryCollector.this.logger != null) {
                            ModelHistoryCollector.this.logger.log((IStatus)result.getStatus());
                        }
                        final IStatus[] status = new IStatus[1];
                        Runnable loader = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    ModelHistoryCollector.this.itemCollector.load(result.getSubscriptions());
                                }
                                catch (HistoryException e) {
                                    status[0] = new Status(4, ModelHistoryCollector.BUNDLE_ID, e.getLocalizedMessage(), (Throwable)e);
                                    if (ModelHistoryCollector.this.logger != null) {
                                        ModelHistoryCollector.this.logger.log(status[0]);
                                    }
                                }
                                catch (DatabaseException e) {
                                    ModelHistoryCollector.this.log.log(Level.WARNING, "Unexpected failure in history variable collection request.", e);
                                    status[0] = new Status(4, ModelHistoryCollector.BUNDLE_ID, e.getLocalizedMessage(), (Throwable)e);
                                }
                            }
                        };
                        if (ModelHistoryCollector.this.loadThread != null) {
                            ModelHistoryCollector.this.loadThread.syncExec(loader);
                        } else {
                            loader.run();
                        }
                        if (status[0] == null && ModelHistoryCollector.this.loadCallback != null) {
                            ModelHistoryCollector.this.loadCallback.run();
                        }
                        IStatus iStatus = status[0] != null ? status[0] : Status.OK_STATUS;
                        return iStatus;
                    }
                    catch (RejectedExecutionException e) {
                        Status status = new Status(1, ModelHistoryCollector.BUNDLE_ID, e.getLocalizedMessage(), (Throwable)e);
                        return status;
                    }
                    finally {
                        ModelHistoryCollector.this.initMutex.release();
                    }
                }
            };
            job.setRule((ISchedulingRule)new ObjectIdentitySchedulingRule((Object)ModelHistoryCollector.this));
            job.setUser(false);
            job.schedule();
        }

        public void dispose() {
            this.disposed = true;
        }

        public void exception(Throwable t) {
            ModelHistoryCollector.this.initMutex.release();
            ModelHistoryCollector.this.log.log(Level.WARNING, "Unexpected failure in history variable collection request.", t);
        }

        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

