/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.subscription;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.util.Bean;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.history.ItemManager;
import org.simantics.history.util.subscription.SamplingFormat;
import org.simantics.history.util.subscription.SubscriptionItem;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.subscription.SubscriptionCollectionResult;
import org.simantics.simulation.data.Datasource;
import org.simantics.simulation.data.VariableHandle;
import org.simantics.simulation.experiment.IDynamicExperiment;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.trend.configuration.TrendSamplingFormats;

public class CollectSubscriptions
extends ResourceRead<SubscriptionCollectionResult> {
    protected IDynamicExperiment experiment;
    public double defaultSamplingInterval;
    public HistoryManager historyForIDCorrespondences;
    ItemManager itemManager;

    public CollectSubscriptions(Resource model, IDynamicExperiment experiment) {
        super(model);
        this.experiment = experiment;
    }

    public SubscriptionCollectionResult perform(ReadGraph graph) throws DatabaseException {
        MultiStatus status = new MultiStatus("org.simantics.modeling", 0, "History collection subscription resolution problems:", null);
        List<Bean> items = this.gatherSubscriptions(graph, this.resource, status, new ArrayList<Bean>());
        return new SubscriptionCollectionResult(items, status);
    }

    public List<Bean> gatherSubscriptions(ReadGraph graph, Resource model, MultiStatus status, List<Bean> items) throws DatabaseException {
        Variable configuration;
        if (this.historyForIDCorrespondences != null) {
            try {
                this.itemManager = new ItemManager(this.historyForIDCorrespondences.getItems());
            }
            catch (HistoryException historyException) {
                // empty catch block
            }
        }
        if ((configuration = Variables.getPossibleConfigurationContext((ReadGraph)graph, (Resource)model)) == null) {
            return items;
        }
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource run : (Collection)graph.syncRequest((Read)new ObjectsWithType(this.experiment.getResource(), L0.ConsistsOf, SIMU.Run))) {
            if (!graph.hasStatement(run, SIMU.IsActive)) continue;
            Variable experimentVariable = null;
            try {
                experimentVariable = Variables.switchRealization((ReadGraph)graph, (Variable)configuration, (Resource)run);
            }
            catch (DatabaseException e) {
                experimentVariable = Variables.switchPossibleContext((ReadGraph)graph, (Variable)configuration, (Resource)run);
            }
            if (experimentVariable == null) continue;
            configuration = experimentVariable;
            break;
        }
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        for (Resource r : (Collection)graph.syncRequest((Read)new ObjectsWithType(model, L0.ConsistsOf, MOD.Subscription))) {
            this.processSubscription(graph, r, configuration, items, status);
        }
        return items;
    }

    private void processSubscription(ReadGraph graph, Resource r, Variable configuration, List<Bean> items, MultiStatus status) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Datasource datasource = this.experiment.getDatasource();
        Boolean v = (Boolean)graph.getPossibleRelatedValue(r, MOD.Subscription_Enabled, (Binding)Bindings.BOOLEAN);
        if (!Boolean.TRUE.equals(v)) {
            return;
        }
        String groupId = (String)graph.getPossibleRelatedValue(r, L0.HasName, (Binding)Bindings.STRING);
        if (groupId == null) {
            status.add((IStatus)new Status(2, "org.simantics.modeling", "Subscription '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)r) + "' has no name (ID)."));
            return;
        }
        Binding rviBinding = ((Databoard)graph.getService(Databoard.class)).getBindingUnchecked(RVI.class);
        for (Resource subscriptionItem : graph.getObjects(r, L0.ConsistsOf)) {
            SubscriptionItem[] his;
            VariableHandle handle;
            if (!graph.isInstanceOf(subscriptionItem, MOD.Subscription_Item)) continue;
            RVI rvi = (RVI)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_VariableId, rviBinding);
            if (rvi == null) {
                status.add((IStatus)new Status(2, "org.simantics.modeling", "Subscription Item '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)subscriptionItem) + "' is missing RVI property"));
                continue;
            }
            String guid = (String)graph.getPossibleRelatedValue(subscriptionItem, L0.HasName);
            if (guid == null) {
                status.add((IStatus)new Status(2, "org.simantics.modeling", "Subscription Item '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)subscriptionItem) + "' has no name (ID)."));
                continue;
            }
            String variablePersistentId = rvi.toString();
            String variableId = rvi.asPossibleString(graph, configuration);
            if (variableId == null) continue;
            Datatype type = (Datatype)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_Datatype, Bindings.getBindingUnchecked(Datatype.class));
            if (variableId != null && type == null && datasource != null) {
                type = datasource.getType(variableId);
            }
            if (type == null) {
                status.add((IStatus)new Status(2, "org.simantics.modeling", "Subscription Item '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)subscriptionItem) + "' is missing data type"));
            }
            VariableHandle variableHandle = handle = datasource != null && variableId != null ? datasource.openHandle(null, variableId, Bindings.getBinding((Datatype)type)) : null;
            if (handle == null) {
                status.add((IStatus)new Status(2, "org.simantics.modeling", "Subscription Item '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)subscriptionItem) + "' with variable id '" + variableId + "' could not be resolved. Perhaps the referenced component is no longer part of your model?"));
            } else {
                handle.dispose();
            }
            Double samplingInterval = (Double)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_SamplingInterval, (Binding)Bindings.DOUBLE);
            Double deadband = (Double)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_Deadband, (Binding)Bindings.DOUBLE);
            Double bias = (Double)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_Bias, (Binding)Bindings.DOUBLE);
            Double gain = (Double)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_Gain, (Binding)Bindings.DOUBLE);
            String unit = (String)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_Unit, (Binding)Bindings.STRING);
            if (samplingInterval == null) {
                samplingInterval = this.defaultSamplingInterval;
            }
            if (deadband == null) {
                deadband = 0.0;
            }
            Collection<Object> formats = null;
            if (type != null) {
                if (type instanceof BooleanType) {
                    formats = TrendSamplingFormats.createBinarySamplingFormats((double)samplingInterval);
                } else if (type instanceof NumberType) {
                    formats = TrendSamplingFormats.createAnalogSamplingFormats((double)samplingInterval, (double)deadband, (String)unit);
                } else {
                    SamplingFormat format = new SamplingFormat();
                    format.formatId = "custom";
                    format.format = new RecordType();
                    format.format = new RecordType();
                    RecordType f = format.format;
                    f.addComponent("time", (Datatype)Datatypes.DOUBLE);
                    f.addComponent("endTime", (Datatype)Datatypes.DOUBLE);
                    f.addComponent("quality", (Datatype)Datatypes.BYTE);
                    f.addComponent("value", type);
                    format.interval = samplingInterval;
                    format.deadband = deadband;
                    formats = Collections.singleton(format);
                }
            }
            SubscriptionItem[] subscriptionItemArray = his = SubscriptionItem.createItems((String)variablePersistentId, (String)groupId, formats);
            int n = his.length;
            int n2 = 0;
            while (n2 < n) {
                SubscriptionItem hi = subscriptionItemArray[n2];
                hi.variableId = variableId;
                hi.id = String.valueOf(groupId) + " " + guid + " " + hi.formatId;
                if (bias != null) {
                    hi.bias = bias;
                }
                if (gain != null) {
                    hi.gain = gain;
                }
                SubscriptionItem bean = hi;
                if (this.itemManager != null) {
                    try {
                        List correspondingItems = this.itemManager.search("groupId", (Object)hi.groupId, "variableId", (Object)hi.variableId, "bias", (Object)hi.bias, "gain", (Object)hi.gain, "format", (Object)hi.format, "interval", (Object)hi.interval, "deadband", (Object)hi.deadband);
                        if (correspondingItems.size() == 1) {
                            bean = (Bean)correspondingItems.get(0);
                        }
                    }
                    catch (BindingException bindingException) {
                        // empty catch block
                    }
                }
                items.add((Bean)bean);
                ++n2;
            }
        }
    }
}

