/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.services;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.Indexing;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.genericrelation.IndexQueries;
import org.simantics.db.request.Read;
import org.simantics.db.service.GraphChangeListenerSupport;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.services.CaseInsensitiveComponentNamingStrategy2;
import org.simantics.modeling.services.ComponentNamingStrategyBase;
import org.simantics.modeling.services.NamingException;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.structural.stubs.StructuralResource2;

public class CaseInsensitiveComponentFunctionNamingStrategy
extends ComponentNamingStrategyBase {
    protected static final boolean DEBUG_INDEX_SEARCH = false;
    private final Function index;
    private Function1<String, String> propositionPreFilter;
    CaseInsensitiveComponentNamingStrategy2 fallbackStrategy = null;

    public CaseInsensitiveComponentFunctionNamingStrategy(Function index) {
        this("%s %d", index);
    }

    public CaseInsensitiveComponentFunctionNamingStrategy(String generatedNameFormat, Function index) {
        super(generatedNameFormat);
        this.index = index;
    }

    public CaseInsensitiveComponentFunctionNamingStrategy(String generatedNameFormat, Function index, Function1<String, String> propositionPreFilter) {
        super(generatedNameFormat);
        this.index = index;
        this.propositionPreFilter = propositionPreFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String validateInstanceName(ReadGraph graph, Resource configurationRoot, Resource component, String proposition, boolean acceptProposition) throws NamingException, DatabaseException {
        Resource indexRoot;
        String lowercaseName;
        String lowercaseProposition = proposition.toLowerCase();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String name = (String)graph.getPossibleRelatedValue(component, L0.HasName, (Binding)Bindings.STRING);
        if (name != null && (lowercaseName = name.toLowerCase()).startsWith(lowercaseProposition) && (indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(configurationRoot))) != null) {
            CaseInsensitiveComponentFunctionNamingStrategy caseInsensitiveComponentFunctionNamingStrategy = this;
            synchronized (caseInsensitiveComponentFunctionNamingStrategy) {
                String search = "Name:" + lowercaseName + "*";
                List components = (List)this.index.apply((Object)graph, (Object)indexRoot, (Object)search, (Object)Integer.MAX_VALUE);
                THashSet rs = new THashSet();
                for (Resource componentResult : components) {
                    String n = (String)graph.getPossibleRelatedValue(componentResult, L0.HasName, (Binding)Bindings.STRING);
                    if (n == null || !n.toLowerCase().equals(lowercaseName)) continue;
                    rs.add(componentResult);
                }
                Cache c = this.getCache(graph, indexRoot);
                if (rs.size() == 0) {
                    if (!c.getRequested().contains(name)) {
                        c.addRequested(name);
                        return name;
                    }
                } else if (rs.size() == 1 && component.equals(rs.iterator().next())) {
                    return name;
                }
            }
        }
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource container = graph.getSingleObject(component, L0.PartOf);
        Resource componentType = graph.getSingleType(component, STR.Component);
        return this.validateInstanceName(graph, configurationRoot, container, componentType, proposition, acceptProposition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String validateInstanceName(ReadGraph graph, Resource configurationRoot, Resource container, Resource componentType, String proposition, boolean acceptProposition) throws NamingException, DatabaseException {
        Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(configurationRoot));
        if (indexRoot == null) {
            System.err.println("Could not find index root from configuration root '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)configurationRoot, (boolean)true) + "'");
            if (this.fallbackStrategy == null) {
                this.fallbackStrategy = new CaseInsensitiveComponentNamingStrategy2((GraphChangeListenerSupport)graph.getService(GraphChangeListenerSupport.class), this.generatedNameFormat);
            }
            return this.fallbackStrategy.validateInstanceName(graph, configurationRoot, container, componentType, proposition, acceptProposition);
        }
        if (this.propositionPreFilter != null) {
            proposition = (String)this.propositionPreFilter.apply((Object)proposition);
        }
        CaseInsensitiveComponentFunctionNamingStrategy caseInsensitiveComponentFunctionNamingStrategy = this;
        synchronized (caseInsensitiveComponentFunctionNamingStrategy) {
            String search = "Name:" + proposition + "*";
            List components = (List)this.index.apply((Object)graph, (Object)indexRoot, (Object)search, (Object)Integer.MAX_VALUE);
            TreeSet<Object> reserved = new TreeSet<Object>(this.getComparator());
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            for (Resource componentResult : components) {
                String name = (String)graph.getPossibleRelatedValue(componentResult, L0.HasName, (Binding)Bindings.STRING);
                if (name == null) continue;
                reserved.add(name);
            }
            Cache cache = this.getCache(graph, indexRoot);
            this.findStartsWithMatches(cache.getRequested(), proposition, reserved);
            String result = this.findFreshName(reserved, proposition, acceptProposition);
            cache.addRequested(result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> validateInstanceNames(ReadGraph graph, Resource configurationRoot, List<String> propositions, boolean acceptProposition, Set<String> externallyReserved) throws NamingException, DatabaseException {
        Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(configurationRoot));
        if (indexRoot == null) {
            throw new NamingException("Could not find index root from configuration root '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)configurationRoot, (boolean)true) + "'");
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        CaseInsensitiveComponentFunctionNamingStrategy caseInsensitiveComponentFunctionNamingStrategy = this;
        synchronized (caseInsensitiveComponentFunctionNamingStrategy) {
            ArrayList<String> result = new ArrayList<String>(propositions.size());
            TreeSet<Object> reserved = new TreeSet<Object>(this.getComparator());
            for (String proposition : propositions) {
                if (this.propositionPreFilter != null) {
                    proposition = (String)this.propositionPreFilter.apply((Object)proposition);
                }
                String search = "Name:" + IndexQueries.escape((String)proposition) + "*";
                List components = (List)this.index.apply((Object)graph, (Object)indexRoot, (Object)search, (Object)Integer.MAX_VALUE);
                reserved.clear();
                for (Resource componentResult : components) {
                    String name = (String)graph.getPossibleRelatedValue(componentResult, L0.HasName, (Binding)Bindings.STRING);
                    if (name == null) continue;
                    reserved.add(name);
                }
                if (externallyReserved != null) {
                    reserved.addAll(externallyReserved);
                }
                reserved.addAll(result);
                String name = this.findFreshName(reserved, proposition, acceptProposition);
                result.add(name);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache getCache(ReadGraph graph, Resource root) throws DatabaseException {
        Cache cache = (Cache)Indexing.getCache((Resource)root, Cache.class);
        if (cache != null) {
            return cache;
        }
        CaseInsensitiveComponentFunctionNamingStrategy caseInsensitiveComponentFunctionNamingStrategy = this;
        synchronized (caseInsensitiveComponentFunctionNamingStrategy) {
            cache = (Cache)Indexing.getCache((Resource)root, Cache.class);
            if (cache != null) {
                return cache;
            }
            return (Cache)Indexing.createCache((Resource)root, (Object)new Cache(this.caseInsensitive));
        }
    }

    static class Cache {
        private final Set<String> requested;

        Cache(boolean caseInsensitive) {
            this.requested = new TreeSet<Object>(CaseInsensitiveComponentFunctionNamingStrategy.getComparator(caseInsensitive));
        }

        public Set<String> getRequested() {
            return this.requested;
        }

        public void addRequested(String name) {
            this.requested.add(name);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + ": " + this.requested;
        }
    }
}

