/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.scl;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.simantics.modeling.scl.SCLRealm;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;

public class SCLSessionManager {
    static ConcurrentHashMap<String, SCLRealm> CONNECTIONS = new ConcurrentHashMap();

    public static SCLRealm sclRealmById(String id) {
        return CONNECTIONS.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SCLRealm createRealm() {
        ConcurrentHashMap<String, SCLRealm> concurrentHashMap = CONNECTIONS;
        synchronized (concurrentHashMap) {
            String id = UUID.randomUUID().toString();
            return SCLSessionManager.createRealm(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SCLRealm getOrCreateSCLRealm(String id) {
        ConcurrentHashMap<String, SCLRealm> concurrentHashMap = CONNECTIONS;
        synchronized (concurrentHashMap) {
            SCLRealm session = SCLSessionManager.sclRealmById(id);
            if (session == null) {
                return SCLSessionManager.createRealm(id);
            }
            return session;
        }
    }

    private static SCLRealm createRealm(String id) {
        CommandSession connection = new CommandSession(SCLOsgi.MODULE_REPOSITORY, SCLReportingHandler.DEFAULT);
        SCLRealm realm = new SCLRealm(connection, id);
        CONNECTIONS.put(id, realm);
        return realm;
    }

    public static void removeRealm(String id) {
        CONNECTIONS.remove(id);
    }
}

