/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.scl;

import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.simantics.Logger;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.serialization.RuntimeSerializerConstructionException;
import org.simantics.modeling.SCLTypeUtils;
import org.simantics.modeling.scl.SCLNodeManager;
import org.simantics.modeling.scl.SCLSessionManager;
import org.simantics.modeling.scl.SCLState;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.simantics.simulator.variable.NodeManager;
import org.simantics.simulator.variable.Realm;

public class SCLRealm
implements Realm {
    public static final String SCL = "scl";
    THashMap<String, Type> contextTypes = new THashMap();
    CommandSession connection;
    String id;
    Thread executorThread;
    ExecutorService executor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            SCLRealm.this.executorThread = new Thread(r);
            return SCLRealm.this.executorThread;
        }
    });
    Semaphore beginSyncExec = new Semaphore(0);
    Semaphore endSyncExec = new Semaphore(0);
    SCLNodeManager nodeManager;
    Runnable scheduleSyncExec = new Runnable(){

        @Override
        public void run() {
            SCLRealm.this.beginSyncExec.release();
            try {
                SCLRealm.this.endSyncExec.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };

    SCLRealm(CommandSession connection, String id) {
        this.connection = connection;
        this.id = id;
        this.nodeManager = new SCLNodeManager(this);
    }

    public String getId() {
        return this.id;
    }

    public CommandSession getConnection() {
        return this.connection;
    }

    public Thread getThread() {
        return this.executorThread;
    }

    public Object syncExec(Function fun) throws InterruptedException {
        this.executor.execute(this.scheduleSyncExec);
        SCLContext context = SCLContext.getCurrent();
        CommandSession oldConnection = (CommandSession)context.put((Object)SCL, (Object)this.connection);
        try {
            this.beginSyncExec.acquire();
            Thread oldThread = this.executorThread;
            this.executorThread = Thread.currentThread();
            try {
                Object object = fun.apply((Object)Tuple0.INSTANCE);
                this.executorThread = oldThread;
                this.endSyncExec.release();
                return object;
            }
            catch (Throwable throwable) {
                this.executorThread = oldThread;
                this.endSyncExec.release();
                throw throwable;
            }
        }
        finally {
            context.put((Object)SCL, (Object)oldConnection);
        }
    }

    public void asyncExec(final Function fun) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                SCLContext context = SCLContext.getCurrent();
                context.put((Object)SCLRealm.SCL, (Object)SCLRealm.this.connection);
                fun.apply((Object)Tuple0.INSTANCE);
            }
        });
    }

    public void syncExec(Runnable runnable) throws InterruptedException {
        if (this.executorThread == Thread.currentThread()) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                Logger.defaultLogError((Throwable)t);
            }
            return;
        }
        this.executor.execute(this.scheduleSyncExec);
        this.beginSyncExec.acquire();
        Thread oldThread = this.executorThread;
        this.executorThread = Thread.currentThread();
        try {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                Logger.defaultLogError((Throwable)t);
                this.executorThread = oldThread;
                this.endSyncExec.release();
            }
        }
        finally {
            this.executorThread = oldThread;
            this.endSyncExec.release();
        }
    }

    public void asyncExec(Runnable runnable) {
        if (this.executorThread == Thread.currentThread()) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                Logger.defaultLogError((Throwable)t);
            }
            return;
        }
        this.executor.execute(runnable);
    }

    public void refreshVariables() {
        this.nodeManager.refreshVariables();
    }

    public void refreshVariablesSync() {
        this.nodeManager.refreshVariablesSync();
    }

    public void close() {
        SCLSessionManager.CONNECTIONS.remove(this.id);
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public NodeManager<String> getNodeManager() {
        return this.nodeManager;
    }

    private SCLState getState() {
        SCLState state = new SCLState();
        for (String key : this.connection.getVariables()) {
            Object value = this.connection.getVariableValue(key);
            try {
                Binding b = Bindings.getBinding(value.getClass());
                state.values.put(key, new Variant(b, value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return state;
    }

    public void applyState(byte[] blob) {
        try {
            SCLState state = (SCLState)SCLState.BINDING.serializer().deserialize(blob);
            for (Map.Entry<String, Variant> entry : state.values.entrySet()) {
                String key = entry.getKey();
                Variant value = entry.getValue();
                Type type = SCLTypeUtils.getType(value.type());
                if (type.getClassId() == 6) continue;
                this.connection.setVariable(key, type, value.getValue());
            }
        }
        catch (RuntimeSerializerConstructionException runtimeSerializerConstructionException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public byte[] serialize() {
        SCLState state = this.getState();
        try {
            return SCLState.BINDING.serializer().serialize((Object)state);
        }
        catch (RuntimeSerializerConstructionException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

