/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.scl;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.scl.SCLRealm;
import org.simantics.scl.compiler.types.Type;
import org.simantics.simulator.variable.Realm;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.simantics.simulator.variable.exceptions.NotInRealmException;
import org.simantics.simulator.variable.impl.AbstractNodeManager;

public class SCLNodeManager
extends AbstractNodeManager<String> {
    public static final String ROOT = "@";
    SCLRealm realm;
    THashMap<String, Object> valueCache = new THashMap();
    THashMap<String, THashSet<Runnable>> listeners = new THashMap();
    AtomicBoolean fireNodeListenersScheduled = new AtomicBoolean(false);
    Runnable fireNodeListeners = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SCLNodeManager.this.fireNodeListenersScheduled.set(false);
            TObjectProcedure<Runnable> procedure = new TObjectProcedure<Runnable>(){

                public boolean execute(Runnable object) {
                    object.run();
                    return true;
                }
            };
            THashMap<String, THashSet<Runnable>> tHashMap = SCLNodeManager.this.listeners;
            synchronized (tHashMap) {
                SCLNodeManager.this.listeners.forEachValue((TObjectProcedure)new TObjectProcedure<THashSet<Runnable>>((TObjectProcedure)procedure){
                    private final /* synthetic */ TObjectProcedure val$procedure;
                    {
                        this.val$procedure = tObjectProcedure;
                    }

                    public boolean execute(THashSet<Runnable> object) {
                        object.forEach(this.val$procedure);
                        return true;
                    }
                });
            }
        }
    };
    Runnable clearValueCache = new Runnable(){

        @Override
        public void run() {
            SCLNodeManager.this.valueCache.clear();
        }
    };
    static final Set<String> COMPONENT_CLASS = Collections.singleton("http://www.simantics.org/Structural-1.2/Component");

    public SCLNodeManager(SCLRealm realm) {
        this.realm = realm;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public String getName(String node) {
        if (ROOT.equals(node)) {
            String id = this.realm.id;
            int lastSlash = id.lastIndexOf("/");
            if (lastSlash == -1) {
                throw new IllegalStateException("Invalid realm id " + id);
            }
            String name = id.substring(lastSlash + 1);
            return name;
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeListener(String node, Runnable listener) {
        THashMap<String, THashSet<Runnable>> tHashMap = this.listeners;
        synchronized (tHashMap) {
            THashSet l = (THashSet)this.listeners.get((Object)node);
            if (l == null) {
                l = new THashSet();
                this.listeners.put((Object)node, (Object)l);
            }
            l.add((Object)listener);
        }
        this.realm.asyncExec(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodeListener(String node, Runnable listener) {
        THashMap<String, THashSet<Runnable>> tHashMap = this.listeners;
        synchronized (tHashMap) {
            THashSet l = (THashSet)this.listeners.get((Object)node);
            if (l != null) {
                l.remove((Object)listener);
                if (l.isEmpty()) {
                    this.listeners.remove((Object)node);
                }
            }
        }
    }

    public void fireNodeListeners() {
        if (!this.fireNodeListenersScheduled.getAndSet(true)) {
            this.realm.asyncExec(this.fireNodeListeners);
        }
    }

    public void fireNodeListenersSync() {
        try {
            this.realm.syncExec(this.fireNodeListeners);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void refreshVariables() {
        this.realm.asyncExec(this.clearValueCache);
        this.fireNodeListeners();
    }

    public void refreshVariablesSync() {
        try {
            this.realm.syncExec(this.clearValueCache);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.fireNodeListenersSync();
    }

    public String getNode(String path) throws NodeManagerException {
        this.checkThreadAccess();
        throw new UnsupportedOperationException();
    }

    public String getChild(String node, String name) throws NodeManagerException {
        this.checkThreadAccess();
        return null;
    }

    public String getProperty(String node, String name) throws NodeManagerException {
        this.checkThreadAccess();
        if (node.equals(ROOT)) {
            return name;
        }
        return null;
    }

    public List<String> getChildren(String node) throws NodeManagerException {
        this.checkThreadAccess();
        return Collections.emptyList();
    }

    public List<String> getProperties(String node) throws NodeManagerException {
        this.checkThreadAccess();
        if (!node.equals(ROOT)) {
            return Collections.emptyList();
        }
        Set variables = this.realm.getConnection().getVariables();
        return new ArrayList<String>(variables);
    }

    public Datatype getDatatype(String node) throws NodeManagerException {
        this.checkThreadAccess();
        try {
            Datatype type = this.getDatatypeForValue(this.getSCLValue(node));
            return type;
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getValue(String node, Binding binding) throws NodeManagerException {
        this.checkThreadAccess();
        return this.getSCLValue(node);
    }

    private Type getType(String name) {
        return this.realm.getConnection().getVariableType(name);
    }

    private Datatype getDatatypeForValue(Object value) throws DatabaseException {
        if (value instanceof Double) {
            return Datatypes.DOUBLE;
        }
        if (value instanceof Float) {
            return Datatypes.FLOAT;
        }
        if (value instanceof Integer) {
            return Datatypes.INTEGER;
        }
        if (value instanceof Long) {
            return Datatypes.LONG;
        }
        if (value instanceof String) {
            return Datatypes.STRING;
        }
        if (value instanceof Boolean) {
            return Datatypes.BOOLEAN;
        }
        if (value instanceof List) {
            return null;
        }
        if (value instanceof Object) {
            return null;
        }
        if (value == null) {
            return null;
        }
        throw new DatabaseException("No Datatype for value " + value);
    }

    public void setValue(String node, Object value, Binding binding) throws NodeManagerException {
        this.checkThreadAccess();
        this.valueCache.put((Object)node, value);
        this.realm.getConnection().setVariable(node, this.getType(node), value);
        this.refreshVariables();
    }

    public Set<String> getClassifications(String node) throws NodeManagerException {
        this.checkThreadAccess();
        if (node.equals(ROOT)) {
            return COMPONENT_CLASS;
        }
        return Collections.emptySet();
    }

    private Object getSCLValue(String node) throws NodeManagerException {
        Object value = this.valueCache.get((Object)node);
        if (value == null) {
            value = this.realm.getConnection().getVariableValue(node);
            this.valueCache.put((Object)node, value);
        }
        return value;
    }

    private void checkThreadAccess() throws NodeManagerException {
        if (Thread.currentThread() != this.realm.getThread()) {
            throw new NotInRealmException();
        }
    }

    public String getPropertyURI(String parent, String property) {
        return "http://www.simantics.org/Modeling-1.2/CommandSession/hasValue";
    }
}

