/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.scl;

import gnu.trove.procedure.TObjectProcedure;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.compiler.source.StringModuleSource;
import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;
import org.simantics.scl.runtime.SCLContext;

public enum GraphModuleSourceRepository implements ModuleSourceRepository
{
    INSTANCE;


    public ModuleSource getModuleSource(String moduleName, UpdateListener listener) {
        if (!moduleName.startsWith("http://")) {
            return null;
        }
        Object graph = SCLContext.getCurrent().get((Object)"graph");
        Object requestProcessor = graph instanceof ReadGraph ? (ReadGraph)graph : Simantics.getSession();
        ReadModuleSource request = new ReadModuleSource(moduleName);
        try {
            if (listener != null) {
                return (ModuleSource)requestProcessor.syncRequest((Read)request, (SyncListener)new ModuleListener(listener, moduleName));
            }
            return (ModuleSource)requestProcessor.syncRequest((Read)request);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void forAllModules(TObjectProcedure<String> procedure) {
    }

    public void checkUpdates() {
    }

    public String getDocumentation(String documentationName) {
        return null;
    }

    public void forAllDocumentations(TObjectProcedure<String> procedure) {
    }

    static class ModuleListener
    implements SyncListener<ModuleSource> {
        UpdateListener listener;
        boolean alreadyExecutedOnce;
        final String moduleName;

        public ModuleListener(UpdateListener listener, String moduleName) {
            this.listener = listener;
            this.moduleName = moduleName;
        }

        public boolean isDisposed() {
            return this.listener == null;
        }

        private void fireUpdate(ReadGraph graph) {
            if (this.listener != null) {
                SCLContext context = SCLContext.getCurrent();
                Object oldGraph = context.put((Object)"graph", (Object)graph);
                try {
                    this.listener.notifyAboutUpdate();
                }
                finally {
                    this.listener = null;
                    context.put((Object)"graph", oldGraph);
                }
            }
        }

        public void execute(ReadGraph graph, ModuleSource result) throws DatabaseException {
            if (this.alreadyExecutedOnce) {
                this.fireUpdate(graph);
            } else {
                this.alreadyExecutedOnce = true;
            }
        }

        public void exception(ReadGraph graph, Throwable t) throws DatabaseException {
            t.printStackTrace();
            if (this.alreadyExecutedOnce && this.listener != null) {
                this.fireUpdate(graph);
            }
        }
    }

    static class ReadModuleSource
    extends UnaryRead<String, ModuleSource> {
        public ReadModuleSource(String moduleName) {
            super((Object)moduleName);
        }

        public ModuleSource perform(ReadGraph graph) throws DatabaseException {
            Resource moduleResource = graph.getPossibleResource((String)this.parameter);
            if (moduleResource == null) {
                return null;
            }
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            if (!graph.isInstanceOf(moduleResource, L0.SCLModule)) {
                return null;
            }
            String text = (String)graph.getRelatedValue(moduleResource, L0.SCLModule_definition);
            return new StringModuleSource((String)this.parameter, ((Object)((Object)this)).getClass().getClassLoader(), text);
        }
    }
}

