/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.requests;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.eclipse.jface.viewers.IFilter;
import org.simantics.db.Resource;
import org.simantics.modeling.requests.Node;
import org.simantics.modeling.requests.Nodes;
import org.simantics.scl.runtime.function.Function1;

public class CollectionResult {
    public final Set<Node> roots = new ConcurrentSkipListSet<Node>();
    private final Set<Node> diagramSet = new ConcurrentSkipListSet<Node>();
    public final List<Node> diagramList = new Vector<Node>();
    public final Map<Resource, Node> diagrams = new ConcurrentHashMap<Resource, Node>();

    public void addDiagram(Resource r, Node n) {
        this.diagramList.add(n);
        this.diagrams.put(r, n);
        this.diagramSet.add(n);
    }

    public Collection<Node> breadthFirstFlatten() {
        return this.breadthFirstFlatten(null);
    }

    public Collection<Node> breadthFirstFlatten(IFilter filter) {
        return Nodes.breadthFirstFlatten(new DiagramFilter(filter), this.roots);
    }

    public Collection<Node> depthFirstFlatten() {
        return this.depthFirstFlatten(null, null);
    }

    public Collection<Node> depthFirstFlatten(IFilter filter, Comparator<? super Node> comparator) {
        return Nodes.depthFirstFlatten(new DiagramFilter(filter), this.roots, comparator);
    }

    public boolean walkTree(Function1<Node, Boolean> f) {
        return Nodes.walkTree(f, this.roots);
    }

    public class DiagramFilter
    implements IFilter {
        private final IFilter proxy;

        public DiagramFilter(IFilter proxy) {
            this.proxy = proxy;
        }

        public boolean select(Object node) {
            return CollectionResult.this.diagramSet.contains(node) && (this.proxy == null || this.proxy.select(node));
        }
    }
}

