/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.adapters;

import java.io.File;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.primitiverequest.PossibleRelatedValue;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.layer0.Layer0;

public class ExportModelActionFactory
implements ActionFactory {
    String format;
    String extension;

    public ExportModelActionFactory(String extension, String format) {
        this.extension = extension;
        this.format = format;
    }

    public Runnable create(Object target_) {
        final Resource target = (Resource)target_;
        return new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                Session session = Simantics.getSession();
                try {
                    Layer0 L0 = Layer0.getInstance((RequestProcessor)session);
                    String name = (String)session.syncRequest((Read)new PossibleRelatedValue(target, L0.HasName, (Binding)Bindings.STRING));
                    FileDialog dialog = new FileDialog(shell, 8192);
                    dialog.setFilterExtensions(new String[]{"*." + ExportModelActionFactory.this.extension});
                    dialog.setFileName(String.valueOf(name) + "." + ExportModelActionFactory.this.extension);
                    String newFileName = dialog.open();
                    if (newFileName == null) {
                        return;
                    }
                    if (!newFileName.endsWith(ExportModelActionFactory.this.extension)) {
                        newFileName = String.valueOf(newFileName) + "." + ExportModelActionFactory.this.extension;
                    }
                    TransferableGraphSource s = (TransferableGraphSource)session.sync((ReadInterface)new ModelTransferableGraphSourceRequest(ExportModelActionFactory.this.createConf(session, target)));
                    TransferableGraphs.writeTransferableGraph((RequestProcessor)session, (String)ExportModelActionFactory.this.format, (int)1, (TransferableGraphSource)s, (File)new File(newFileName));
                }
                catch (Exception e) {
                    Logger.defaultLogError((Throwable)e);
                }
            }
        };
    }

    private TransferableGraphConfiguration2 createConf(Session session, final Resource model) throws DatabaseException {
        return (TransferableGraphConfiguration2)session.sync((ReadInterface)new UniqueRead<TransferableGraphConfiguration2>(){

            public TransferableGraphConfiguration2 perform(ReadGraph graph) throws DatabaseException {
                return new TransferableGraphConfiguration2(graph, model, true, false);
            }
        });
    }
}

