/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.adapters;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.adapter.Remover;
import org.simantics.db.layer0.adapter.impl.AbstractRemover;
import org.simantics.db.layer0.adapter.impl.EntityRemover;
import org.simantics.db.layer0.exception.CannotRemoveException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.adapters.RemoveInstancesDialog;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.BundleUtils;

public class ExistingInstancesRemover
extends AbstractRemover {
    protected String typeDescription;

    public ExistingInstancesRemover(Resource resource, String removedTypeDescription) {
        super(resource);
        this.typeDescription = removedTypeDescription;
    }

    public void remove(WriteGraph graph) throws DatabaseException {
        this.remove(graph, this.resource, this.resource, this.resource);
    }

    protected void remove(WriteGraph graph, Resource resource, Resource typeResource, Resource typeNameResource) throws DatabaseException {
        if (Layer0Utils.isContainerPublished((ReadGraph)graph, (Resource)resource)) {
            throw new CannotRemoveException("Items in published libraries cannot be removed. Please create a new version to perform modifications.");
        }
        Resource root = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(resource));
        if (root == null) {
            this.justRemove(graph);
            return;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String componentTypeName = (String)graph.getPossibleRelatedValue(typeNameResource, L0.HasName, (Binding)Bindings.STRING);
        if (componentTypeName == null) {
            this.justRemove(graph);
            return;
        }
        Set<Resource> instances = this.discoverInstances(graph, typeResource);
        if (!instances.isEmpty()) {
            this.confirmRemoval(graph, instances, this.typeDescription, componentTypeName);
        } else {
            this.justRemove(graph);
        }
    }

    protected Set<Resource> discoverInstances(WriteGraph graph, Resource type) throws DatabaseException {
        Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(type));
        if (indexRoot == null) {
            return Collections.emptySet();
        }
        THashSet result = new THashSet();
        Instances search = (Instances)graph.adapt(type, Instances.class);
        this.discoverInstances(graph, type, indexRoot, search, (Set<Resource>)result);
        result.remove(this.resource);
        return result;
    }

    private void discoverInstances(WriteGraph graph, Resource typeResource, Resource indexRoot, Instances instances, Set<Resource> result) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection rs = instances.find((ReadGraph)graph, indexRoot);
        result.addAll(rs);
        for (Resource linkee : graph.getObjects(indexRoot, L0.IsLinkedTo_Inverse)) {
            this.discoverInstances(graph, typeResource, linkee, instances, result);
        }
    }

    protected void confirmRemoval(WriteGraph graph, final Set<Resource> instances, final String typeDescription, final String typeName) throws DatabaseException {
        Map<Resource, String> instanceAddresses = this.resolveInstanceAddresses((ReadGraph)graph, instances);
        Map<Resource, String> unremovable = this.findUnremovable((ReadGraph)graph, instances);
        final RemoveInstancesDialog.Content[] content = new RemoveInstancesDialog.Content[instanceAddresses.size()];
        int i = 0;
        ImageDescriptor problemImage = BundleUtils.getImageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/error.png");
        for (Map.Entry<Resource, String> entry : instanceAddresses.entrySet()) {
            content[i] = new RemoveInstancesDialog.Content(entry.getValue());
            content[i].details = unremovable.get(entry.getKey());
            if (content[i].details != null) {
                content[i].image = problemImage;
            }
            ++i;
        }
        Arrays.sort(content, new Comparator<RemoveInstancesDialog.Content>(){

            @Override
            public int compare(RemoveInstancesDialog.Content o1, RemoveInstancesDialog.Content o2) {
                return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)o1.label, (Object)o2.label);
            }
        });
        if (!unremovable.isEmpty()) {
            if (PlatformUI.isWorkbenchRunning()) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RemoveInstancesDialog dialog = new RemoveInstancesDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Cannot Remove  " + typeDescription, String.valueOf(typeDescription) + " '" + typeName + "' is still in use and all of its " + instances.size() + " instances cannot be removed.\n\nSelect instances marked with errors from the table below to see why they cannot be removed.", 1, new String[]{IDialogConstants.OK_LABEL}, 0, content);
                        dialog.open();
                    }
                });
            }
            return;
        }
        final Session session = graph.getSession();
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    boolean doIt;
                    RemoveInstancesDialog dialog = new RemoveInstancesDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Remove " + typeDescription + "?", String.valueOf(typeDescription) + " '" + typeName + "' is still in use. Are you sure you want to remove it and all its " + instances.size() + " instances?", content);
                    int result = dialog.open();
                    boolean bl = doIt = result == 0;
                    if (!doIt) {
                        return;
                    }
                    session.asyncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            ExistingInstancesRemover.this.justRemoveWithInstances(graph, instances);
                        }
                    });
                }
            });
        } else {
            this.justRemoveWithInstances(graph, instances);
        }
    }

    protected void justRemoveWithInstances(WriteGraph graph, Collection<Resource> instances) throws DatabaseException {
        for (Resource instance : instances) {
            RemoverUtil.remove((WriteGraph)graph, (Resource)instance);
        }
        this.justRemove(graph);
    }

    protected Map<Resource, String> resolveInstanceAddresses(ReadGraph graph, Set<Resource> instances) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        THashMap result = new THashMap();
        for (Resource instance : instances) {
            String instanceUri;
            Resource component = graph.getPossibleObject(instance, MOD.ElementToComponent);
            if (component != null) {
                instance = component;
            }
            if ((instanceUri = graph.getPossibleURI(instance)) != null) {
                Resource root = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(instance));
                if (root != null) {
                    String rootUri;
                    Resource rootParent = graph.getPossibleObject(root, L0.PartOf);
                    if (rootParent == null) {
                        rootParent = root;
                    }
                    if ((rootUri = graph.getPossibleURI(rootParent)) != null) {
                        String instanceRelativeUri = instanceUri.substring(rootUri.length());
                        result.put(instance, URIStringUtils.unescape((String)instanceRelativeUri));
                        continue;
                    }
                }
                result.put(instance, URIStringUtils.unescape((String)instanceUri));
                continue;
            }
            result.put(instance, NameUtils.getSafeName((ReadGraph)graph, (Resource)instance, (boolean)true));
        }
        return result;
    }

    protected void justRemove(WriteGraph graph) throws DatabaseException {
        graph.deny(this.resource, Layer0.getInstance((ReadGraph)graph).PartOf);
        EntityRemover.remove((WriteGraph)graph, (Resource)this.resource);
    }

    private Map<Resource, String> findUnremovable(ReadGraph graph, Collection<Resource> instances) throws DatabaseException {
        THashMap result = null;
        HashMap aux = new HashMap();
        for (Resource r : instances) {
            Remover remover = (Remover)graph.getPossibleAdapter(r, Remover.class);
            if (remover == null) continue;
            aux.clear();
            String problem = remover.canRemove(graph, aux);
            if (problem == null) continue;
            if (result == null) {
                result = new THashMap();
            }
            result.put(r, problem);
        }
        return result == null ? Collections.emptyMap() : result;
    }
}

